/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.miner;

import java.util.Collections;
import mekanism.api.Object3D;
import mekanism.common.IBoundingBlock;
import mekanism.common.miner.MinerFilter;
import mekanism.common.tileentity.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class ThreadMinerSearch
extends Thread {
    public TileEntityDigitalMiner tileEntity;
    public State state = State.IDLE;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tileEntity = tile;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        if (this.tileEntity.filters.isEmpty()) {
            this.state = State.FINISHED;
            return;
        }
        for (int y = this.tileEntity.maxY; y >= this.tileEntity.minY; --y) {
            for (int x = this.tileEntity.field_70329_l - this.tileEntity.radius; x <= this.tileEntity.field_70329_l + this.tileEntity.radius; ++x) {
                for (int z = this.tileEntity.field_70327_n - this.tileEntity.radius; z <= this.tileEntity.field_70327_n + this.tileEntity.radius; ++z) {
                    if (this.tileEntity.func_70320_p()) {
                        return;
                    }
                    if (Object3D.get(this.tileEntity).equals(new Object3D(x, y, z, this.tileEntity.field_70331_k.field_73011_w.field_76574_g)) || new Object3D(x, y, z).getTileEntity((IBlockAccess)this.tileEntity.field_70331_k) instanceof IBoundingBlock) continue;
                    int blockID = this.tileEntity.field_70331_k.func_72798_a(x, y, z);
                    int meta = this.tileEntity.field_70331_k.func_72805_g(x, y, z);
                    if (blockID == 0) continue;
                    ItemStack stack = new ItemStack(blockID, 1, meta);
                    if (this.tileEntity.replaceStack != null && this.tileEntity.replaceStack.func_77969_a(stack)) continue;
                    for (MinerFilter filter : this.tileEntity.filters) {
                        if (!filter.canFilter(stack)) continue;
                        this.tileEntity.oresToMine.add(new Object3D(x, y, z));
                    }
                }
            }
        }
        Collections.shuffle(this.tileEntity.oresToMine);
        this.state = State.FINISHED;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void reset() {
        this.state = State.IDLE;
    }

    public static enum State {
        IDLE("Not ready"),
        SEARCHING("Searching"),
        PAUSED("Paused"),
        FINISHED("Ready");

        public String desc;

        private State(String s) {
            this.desc = s;
        }
    }
}

