/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.DataOutputStream;
import java.util.ArrayList;
import mekanism.api.Object3D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.ITransmitter;
import mekanism.common.ITileNetwork;
import mekanism.common.PacketHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityDynamicTank;
import mekanism.common.tileentity.TileEntityMechanicalPipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketDataRequest
implements IMekanismPacket {
    public Object3D object3D;

    @Override
    public String getName() {
        return "DataRequest";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.object3D = (Object3D)data[0];
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        int x = dataStream.readInt();
        int y = dataStream.readInt();
        int z = dataStream.readInt();
        int id = dataStream.readInt();
        WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(id);
        if (worldServer != null && worldServer.func_72796_p(x, y, z) instanceof ITileNetwork) {
            TileEntity tileEntity = worldServer.func_72796_p(x, y, z);
            if (tileEntity instanceof TileEntityDynamicTank) {
                ((TileEntityDynamicTank)tileEntity).sendStructure = true;
            }
            if (tileEntity instanceof ITransmitter) {
                ITransmitter transmitter = (ITransmitter)tileEntity;
                if (transmitter.getTransmitterNetwork() instanceof DynamicNetwork) {
                    ((DynamicNetwork)transmitter.getTransmitterNetwork()).addUpdate(player);
                }
                if (!(tileEntity instanceof TileEntityMechanicalPipe)) {
                    return;
                }
            }
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(worldServer.func_72796_p(x, y, z)), ((ITileNetwork)worldServer.func_72796_p(x, y, z)).getNetworkedData(new ArrayList())), new Object[0]);
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.object3D.xCoord);
        dataStream.writeInt(this.object3D.yCoord);
        dataStream.writeInt(this.object3D.zCoord);
        dataStream.writeInt(this.object3D.dimensionId);
    }
}

