/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemJetpack;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PacketJetpackData
implements IMekanismPacket {
    public JetpackPacket packetType;
    public String username;
    public boolean value;

    @Override
    public String getName() {
        return "JetpackData";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.packetType = (JetpackPacket)((Object)data[0]);
        if (this.packetType == JetpackPacket.UPDATE) {
            this.username = (String)data[1];
            this.value = (Boolean)data[2];
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        ItemStack stack;
        this.packetType = JetpackPacket.values()[dataStream.readInt()];
        if (this.packetType == JetpackPacket.FULL) {
            Mekanism.jetpackOn.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                Mekanism.jetpackOn.add(dataStream.readUTF());
            }
        } else if (this.packetType == JetpackPacket.UPDATE) {
            String username = dataStream.readUTF();
            boolean value = dataStream.readBoolean();
            if (value) {
                Mekanism.jetpackOn.add(username);
            } else {
                Mekanism.jetpackOn.remove(username);
            }
            if (!world.field_72995_K) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_DIM, new PacketJetpackData().setParams(new Object[]{JetpackPacket.UPDATE, username, value}), world.field_73011_w.field_76574_g);
            }
        } else if (this.packetType == JetpackPacket.MODE && (stack = player.func_71124_b(3)) != null && stack.func_77973_b() instanceof ItemJetpack) {
            ((ItemJetpack)stack.func_77973_b()).incrementMode(stack);
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.packetType.ordinal());
        if (this.packetType == JetpackPacket.UPDATE) {
            dataStream.writeUTF(this.username);
            dataStream.writeBoolean(this.value);
        } else if (this.packetType == JetpackPacket.FULL) {
            dataStream.writeInt(Mekanism.jetpackOn.size());
            for (String username : Mekanism.jetpackOn) {
                dataStream.writeUTF(username);
            }
        }
    }

    public static enum JetpackPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

