/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataOutputStream;
import mekanism.api.Object3D;
import mekanism.client.gui.GuiLogisticalSorter;
import mekanism.client.gui.GuiTItemStackFilter;
import mekanism.client.gui.GuiTOreDictFilter;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tileentity.TileEntityContainerBlock;
import mekanism.common.tileentity.TileEntityLogisticalSorter;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketLogisticalSorterGui
implements IMekanismPacket {
    public Object3D object3D;
    public SorterGuiPacket packetType;
    public int type;
    public int windowId = -1;
    public int index = -1;

    @Override
    public String getName() {
        return "LogisticalSorterGui";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.packetType = (SorterGuiPacket)((Object)data[0]);
        this.object3D = (Object3D)data[1];
        this.type = (Integer)data[2];
        if (this.packetType == SorterGuiPacket.CLIENT) {
            this.windowId = (Integer)data[3];
        } else if (this.packetType == SorterGuiPacket.SERVER_INDEX) {
            this.index = (Integer)data[3];
        } else if (this.packetType == SorterGuiPacket.CLIENT_INDEX) {
            this.windowId = (Integer)data[3];
            this.index = (Integer)data[4];
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        this.packetType = SorterGuiPacket.values()[dataStream.readInt()];
        this.object3D = new Object3D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
        this.type = dataStream.readInt();
        if (this.packetType == SorterGuiPacket.CLIENT || this.packetType == SorterGuiPacket.CLIENT_INDEX) {
            this.windowId = dataStream.readInt();
        }
        if (this.packetType == SorterGuiPacket.SERVER_INDEX || this.packetType == SorterGuiPacket.CLIENT_INDEX) {
            this.index = dataStream.readInt();
        }
        if (!world.field_72995_K) {
            WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.object3D.dimensionId);
            if (worldServer != null && this.object3D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityLogisticalSorter) {
                PacketLogisticalSorterGui.openServerGui(this.packetType, this.type, (World)worldServer, (EntityPlayerMP)player, this.object3D, this.index);
            }
        } else if (this.object3D.getTileEntity((IBlockAccess)world) instanceof TileEntityLogisticalSorter) {
            try {
                if (this.packetType == SorterGuiPacket.CLIENT) {
                    FMLCommonHandler.instance().showGuiScreen((Object)this.getGui(this.packetType, this.type, player, world, this.object3D.xCoord, this.object3D.yCoord, this.object3D.zCoord, -1));
                } else if (this.packetType == SorterGuiPacket.CLIENT_INDEX) {
                    FMLCommonHandler.instance().showGuiScreen((Object)this.getGui(this.packetType, this.type, player, world, this.object3D.xCoord, this.object3D.yCoord, this.object3D.zCoord, this.index));
                }
                player.field_71070_bA.field_75152_c = this.windowId;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void openServerGui(SorterGuiPacket t, int guiType, World world, EntityPlayerMP playerMP, Object3D obj, int i) {
        Container container = null;
        playerMP.func_71128_l();
        if (guiType == 0) {
            container = new ContainerNull((EntityPlayer)playerMP, (TileEntityContainerBlock)obj.getTileEntity((IBlockAccess)world));
        } else if (guiType == 1 || guiType == 2) {
            container = new ContainerFilter(playerMP.field_71071_by, (TileEntityContainerBlock)obj.getTileEntity((IBlockAccess)world));
        }
        playerMP.func_71117_bO();
        int window = playerMP.field_71139_cq;
        if (t == SorterGuiPacket.SERVER) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketLogisticalSorterGui().setParams(new Object[]{SorterGuiPacket.CLIENT, obj, guiType, window}), playerMP);
        } else if (t == SorterGuiPacket.SERVER_INDEX) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketLogisticalSorterGui().setParams(new Object[]{SorterGuiPacket.CLIENT_INDEX, obj, guiType, window, i}), playerMP);
        }
        playerMP.field_71070_bA = container;
        playerMP.field_71070_bA.field_75152_c = window;
        playerMP.field_71070_bA.func_75132_a((ICrafting)playerMP);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(SorterGuiPacket packetType, int type, EntityPlayer player, World world, int x, int y, int z, int index) {
        if (type == 0) {
            return new GuiLogisticalSorter(player, (TileEntityLogisticalSorter)world.func_72796_p(x, y, z));
        }
        if (packetType == SorterGuiPacket.CLIENT) {
            if (type == 1) {
                return new GuiTItemStackFilter(player, (TileEntityLogisticalSorter)world.func_72796_p(x, y, z));
            }
            if (type == 2) {
                return new GuiTOreDictFilter(player, (TileEntityLogisticalSorter)world.func_72796_p(x, y, z));
            }
        } else if (packetType == SorterGuiPacket.CLIENT_INDEX) {
            if (type == 1) {
                return new GuiTItemStackFilter(player, (TileEntityLogisticalSorter)world.func_72796_p(x, y, z), index);
            }
            if (type == 2) {
                return new GuiTOreDictFilter(player, (TileEntityLogisticalSorter)world.func_72796_p(x, y, z), index);
            }
        }
        return null;
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.packetType.ordinal());
        dataStream.writeInt(this.object3D.xCoord);
        dataStream.writeInt(this.object3D.yCoord);
        dataStream.writeInt(this.object3D.zCoord);
        dataStream.writeInt(this.object3D.dimensionId);
        dataStream.writeInt(this.type);
        if (this.packetType == SorterGuiPacket.CLIENT || this.packetType == SorterGuiPacket.CLIENT_INDEX) {
            dataStream.writeInt(this.windowId);
        }
        if (this.packetType == SorterGuiPacket.SERVER_INDEX || this.packetType == SorterGuiPacket.CLIENT_INDEX) {
            dataStream.writeInt(this.index);
        }
    }

    public static enum SorterGuiPacket {
        SERVER,
        CLIENT,
        SERVER_INDEX,
        CLIENT_INDEX;

    }
}

