/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.DataOutputStream;
import java.util.ArrayList;
import mekanism.api.Object3D;
import mekanism.common.PacketHandler;
import mekanism.common.miner.MinerFilter;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityDigitalMiner;
import mekanism.common.tileentity.TileEntityLogisticalSorter;
import mekanism.common.transporter.TransporterFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketNewFilter
implements IMekanismPacket {
    public Object3D object3D;
    public TransporterFilter tFilter;
    public MinerFilter mFilter;
    public byte type = (byte)-1;

    @Override
    public String getName() {
        return "NewFilter";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.object3D = (Object3D)data[0];
        if (data[1] instanceof TransporterFilter) {
            this.tFilter = (TransporterFilter)data[1];
            this.type = 0;
        } else if (data[1] instanceof MinerFilter) {
            this.mFilter = (MinerFilter)data[1];
            this.type = 1;
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        block2: {
            WorldServer worldServer;
            block3: {
                this.object3D = new Object3D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                this.type = dataStream.readByte();
                worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.object3D.dimensionId);
                if (worldServer == null) break block2;
                if (this.type != 0 || !(this.object3D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityLogisticalSorter)) break block3;
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)this.object3D.getTileEntity((IBlockAccess)worldServer);
                TransporterFilter filter = TransporterFilter.readFromPacket(dataStream);
                sorter.filters.add(filter);
                for (EntityPlayer iterPlayer : sorter.playersUsing) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Object3D.get(sorter), sorter.getFilterPacket(new ArrayList())), iterPlayer);
                }
                break block2;
            }
            if (this.type != 1 || !(this.object3D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityDigitalMiner)) break block2;
            TileEntityDigitalMiner miner = (TileEntityDigitalMiner)this.object3D.getTileEntity((IBlockAccess)worldServer);
            MinerFilter filter = MinerFilter.readFromPacket(dataStream);
            miner.filters.add(filter);
            for (EntityPlayer iterPlayer : miner.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Object3D.get(miner), miner.getFilterPacket(new ArrayList())), iterPlayer);
            }
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.object3D.xCoord);
        dataStream.writeInt(this.object3D.yCoord);
        dataStream.writeInt(this.object3D.zCoord);
        dataStream.writeInt(this.object3D.dimensionId);
        dataStream.writeByte(this.type);
        ArrayList data = new ArrayList();
        if (this.type == 0) {
            this.tFilter.write(data);
        } else if (this.type == 1) {
            this.mFilter.write(data);
        }
        PacketHandler.encode(data.toArray(), dataStream);
    }
}

