/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.api.Object3D;
import mekanism.common.IUpgradeManagement;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tileentity.TileEntityBasicBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketRemoveUpgrade
implements IMekanismPacket {
    public Object3D object3D;
    public byte upgradeType;

    @Override
    public String getName() {
        return "RemoveUpgrade";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.object3D = (Object3D)data[0];
        this.upgradeType = (Byte)data[1];
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        int x = dataStream.readInt();
        int y = dataStream.readInt();
        int z = dataStream.readInt();
        byte type = dataStream.readByte();
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IUpgradeManagement && tileEntity instanceof TileEntityBasicBlock) {
            IUpgradeManagement upgradeTile = (IUpgradeManagement)tileEntity;
            if (type == 0) {
                if (upgradeTile.getSpeedMultiplier(new Object[0]) > 0 && player.field_71071_by.func_70441_a(new ItemStack(Mekanism.SpeedUpgrade))) {
                    upgradeTile.setSpeedMultiplier(upgradeTile.getSpeedMultiplier(new Object[0]) - 1, new Object[0]);
                }
            } else if (type == 1 && upgradeTile.getEnergyMultiplier(new Object[0]) > 0 && player.field_71071_by.func_70441_a(new ItemStack(Mekanism.EnergyUpgrade))) {
                upgradeTile.setEnergyMultiplier(upgradeTile.getEnergyMultiplier(new Object[0]) - 1, new Object[0]);
            }
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.object3D.xCoord);
        dataStream.writeInt(this.object3D.yCoord);
        dataStream.writeInt(this.object3D.zCoord);
        dataStream.writeByte(this.upgradeType);
    }
}

