/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PacketScubaTankData
implements IMekanismPacket {
    public ScubaTankPacket packetType;
    public String username;
    public boolean value;

    @Override
    public String getName() {
        return "ScubaTankData";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.packetType = (ScubaTankPacket)((Object)data[0]);
        if (this.packetType == ScubaTankPacket.UPDATE) {
            this.username = (String)data[1];
            this.value = (Boolean)data[2];
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        ItemStack stack;
        this.packetType = ScubaTankPacket.values()[dataStream.readInt()];
        if (this.packetType == ScubaTankPacket.FULL) {
            Mekanism.gasmaskOn.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                Mekanism.gasmaskOn.add(dataStream.readUTF());
            }
        } else if (this.packetType == ScubaTankPacket.UPDATE) {
            String username = dataStream.readUTF();
            boolean value = dataStream.readBoolean();
            if (value) {
                Mekanism.gasmaskOn.add(username);
            } else {
                Mekanism.gasmaskOn.remove(username);
            }
            if (!world.field_72995_K) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_DIM, new PacketScubaTankData().setParams(new Object[]{ScubaTankPacket.UPDATE, username, value}), world.field_73011_w.field_76574_g);
            }
        } else if (this.packetType == ScubaTankPacket.MODE && (stack = player.func_71124_b(3)) != null && stack.func_77973_b() instanceof ItemScubaTank) {
            ((ItemScubaTank)stack.func_77973_b()).toggleFlowing(stack);
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.packetType.ordinal());
        if (this.packetType == ScubaTankPacket.UPDATE) {
            dataStream.writeUTF(this.username);
            dataStream.writeBoolean(this.value);
        } else if (this.packetType == ScubaTankPacket.FULL) {
            dataStream.writeInt(Mekanism.gasmaskOn.size());
            for (String username : Mekanism.gasmaskOn) {
                dataStream.writeUTF(username);
            }
        }
    }

    public static enum ScubaTankPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

