/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasRegistry;
import mekanism.api.transmitters.ITransmitter;
import mekanism.common.EnergyNetwork;
import mekanism.common.FluidNetwork;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tileentity.TileEntityMechanicalPipe;
import mekanism.common.tileentity.TileEntityPressurizedTube;
import mekanism.common.tileentity.TileEntityUniversalCable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class PacketTransmitterUpdate
implements IMekanismPacket {
    public PacketType packetType;
    public TileEntity tileEntity;
    public double power;
    public int gasType;
    public boolean didGasTransfer;
    public int fluidType;
    public boolean didFluidTransfer;

    @Override
    public String getName() {
        return "TransmitterUpdate";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.packetType = (PacketType)((Object)data[0]);
        this.tileEntity = (TileEntity)data[1];
        switch (this.packetType) {
            case ENERGY: {
                this.power = (Double)data[2];
                break;
            }
            case GAS: {
                this.gasType = (Integer)data[2];
                this.didGasTransfer = (Boolean)data[3];
                break;
            }
            case FLUID: {
                this.fluidType = (Integer)data[2];
                this.didFluidTransfer = (Boolean)data[3];
            }
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        TileEntity tileEntity;
        ITransmitter transmitter;
        int transmitterType = dataStream.readInt();
        int x = dataStream.readInt();
        int y = dataStream.readInt();
        int z = dataStream.readInt();
        if (transmitterType == 0 && (transmitter = (ITransmitter)world.func_72796_p(x, y, z)) != null) {
            transmitter.refreshTransmitterNetwork();
        }
        if (transmitterType == 1) {
            double powerLevel = dataStream.readDouble();
            TileEntity tileEntity2 = world.func_72796_p(x, y, z);
            if (tileEntity2 != null) {
                ((EnergyNetwork)((TileEntityUniversalCable)tileEntity2).getTransmitterNetwork()).clientEnergyScale = powerLevel;
            }
        } else if (transmitterType == 2) {
            tileEntity = world.func_72796_p(x, y, z);
            Gas gasType = GasRegistry.getGas(dataStream.readInt());
            this.didGasTransfer = dataStream.readBoolean();
            if (tileEntity != null) {
                ((GasNetwork)((TileEntityPressurizedTube)tileEntity).getTransmitterNetwork()).refGas = gasType;
                ((GasNetwork)((TileEntityPressurizedTube)tileEntity).getTransmitterNetwork()).didTransfer = this.didGasTransfer;
            }
        } else if (transmitterType == 3) {
            tileEntity = world.func_72796_p(x, y, z);
            int type = dataStream.readInt();
            Fluid fluidType = type != -1 ? FluidRegistry.getFluid((int)type) : null;
            this.didFluidTransfer = dataStream.readBoolean();
            if (tileEntity != null) {
                ((FluidNetwork)((TileEntityMechanicalPipe)tileEntity).getTransmitterNetwork()).refFluid = fluidType;
                ((FluidNetwork)((TileEntityMechanicalPipe)tileEntity).getTransmitterNetwork()).didTransfer = this.didFluidTransfer;
            }
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.packetType.ordinal());
        dataStream.writeInt(this.tileEntity.field_70329_l);
        dataStream.writeInt(this.tileEntity.field_70330_m);
        dataStream.writeInt(this.tileEntity.field_70327_n);
        switch (this.packetType) {
            case ENERGY: {
                dataStream.writeDouble(this.power);
                break;
            }
            case GAS: {
                dataStream.writeInt(this.gasType);
                dataStream.writeBoolean(this.didGasTransfer);
                break;
            }
            case FLUID: {
                dataStream.writeInt(this.fluidType);
                dataStream.writeBoolean(this.didFluidTransfer);
            }
        }
    }

    public static enum PacketType {
        UPDATE,
        ENERGY,
        GAS,
        FLUID;

    }
}

