/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.RecipeHandler;
import mekanism.common.SideData;
import mekanism.common.TileComponentEjector;
import mekanism.common.TileComponentUpgrade;
import mekanism.common.tileentity.TileEntityBasicMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public abstract class TileEntityAdvancedElectricMachine
extends TileEntityBasicMachine {
    public int SECONDARY_ENERGY_PER_TICK;
    public int MAX_SECONDARY_ENERGY;
    public int secondaryEnergyStored = 0;

    public TileEntityAdvancedElectricMachine(String soundPath, String name, ResourceLocation location, double perTick, int secondaryPerTick, int ticksRequired, double maxEnergy, int maxSecondaryEnergy) {
        super(soundPath, name, location, perTick, ticksRequired, maxEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{2}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{3}));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, new int[]{4}));
        this.sideConfig = new byte[]{2, 1, 0, 4, 5, 3};
        this.inventory = new ItemStack[5];
        this.SECONDARY_ENERGY_PER_TICK = secondaryPerTick;
        this.MAX_SECONDARY_ENERGY = maxSecondaryEnergy;
        this.upgradeComponent = new TileComponentUpgrade(this, 4);
        this.ejectorComponent = new TileComponentEjector(this, (SideData)this.sideOutputs.get(3));
    }

    public abstract int getFuelTicks(ItemStack var1);

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.discharge(3, this);
            this.handleSecondaryFuel();
            if (this.canOperate() && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK) && this.secondaryEnergyStored >= this.SECONDARY_ENERGY_PER_TICK) {
                this.setActive(true);
                ++this.operatingTicks;
                this.secondaryEnergyStored -= this.SECONDARY_ENERGY_PER_TICK;
                this.electricityStored -= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK);
                if (this.operatingTicks >= MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), this.TICKS_REQUIRED)) {
                    this.operate();
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate()) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public void handleSecondaryFuel() {
        if (this.inventory[1] != null) {
            int fuelTicks = this.getFuelTicks(this.inventory[1]);
            int energyNeeded = this.MAX_SECONDARY_ENERGY - this.secondaryEnergyStored;
            if (fuelTicks > 0 && fuelTicks <= energyNeeded) {
                if (fuelTicks <= energyNeeded) {
                    this.setSecondaryEnergy(this.secondaryEnergyStored + fuelTicks);
                } else if (fuelTicks > energyNeeded) {
                    this.setSecondaryEnergy(this.secondaryEnergyStored + energyNeeded);
                }
                --this.inventory[1].field_77994_a;
                if (this.inventory[1].field_77994_a == 0) {
                    this.inventory[1] = null;
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 4) {
            return itemstack.field_77993_c == Mekanism.SpeedUpgrade.field_77779_bT || itemstack.field_77993_c == Mekanism.EnergyUpgrade.field_77779_bT;
        }
        if (slotID == 0) {
            return RecipeHandler.getOutput(itemstack, false, this.getRecipes()) != null;
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 1) {
            return this.getFuelTicks(itemstack) > 0;
        }
        return false;
    }

    @Override
    public void operate() {
        ItemStack itemstack = RecipeHandler.getOutput(this.inventory[0], true, this.getRecipes());
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack;
        } else {
            this.inventory[2].field_77994_a += itemstack.field_77994_a;
        }
        this.func_70296_d();
        this.ejectorComponent.onOutput();
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = RecipeHandler.getOutput(this.inventory[0], false, this.getRecipes());
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemstack)) {
            return false;
        }
        return this.inventory[2].field_77994_a + itemstack.field_77994_a <= this.inventory[2].func_77976_d();
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.secondaryEnergyStored = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.secondaryEnergyStored);
        return data;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.secondaryEnergyStored = nbtTags.func_74762_e("secondaryEnergyStored");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("secondaryEnergyStored", this.secondaryEnergyStored);
    }

    public void setSecondaryEnergy(int energy) {
        this.secondaryEnergyStored = Math.max(Math.min(energy, this.MAX_SECONDARY_ENERGY), 0);
    }

    public int getScaledSecondaryEnergyLevel(int i) {
        return this.secondaryEnergyStored * i / this.MAX_SECONDARY_ENERGY;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getSecondaryStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.secondaryEnergyStored};
            }
            case 2: {
                return new Object[]{this.operatingTicks};
            }
            case 3: {
                return new Object[]{this.isActive};
            }
            case 4: {
                return new Object[]{this.facing};
            }
            case 5: {
                return new Object[]{this.canOperate()};
            }
            case 6: {
                return new Object[]{MekanismUtils.getEnergy(this.getEnergyMultiplier(new Object[0]), this.getMaxEnergy())};
            }
            case 7: {
                return new Object[]{MekanismUtils.getEnergy(this.getEnergyMultiplier(new Object[0]), this.getMaxEnergy()) - this.getEnergy()};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }
}

