/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Object3D;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasStorage;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.IActiveState;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.RecipeHandler;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityChemicalFormulator
extends TileEntityElectricBlock
implements IActiveState,
IGasStorage,
ITubeConnection,
IRedstoneControl {
    public GasStack gasTank;
    public static final int MAX_GAS = 10000;
    public int updateDelay;
    public int gasOutput = 16;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public int operatingTicks = 0;
    public int TICKS_REQUIRED = 100;
    public final double ENERGY_USAGE = Mekanism.rotaryCondensentratorUsage;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityChemicalFormulator() {
        super("ChemicalFormulator", 0.0);
        this.inventory = new ItemStack[3];
    }

    @Override
    public void onUpdate() {
        if (this.field_70331_k.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            }
            ChargeUtils.discharge(1, this);
            if (this.getGas(new Object[0]) != null && this.inventory[2] != null) {
                this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - GasTransmission.addGas(this.inventory[2], this.getGas(new Object[0]))), new Object[0]);
            }
            if (this.canOperate() && this.getEnergy() >= this.ENERGY_USAGE && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.ENERGY_USAGE);
                if (this.operatingTicks < this.TICKS_REQUIRED) {
                    ++this.operatingTicks;
                } else {
                    GasStack stack = RecipeHandler.getChemicalFormulatorOutput(this.inventory[0], true);
                    this.setGas(new GasStack(stack.getGas(), this.getStoredGas() + stack.amount), new Object[0]);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
            if (this.getGas(new Object[0]) != null) {
                GasStack toSend = new GasStack(this.getGas(new Object[0]).getGas(), Math.min(this.getGas((Object[])new Object[0]).amount, this.gasOutput));
                this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - GasTransmission.emitGasToNetwork(toSend, this, MekanismUtils.getLeft(this.facing))), new Object[0]);
                TileEntity tileEntity = Object3D.get(this).getFromSide(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity instanceof IGasAcceptor && ((IGasAcceptor)tileEntity).canReceiveGas(MekanismUtils.getLeft(this.facing).getOpposite(), this.getGas(new Object[0]).getGas())) {
                    int added = ((IGasAcceptor)tileEntity).receiveGas(new GasStack(this.getGas(new Object[0]).getGas(), Math.min(this.getGas((Object[])new Object[0]).amount, this.gasOutput)));
                    this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - added), new Object[0]);
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.getChemicalFormulatorOutput(itemstack, false) != null;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 2) {
            return this.inventory[2] != null && this.inventory[2].func_77973_b() instanceof IGasItem && ((IGasItem)this.inventory[2].func_77973_b()).canProvideGas(this.inventory[2], null);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == MekanismUtils.getLeft(this.facing).ordinal()) {
            return new int[]{0};
        }
        if (side == 0 || side == 1) {
            return new int[]{1};
        }
        if (side == MekanismUtils.getRight(this.facing).ordinal()) {
            return new int[]{2};
        }
        return InventoryUtils.EMPTY;
    }

    public int getStoredGas() {
        return this.gasTank != null ? this.gasTank.amount : 0;
    }

    public int getScaledProgress(int i) {
        return this.operatingTicks * i / this.TICKS_REQUIRED;
    }

    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        GasStack stack = RecipeHandler.getChemicalFormulatorOutput(this.inventory[0], false);
        return stack != null && (this.getGas(new Object[0]) == null || this.getGas(new Object[0]).getGas() == stack.getGas() && this.getMaxGas(new Object[0]) - this.getGas((Object[])new Object[0]).amount >= stack.amount);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.operatingTicks = dataStream.readInt();
        this.gasTank = dataStream.readBoolean() ? new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()) : null;
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.operatingTicks);
        if (this.gasTank != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getID());
            data.add(this.gasTank.amount);
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.gasTank = GasStack.readFromNBT(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        if (this.gasTank != null) {
            nbtTags.func_74766_a("gasTank", this.gasTank.write(new NBTTagCompound()));
        }
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank != null ? this.gasTank.amount * i / 10000 : 0;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public GasStack getGas(Object ... data) {
        return this.gasTank;
    }

    @Override
    public void setGas(GasStack stack, Object ... data) {
        this.gasTank = stack == null || stack.amount == 0 ? null : new GasStack(stack.getGas(), Math.max(Math.min(stack.amount, this.getMaxGas(new Object[0])), 0));
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getMaxGas(Object ... data) {
        return 10000;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }
}

