/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityLogisticalTransporter;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatMessageComponent;

public class TileEntityDiversionTransporter
extends TileEntityLogisticalTransporter {
    public int[] modes = new int[]{0, 0, 0, 0, 0, 0};

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.modes = nbtTags.func_74759_k("modes");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74783_a("modes", this.modes);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.modes[0] = dataStream.readInt();
        this.modes[1] = dataStream.readInt();
        this.modes[2] = dataStream.readInt();
        this.modes[3] = dataStream.readInt();
        this.modes[4] = dataStream.readInt();
        this.modes[5] = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data = super.getNetworkedData(data);
        data.add(this.modes[0]);
        data.add(this.modes[1]);
        data.add(this.modes[2]);
        data.add(this.modes[3]);
        data.add(this.modes[4]);
        data.add(this.modes[5]);
        return data;
    }

    @Override
    public ArrayList getSyncPacket(TransporterStack stack, boolean kill) {
        ArrayList data = super.getSyncPacket(stack, kill);
        data.add(this.modes[0]);
        data.add(this.modes[1]);
        data.add(this.modes[2]);
        data.add(this.modes[3]);
        data.add(this.modes[4]);
        data.add(this.modes[5]);
        return data;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        int newMode = (this.modes[side] + 1) % 3;
        String description = "ERROR";
        this.modes[side] = newMode;
        switch (newMode) {
            case 0: {
                description = MekanismUtils.localize("control.disabled.desc");
                break;
            }
            case 1: {
                description = MekanismUtils.localize("control.high.desc");
                break;
            }
            case 2: {
                description = MekanismUtils.localize("control.low.desc");
            }
        }
        player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.configurator.toggleDiverter") + ": " + (Object)((Object)EnumColor.RED) + description)));
        PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), Object3D.get(this), 50.0);
        return true;
    }
}

