/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import com.google.common.io.ByteArrayDataInput;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Object3D;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.ITileNetwork;
import mekanism.common.Mekanism;
import mekanism.common.tileentity.TileEntityContainerBlock;
import mekanism.common.tileentity.TileEntityUniversalCable;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.block.IElectricalStorage;
import universalelectricity.core.electricity.ElectricityPack;

public abstract class TileEntityElectricBlock
extends TileEntityContainerBlock
implements ITileNetwork,
IPowerReceptor,
IEnergyTile,
IElectrical,
IElectricalStorage,
IConnector,
IStrictEnergyStorage,
IEnergyHandler,
IEnergySink,
IEnergyStorage,
IStrictEnergyAcceptor,
ICableOutputter {
    public double electricityStored;
    public double MAX_ELECTRICITY;
    public PowerHandler powerHandler;

    public TileEntityElectricBlock(String name, double maxEnergy) {
        super(name);
        this.MAX_ELECTRICITY = maxEnergy;
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.STORAGE);
        this.powerHandler.configurePowerPerdition(0, 0);
        this.powerHandler.configure(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void register() {
        if (!this.field_70331_k.field_72995_K && !Mekanism.ic2Registered.contains(Object3D.get(this))) {
            Mekanism.ic2Registered.add(Object3D.get(this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    @Override
    public void onUpdate() {
        this.reconfigure();
    }

    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    protected EnumSet<ForgeDirection> getConsumingSides() {
        EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
        set.remove(ForgeDirection.UNKNOWN);
        return set;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return this.getConsumingSides().contains(direction) || this.getOutputtingSides().contains(direction);
    }

    @Override
    public double getEnergy() {
        return this.electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        this.electricityStored = Math.max(Math.min(energy, this.getMaxEnergy()), 0.0);
        MekanismUtils.saveChunk(this);
    }

    @Override
    public double getMaxEnergy() {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public float getVoltage() {
        return (float)(120.0 * Mekanism.TO_UE);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.setEnergy(dataStream.readDouble());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.getEnergy());
        return data;
    }

    public void onChunkUnload() {
        if (!this.field_70331_k.field_72995_K) {
            Mekanism.ic2Registered.remove(Object3D.get(this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        super.onChunkUnload();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.electricityStored = nbtTags.func_74769_h("electricityStored");
        this.reconfigure();
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74780_a("electricityStored", this.getEnergy());
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    protected void reconfigure() {
        if (MekanismUtils.useBuildcraft()) {
            this.powerHandler.configure(1.0f, (float)((this.getMaxEnergy() - this.getEnergy()) * Mekanism.TO_BC), 0.0f, (float)(this.getMaxEnergy() * Mekanism.TO_BC));
        }
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (this.powerHandler.getEnergyStored() > 0.0f) {
            if (this.getEnergy() < this.getMaxEnergy()) {
                this.setEnergy(this.getEnergy() + (double)this.powerHandler.useEnergy(0.0f, (float)((this.getMaxEnergy() - this.getEnergy()) * Mekanism.TO_BC), true) * Mekanism.FROM_BC);
            }
            this.powerHandler.setEnergy(0.0f);
        }
        this.reconfigure();
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    @Override
    public float receiveElectricity(ForgeDirection from, ElectricityPack receive, boolean doReceive) {
        if (this.getConsumingSides().contains(from)) {
            double toAdd = Math.min(this.getMaxEnergy() - this.getEnergy(), (double)receive.getWatts() * Mekanism.FROM_UE);
            if (doReceive) {
                this.setEnergy(this.getEnergy() + toAdd);
            }
            return (float)(toAdd * Mekanism.TO_UE);
        }
        return 0.0f;
    }

    @Override
    public ElectricityPack provideElectricity(ForgeDirection from, ElectricityPack request, boolean doProvide) {
        if (this.getOutputtingSides().contains(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)request.getWatts() * Mekanism.FROM_UE));
            if (doProvide) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return ElectricityPack.getFromWatts((float)(toSend * Mekanism.TO_UE), this.getVoltage());
        }
        return new ElectricityPack();
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        if (this.getConsumingSides().contains(direction)) {
            return this.getMaxEnergyStored() - this.getEnergyStored();
        }
        return 0.0f;
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        return this.getOutputtingSides().contains(direction) ? Math.min(this.getEnergyStored(), (float)(this.getMaxOutput() * Mekanism.TO_UE)) : 0.0f;
    }

    @Override
    public void setEnergyStored(float energy) {
        this.setEnergy((double)energy * Mekanism.FROM_UE);
    }

    @Override
    public float getEnergyStored() {
        return (float)(this.getEnergy() * Mekanism.TO_UE);
    }

    @Override
    public float getMaxEnergyStored() {
        return (float)(this.getMaxEnergy() * Mekanism.TO_UE);
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.getEnergy() * (double)i / this.getMaxEnergy());
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getConsumingSides().contains(from)) {
            double toAdd = (int)Math.min(this.getMaxEnergy() - this.getEnergy(), (double)maxReceive * Mekanism.FROM_TE);
            if (!simulate) {
                this.setEnergy(this.getEnergy() + toAdd);
            }
            return (int)Math.round(toAdd * Mekanism.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.getOutputtingSides().contains(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * Mekanism.FROM_TE));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return (int)Math.round(toSend * Mekanism.TO_TE);
        }
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return this.canConnect(from);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getEnergy() * Mekanism.TO_TE);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getMaxEnergy() * Mekanism.TO_TE);
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setStored(int energy) {
        this.setEnergy((double)energy * Mekanism.FROM_IC2);
    }

    @Override
    public int addEnergy(int amount) {
        this.setEnergy(this.getEnergy() + (double)amount * Mekanism.FROM_IC2);
        return (int)Math.round(this.getEnergy() * Mekanism.TO_IC2);
    }

    @Override
    public boolean isTeleporterCompatible(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }

    @Override
    public boolean canOutputTo(ForgeDirection side) {
        return this.getOutputtingSides().contains(side);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !this.getOutputtingSides().contains(direction);
    }

    @Override
    public int getStored() {
        return (int)Math.round(this.getEnergy() * Mekanism.TO_IC2);
    }

    @Override
    public int getCapacity() {
        return (int)Math.round(this.getMaxEnergy() * Mekanism.TO_IC2);
    }

    @Override
    public int getOutput() {
        return (int)Math.round(this.getMaxOutput() * Mekanism.TO_IC2);
    }

    @Override
    public double demandedEnergyUnits() {
        return (this.getMaxEnergy() - this.getEnergy()) * Mekanism.TO_IC2;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return !this.getOutputtingSides().contains(side);
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * Mekanism.TO_IC2;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection direction, double i) {
        if (Object3D.get(this).getFromSide(direction).getTileEntity((IBlockAccess)this.field_70331_k) instanceof TileEntityUniversalCable) {
            return i;
        }
        return this.transferEnergyToAcceptor(direction, i * Mekanism.FROM_IC2) * Mekanism.TO_IC2;
    }

    @Override
    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.getConsumingSides().contains(side)) {
            return amount;
        }
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() + toUse);
        return amount - toUse;
    }
}

