/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasStorage;
import mekanism.api.gas.ITubeConnection;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IEjector;
import mekanism.common.IFactory;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.IUpgradeTile;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Tier;
import mekanism.common.TileComponentEjector;
import mekanism.common.TileComponentUpgrade;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityFactory
extends TileEntityElectricBlock
implements IPeripheral,
IActiveState,
IInvConfiguration,
IUpgradeTile,
IHasSound,
IRedstoneControl,
IGasAcceptor,
IGasStorage,
ITubeConnection {
    public Tier.FactoryTier tier;
    public byte[] sideConfig = new byte[]{5, 4, 0, 3, 2, 1};
    public ArrayList<SideData> sideOutputs = new ArrayList();
    public int[] progress;
    public int TICKS_REQUIRED = 200;
    public double ENERGY_PER_TICK = Mekanism.factoryUsage;
    public int RECIPE_TICKS_REQUIRED = 40;
    public int recipeTicks;
    public boolean clientActive;
    public boolean isActive;
    public int updateDelay;
    public int recipeType;
    public double prevEnergy;
    public boolean sorting;
    public int secondaryEnergyStored;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 0);
    public TileComponentEjector ejectorComponent;

    public TileEntityFactory() {
        this(Tier.FactoryTier.BASIC, BlockMachine.MachineType.BASIC_FACTORY);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, new int[]{4}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, new int[]{5, 6, 7}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{8, 9, 10}));
        this.ejectorComponent = new TileComponentEjector(this, this.sideOutputs.get(5));
    }

    public TileEntityFactory(Tier.FactoryTier type, BlockMachine.MachineType machine) {
        super(type.name + "Factory", machine.baseEnergy);
        this.tier = type;
        this.inventory = new ItemStack[5 + type.processes * 2];
        this.progress = new int[type.processes];
        this.isActive = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            }
            ChargeUtils.discharge(1, this);
            this.handleSecondaryFuel();
            this.sortInventory();
            if (this.inventory[2] != null && this.inventory[3] == null) {
                Enum toSet = null;
                for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
                    if (!this.inventory[2].func_77969_a(type.getStack())) continue;
                    toSet = type;
                    break;
                }
                if (toSet != null && this.recipeType != toSet.ordinal()) {
                    if (this.recipeTicks < this.RECIPE_TICKS_REQUIRED) {
                        ++this.recipeTicks;
                    } else if (this.recipeTicks == this.RECIPE_TICKS_REQUIRED) {
                        this.recipeTicks = 0;
                        this.inventory[2] = null;
                        this.inventory[3] = this.getMachineStack();
                        this.recipeType = toSet.ordinal();
                        this.setSecondaryEnergy(0);
                        MekanismUtils.saveChunk(this);
                    }
                } else {
                    this.recipeTicks = 0;
                }
            } else {
                this.recipeTicks = 0;
            }
            for (int process = 0; process < this.tier.processes; ++process) {
                if (MekanismUtils.canFunction(this) && this.canOperate(this.getInputSlot(process), this.getOutputSlot(process)) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK) && this.secondaryEnergyStored >= this.getSecondaryEnergyPerTick()) {
                    if (this.progress[process] + 1 < MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), this.TICKS_REQUIRED)) {
                        int n = process;
                        this.progress[n] = this.progress[n] + 1;
                        this.secondaryEnergyStored -= this.getSecondaryEnergyPerTick();
                        this.electricityStored -= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK);
                    } else if (this.progress[process] + 1 >= MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), this.TICKS_REQUIRED)) {
                        this.operate(this.getInputSlot(process), this.getOutputSlot(process));
                        this.progress[process] = 0;
                        this.secondaryEnergyStored -= this.getSecondaryEnergyPerTick();
                        this.electricityStored -= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK);
                    }
                }
                if (this.canOperate(this.getInputSlot(process), this.getOutputSlot(process))) continue;
                this.progress[process] = 0;
            }
            boolean hasOperation = false;
            for (int i = 0; i < this.tier.processes; ++i) {
                if (!this.canOperate(this.getInputSlot(i), this.getOutputSlot(i))) continue;
                hasOperation = true;
                break;
            }
            if (MekanismUtils.canFunction(this) && hasOperation && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK) && this.secondaryEnergyStored >= this.getSecondaryEnergyPerTick()) {
                this.setActive(true);
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public void sortInventory() {
        if (this.sorting) {
            boolean didOp = false;
            int[] inputSlots = null;
            ArrayList<InvID> invStacks = new ArrayList<InvID>();
            if (this.tier == Tier.FactoryTier.BASIC) {
                inputSlots = new int[]{5, 6, 7};
            } else if (this.tier == Tier.FactoryTier.ADVANCED) {
                inputSlots = new int[]{5, 6, 7, 8, 9};
            } else if (this.tier == Tier.FactoryTier.ELITE) {
                inputSlots = new int[]{5, 6, 7, 8, 9, 10, 11};
            }
            for (int id : inputSlots) {
                invStacks.add(InvID.get(id, this.inventory));
            }
            for (InvID invID1 : invStacks) {
                for (InvID invID2 : invStacks) {
                    if (invID1.ID == invID2.ID || StackUtils.diffIgnoreNull(invID1.stack, invID2.stack) || Math.abs(invID1.size() - invID2.size()) < 2) continue;
                    List<ItemStack> evened = StackUtils.even(this.inventory[invID1.ID], this.inventory[invID2.ID]);
                    this.inventory[invID1.ID] = evened.get(0);
                    this.inventory[invID2.ID] = evened.get(1);
                    didOp = true;
                    break;
                }
                if (!didOp) continue;
                break;
            }
        }
    }

    public int getSecondaryEnergyPerTick() {
        return IFactory.RecipeType.values()[this.recipeType].getSecondaryEnergyPerTick();
    }

    public int getMaxSecondaryEnergy() {
        return IFactory.RecipeType.values()[this.recipeType].getMaxSecondaryEnergy() * this.tier.processes;
    }

    public void handleSecondaryFuel() {
        if (this.inventory[4] != null && IFactory.RecipeType.values()[this.recipeType].usesFuel() && this.secondaryEnergyStored < this.getMaxSecondaryEnergy()) {
            if (this.recipeType == IFactory.RecipeType.PURIFYING.ordinal() && this.inventory[4].func_77973_b() instanceof IGasItem) {
                GasStack removed = GasTransmission.removeGas(this.inventory[4], GasRegistry.getGas("oxygen"), this.getMaxSecondaryEnergy() - this.secondaryEnergyStored);
                this.setSecondaryEnergy(this.secondaryEnergyStored + (removed != null ? removed.amount : 0));
                return;
            }
            int fuelTicks = IFactory.RecipeType.values()[this.recipeType].getFuelTicks(this.inventory[4]);
            int energyNeeded = this.getMaxSecondaryEnergy() - this.secondaryEnergyStored;
            if (fuelTicks > 0 && fuelTicks <= energyNeeded) {
                if (fuelTicks <= energyNeeded) {
                    this.setSecondaryEnergy(this.secondaryEnergyStored + fuelTicks);
                } else if (fuelTicks > energyNeeded) {
                    this.setSecondaryEnergy(this.secondaryEnergyStored + energyNeeded);
                }
                --this.inventory[4].field_77994_a;
                if (this.inventory[4].field_77994_a == 0) {
                    this.inventory[4] = null;
                }
            }
        }
    }

    public ItemStack getMachineStack() {
        return IFactory.RecipeType.values()[this.recipeType].getStack();
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (this.tier == Tier.FactoryTier.BASIC && slotID >= 8 && slotID <= 10) {
            return true;
        }
        if (this.tier == Tier.FactoryTier.ADVANCED && slotID >= 10 && slotID <= 14) {
            return true;
        }
        return this.tier == Tier.FactoryTier.ELITE && slotID >= 12 && slotID <= 18;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.tier == Tier.FactoryTier.BASIC) {
            if (slotID >= 8 && slotID <= 10) {
                return false;
            }
            if (slotID >= 5 && slotID <= 7) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, false) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ADVANCED) {
            if (slotID >= 10 && slotID <= 14) {
                return false;
            }
            if (slotID >= 5 && slotID <= 9) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, false) != null;
            }
        } else if (this.tier == Tier.FactoryTier.ELITE) {
            if (slotID >= 12 && slotID <= 18) {
                return false;
            }
            if (slotID >= 5 && slotID <= 11) {
                return IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(itemstack, false) != null;
            }
        }
        if (slotID == 0) {
            return itemstack.field_77993_c == Mekanism.SpeedUpgrade.field_77779_bT || itemstack.field_77993_c == Mekanism.EnergyUpgrade.field_77779_bT;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 4) {
            return IFactory.RecipeType.values()[this.recipeType].getFuelTicks(itemstack) > 0;
        }
        return false;
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.unregisterSound(this);
        }
    }

    public int getScaledProgress(int i, int process) {
        return this.progress[process] * i / MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), this.TICKS_REQUIRED);
    }

    public int getScaledSecondaryEnergy(int i) {
        return this.secondaryEnergyStored * i / this.getMaxSecondaryEnergy();
    }

    public int getScaledRecipeProgress(int i) {
        return this.recipeTicks * i / this.RECIPE_TICKS_REQUIRED;
    }

    public boolean canOperate(int inputSlot, int outputSlot) {
        if (this.inventory[inputSlot] == null) {
            return false;
        }
        ItemStack itemstack = IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(this.inventory[inputSlot], false);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[outputSlot] == null) {
            return true;
        }
        if (!this.inventory[outputSlot].func_77969_a(itemstack)) {
            return false;
        }
        return this.inventory[outputSlot].field_77994_a + itemstack.field_77994_a <= this.inventory[outputSlot].func_77976_d();
    }

    public void operate(int inputSlot, int outputSlot) {
        if (!this.canOperate(inputSlot, outputSlot)) {
            return;
        }
        ItemStack itemstack = IFactory.RecipeType.values()[this.recipeType].getCopiedOutput(this.inventory[inputSlot], true);
        if (this.inventory[inputSlot].field_77994_a <= 0) {
            this.inventory[inputSlot] = null;
        }
        if (this.inventory[outputSlot] == null) {
            this.inventory[outputSlot] = itemstack;
        } else {
            this.inventory[outputSlot].field_77994_a += itemstack.field_77994_a;
        }
        this.func_70296_d();
        this.ejectorComponent.onOutput();
    }

    public void setSecondaryEnergy(int energy) {
        this.secondaryEnergyStored = Math.max(Math.min(energy, this.getMaxSecondaryEnergy()), 0);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        int i;
        if (!this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.sorting = !this.sorting;
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.clientActive = dataStream.readBoolean();
        this.recipeType = dataStream.readInt();
        this.recipeTicks = dataStream.readInt();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.secondaryEnergyStored = dataStream.readInt();
        this.sorting = dataStream.readBoolean();
        for (i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = dataStream.readInt();
        }
        for (i = 0; i < 6; ++i) {
            this.sideConfig[i] = dataStream.readByte();
        }
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = Mekanism.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        int i;
        super.func_70307_a(nbtTags);
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.recipeType = Math.min(5, nbtTags.func_74762_e("recipeType"));
        this.recipeTicks = nbtTags.func_74762_e("recipeTicks");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.secondaryEnergyStored = nbtTags.func_74762_e("secondaryEnergyStored");
        this.sorting = nbtTags.func_74767_n("sorting");
        for (i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.func_74762_e("progress" + i);
        }
        if (nbtTags.func_74764_b("sideDataStored")) {
            for (i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.func_74771_c("config" + i);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        int i;
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("recipeType", this.recipeType);
        nbtTags.func_74768_a("recipeTicks", this.recipeTicks);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("secondaryEnergyStored", this.secondaryEnergyStored);
        nbtTags.func_74757_a("sorting", this.sorting);
        for (i = 0; i < this.tier.processes; ++i) {
            nbtTags.func_74768_a("progress" + i, this.progress[i]);
        }
        nbtTags.func_74757_a("sideDataStored", true);
        for (i = 0; i < 6; ++i) {
            nbtTags.func_74774_a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.recipeType);
        data.add(this.recipeTicks);
        data.add(this.controlType.ordinal());
        data.add(this.secondaryEnergyStored);
        data.add(this.sorting);
        data.add(this.progress);
        data.add(this.sideConfig);
        return data;
    }

    public int getInputSlot(int operation) {
        return operation + 5;
    }

    public int getOutputSlot(int operation) {
        return this.tier.processes + 5 + operation;
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.progress[(Integer)arguments[0]]};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.canOperate(this.getInputSlot((Integer)arguments[0]), this.getOutputSlot((Integer)arguments[0]))};
            }
            case 4: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public double getMaxEnergy() {
        return MekanismUtils.getEnergy(this.getEnergyMultiplier(new Object[0]), this.MAX_ELECTRICITY);
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side, (int)this.facing)]).availableSlots;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public ArrayList<SideData> getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.upgradeComponent.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.energyMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.upgradeComponent.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.upgradeComponent.speedMultiplier = multiplier;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        return true;
    }

    @Override
    public String getSoundPath() {
        return IFactory.RecipeType.values()[this.recipeType].getSound();
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public IEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public GasStack getGas(Object ... data) {
        if (this.secondaryEnergyStored == 0) {
            return null;
        }
        return new GasStack(GasRegistry.getGas("oxygen"), this.secondaryEnergyStored);
    }

    @Override
    public void setGas(GasStack stack, Object ... data) {
        if (stack == null) {
            this.setSecondaryEnergy(0);
        } else if (stack.getGas() == GasRegistry.getGas("oxygen")) {
            this.setSecondaryEnergy(stack.amount);
        }
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getMaxGas(Object ... data) {
        return this.getMaxSecondaryEnergy();
    }

    @Override
    public int receiveGas(GasStack stack) {
        if (stack.getGas() == GasRegistry.getGas("oxygen")) {
            int stored = this.getGas(new Object[0]) != null ? this.getGas((Object[])new Object[0]).amount : 0;
            int toUse = Math.min(this.getMaxGas(new Object[0]) - stored, stack.amount);
            this.setGas(new GasStack(stack.getGas(), stored + toUse), new Object[0]);
            return toUse;
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return type == GasRegistry.getGas("oxygen");
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return this.recipeType == IFactory.RecipeType.PURIFYING.ordinal();
    }

    public static class InvID {
        public ItemStack stack;
        public int ID;

        public InvID(ItemStack s, int i) {
            this.stack = s;
            this.ID = i;
        }

        public int size() {
            return this.stack != null ? this.stack.field_77994_a : 0;
        }

        public int id() {
            return this.stack != null ? this.stack.field_77993_c : 0;
        }

        public static InvID get(int id, ItemStack[] inv) {
            return new InvID(inv[id], id);
        }
    }
}

