/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Object3D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasStorage;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.IRedstoneControl;
import mekanism.common.tileentity.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityGasTank
extends TileEntityContainerBlock
implements IGasStorage,
IGasAcceptor,
ITubeConnection,
IRedstoneControl {
    public GasStack gasStored;
    public final int MAX_GAS = 96000;
    public int output = 16;
    public IRedstoneControl.RedstoneControl controlType;

    public TileEntityGasTank() {
        super("GasTank");
        this.inventory = new ItemStack[2];
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
    }

    @Override
    public void onUpdate() {
        if (this.inventory[0] != null && this.getGas(new Object[0]) != null) {
            this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - GasTransmission.addGas(this.inventory[0], this.getGas(new Object[0]))), new Object[0]);
        }
        if (this.inventory[1] != null && (this.getGas(new Object[0]) == null || this.getGas((Object[])new Object[0]).amount < this.getMaxGas(new Object[0]))) {
            if (this.getGas(new Object[0]) == null) {
                this.setGas(GasTransmission.removeGas(this.inventory[1], null, this.getMaxGas(new Object[0])), new Object[0]);
            } else {
                GasStack removed = GasTransmission.removeGas(this.inventory[1], this.getGas(new Object[0]).getGas(), this.getMaxGas(new Object[0]) - this.getGas((Object[])new Object[0]).amount);
                this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount + (removed != null ? removed.amount : 0)), new Object[0]);
            }
        }
        if (!this.field_70331_k.field_72995_K && this.getGas(new Object[0]) != null && MekanismUtils.canFunction(this)) {
            GasStack toSend = new GasStack(this.getGas(new Object[0]).getGas(), Math.min(this.getGas((Object[])new Object[0]).amount, this.output));
            this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - GasTransmission.emitGasToNetwork(toSend, this, ForgeDirection.getOrientation((int)this.facing))), new Object[0]);
            TileEntity tileEntity = Object3D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
            if (tileEntity instanceof IGasAcceptor && ((IGasAcceptor)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.getGas(new Object[0]).getGas())) {
                int added = ((IGasAcceptor)tileEntity).receiveGas(new GasStack(this.getGas(new Object[0]).getGas(), Math.min(this.getGas((Object[])new Object[0]).amount, this.output)));
                this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - added), new Object[0]);
            }
        }
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas((Object[])new Object[]{itemstack}).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.getGas(new Object[0]) == null || ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, this.getGas(new Object[0]).getGas()));
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.getGas(new Object[0]) == null || ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, this.getGas(new Object[0]).getGas()));
        }
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    @Override
    public GasStack getGas(Object ... data) {
        return this.gasStored;
    }

    @Override
    public void setGas(GasStack stack, Object ... data) {
        this.gasStored = stack == null || stack.amount == 0 ? null : new GasStack(stack.getGas(), Math.max(Math.min(stack.amount, this.getMaxGas(new Object[0])), 0));
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getMaxGas(Object ... data) {
        return 96000;
    }

    @Override
    public int receiveGas(GasStack stack) {
        if (this.gasStored == null || this.gasStored != null && this.gasStored.getGas() == stack.getGas()) {
            int stored = this.getGas(new Object[0]) != null ? this.getGas((Object[])new Object[0]).amount : 0;
            int toUse = Math.min(this.getMaxGas(new Object[0]) - stored, stack.amount);
            this.setGas(new GasStack(stack.getGas(), stored + toUse), new Object[0]);
            return toUse;
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return (this.getGas(new Object[0]) == null || this.getGas(new Object[0]).getGas() == type) && side != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.gasStored = dataStream.readBoolean() ? new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()) : null;
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        try {
            this.gasStored = GasStack.readFromNBT(nbtTags.func_74775_l("gasStored"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        if (this.gasStored != null) {
            nbtTags.func_74766_a("gasStored", this.gasStored.write(new NBTTagCompound()));
        }
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.gasStored != null) {
            data.add(true);
            data.add(this.gasStored.getGas().getID());
            data.add(this.gasStored.amount);
        } else {
            data.add(false);
        }
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }
}

