/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.common.HashList;
import mekanism.common.IConfigurable;
import mekanism.common.ITileNetwork;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityLogisticalSorter;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileEntityLogisticalTransporter
extends TileEntity
implements ITileNetwork,
IPipeTile,
IConfigurable {
    public static final int SPEED = 5;
    public EnumColor color;
    public HashList<TransporterStack> transit = new HashList();
    public Set<TransporterStack> needsSync = new HashSet<TransporterStack>();

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            for (TransporterStack stack : this.transit) {
                if (stack == null) continue;
                stack.progress = Math.min(100, stack.progress + 5);
            }
        } else {
            HashSet<TransporterStack> remove = new HashSet<TransporterStack>();
            for (TransporterStack stack : this.transit) {
                if (!stack.initiatedPath && !this.recalculate(stack, null)) {
                    remove.add(stack);
                    continue;
                }
                stack.progress += 5;
                if (stack.progress > 100) {
                    Object3D prevSet = null;
                    if (stack.hasPath()) {
                        int currentIndex = stack.pathToTarget.indexOf(Object3D.get(this));
                        Object3D next = stack.pathToTarget.get(currentIndex - 1);
                        if (!stack.isFinal(this)) {
                            if (next != null && stack.canInsertToTransporter(stack.getNext(this).getTileEntity((IBlockAccess)this.field_70331_k))) {
                                TileEntityLogisticalTransporter nextTile = (TileEntityLogisticalTransporter)next.getTileEntity((IBlockAccess)this.field_70331_k);
                                nextTile.entityEntering(stack);
                                remove.add(stack);
                                continue;
                            }
                            if (next != null) {
                                prevSet = next;
                            }
                        } else if (stack.pathType != TransporterStack.Path.NONE && next != null && next.getTileEntity((IBlockAccess)this.field_70331_k) instanceof IInventory) {
                            this.needsSync.add(stack);
                            IInventory inventory = (IInventory)next.getTileEntity((IBlockAccess)this.field_70331_k);
                            if (inventory != null) {
                                ItemStack rejected = InventoryUtils.putStackInInventory(inventory, stack.itemStack, stack.getSide(this), stack.pathType == TransporterStack.Path.HOME);
                                if (rejected == null) {
                                    TransporterManager.remove(stack);
                                    remove.add(stack);
                                    continue;
                                }
                                this.needsSync.add(stack);
                                stack.itemStack = rejected;
                                prevSet = next;
                            }
                        }
                    }
                    if (!this.recalculate(stack, prevSet)) {
                        remove.add(stack);
                        continue;
                    }
                    if (prevSet != null) {
                        stack.progress = 0;
                        continue;
                    }
                    stack.progress = 50;
                    continue;
                }
                if (stack.progress != 50) continue;
                if (stack.isFinal(this)) {
                    if (stack.pathType == TransporterStack.Path.DEST && !InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.field_70331_k), stack.color, stack.itemStack, stack.getSide(this), false)) {
                        if (this.recalculate(stack, null)) continue;
                        remove.add(stack);
                        continue;
                    }
                    if (stack.pathType == TransporterStack.Path.HOME && !InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.field_70331_k), stack.color, stack.itemStack, stack.getSide(this), true)) {
                        if (this.recalculate(stack, null)) continue;
                        remove.add(stack);
                        continue;
                    }
                    if (stack.pathType != TransporterStack.Path.NONE || this.recalculate(stack, null)) continue;
                    remove.add(stack);
                    continue;
                }
                TileEntity next = stack.getNext(this).getTileEntity((IBlockAccess)this.field_70331_k);
                boolean recalculate = false;
                if (!stack.canInsertToTransporter(next)) {
                    recalculate = true;
                }
                if (!TransporterUtils.checkDiversionLogic(this, next, stack.getSide(this))) {
                    recalculate = true;
                }
                if (!recalculate || this.recalculate(stack, null)) continue;
                remove.add(stack);
            }
            for (TransporterStack stack : remove) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getSyncPacket(stack, true)), Object3D.get(this), 50.0);
                this.transit.remove(stack);
                MekanismUtils.saveChunk(this);
            }
            for (TransporterStack stack : this.needsSync) {
                if (!this.transit.contains(stack)) continue;
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getSyncPacket(stack, false)), Object3D.get(this), 50.0);
            }
            this.needsSync.clear();
        }
    }

    private boolean recalculate(TransporterStack stack, Object3D from) {
        this.needsSync.add(stack);
        if (!TransporterManager.didEmit(stack.itemStack, stack.recalculatePath(this, 0)) && !stack.calculateIdle(this)) {
            TransporterUtils.drop(this, stack);
            return false;
        }
        if (from != null) {
            stack.originalLocation = from;
        }
        return true;
    }

    public ItemStack insert(Object3D original, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        TransporterStack stack = new TransporterStack();
        stack.itemStack = itemStack;
        stack.originalLocation = original;
        stack.homeLocation = original;
        stack.color = color;
        if (!stack.canInsertToTransporter(this)) {
            return itemStack;
        }
        ItemStack rejected = stack.recalculatePath(this, min);
        if (TransporterManager.didEmit(stack.itemStack, rejected)) {
            stack.itemStack = TransporterManager.getToUse(stack.itemStack, rejected);
            this.transit.add(stack);
            TransporterManager.add(stack);
            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getSyncPacket(stack, false)), Object3D.get(this), 50.0);
            MekanismUtils.saveChunk(this);
            return rejected;
        }
        return itemStack;
    }

    public ItemStack insertRR(TileEntityLogisticalSorter outputter, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        TransporterStack stack = new TransporterStack();
        stack.itemStack = itemStack;
        stack.originalLocation = Object3D.get(outputter);
        stack.homeLocation = Object3D.get(outputter);
        stack.color = color;
        if (!stack.canInsertToTransporter(this)) {
            return itemStack;
        }
        ItemStack rejected = stack.recalculateRRPath(outputter, this, min);
        if (TransporterManager.didEmit(stack.itemStack, rejected)) {
            stack.itemStack = TransporterManager.getToUse(stack.itemStack, rejected);
            this.transit.add(stack);
            TransporterManager.add(stack);
            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getSyncPacket(stack, false)), Object3D.get(this), 50.0);
            MekanismUtils.saveChunk(this);
            return rejected;
        }
        return itemStack;
    }

    public void entityEntering(TransporterStack stack) {
        stack.progress = 0;
        this.transit.add(stack);
        PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getSyncPacket(stack, false)), Object3D.get(this), 50.0);
        MekanismUtils.saveChunk(this);
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDataRequest().setParams(Object3D.get(this)), new Object[0]);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        int type = dataStream.readInt();
        if (type == 0) {
            int c = dataStream.readInt();
            this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
            this.transit.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.transit.add(TransporterStack.readFromPacket(dataStream));
            }
        } else if (type == 1) {
            boolean kill = dataStream.readBoolean();
            int index = dataStream.readInt();
            if (kill) {
                this.transit.remove(index);
            } else {
                TransporterStack stack = TransporterStack.readFromPacket(dataStream);
                if (stack.progress == 0) {
                    stack.progress = 5;
                }
                this.transit.replace(index, stack);
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(0);
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.transit.size());
        for (TransporterStack stack : this.transit) {
            stack.write(this, data);
        }
        return data;
    }

    public ArrayList getSyncPacket(TransporterStack stack, boolean kill) {
        ArrayList<Constable> data = new ArrayList<Constable>();
        data.add(Integer.valueOf(1));
        data.add(Boolean.valueOf(kill));
        data.add(Integer.valueOf(this.transit.indexOf(stack)));
        if (!kill) {
            stack.write(this, data);
        }
        return data;
    }

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        if (nbtTags.func_74764_b("stacks")) {
            NBTTagList tagList = nbtTags.func_74761_m("stacks");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                TransporterStack stack = TransporterStack.readFromNBT((NBTTagCompound)tagList.func_74743_b(i));
                this.transit.add(stack);
                TransporterManager.add(stack);
            }
        }
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        NBTTagList stacks = new NBTTagList();
        for (TransporterStack stack : this.transit) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            stack.write(tagCompound);
            stacks.func_74742_a((NBTBase)tagCompound);
        }
        if (stacks.func_74745_c() != 0) {
            nbtTags.func_74782_a("stacks", (NBTBase)stacks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    @Override
    public IPipe getPipe() {
        return null;
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.ITEM;
    }

    @Override
    public int injectItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (doAdd) {
            TileEntity tile = Object3D.get(this).getFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k);
            ItemStack rejects = TransporterUtils.insert(tile, this, stack, null, true, 0);
            return TransporterManager.getToUse((ItemStack)stack, (ItemStack)rejects).field_77994_a;
        }
        return 0;
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return true;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        TransporterUtils.incrementColor(this);
        PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), Object3D.get(this), 50.0);
        player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.configurator.toggleColor") + ": " + (this.color != null ? this.color.getName() : (Object)((Object)EnumColor.BLACK) + MekanismUtils.localize("gui.none")))));
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }
}

