/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Object3D;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.FluidNetwork;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityTransmitter;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityMechanicalPipe
extends TileEntityTransmitter<FluidNetwork>
implements IFluidHandler {
    public FluidTank dummyTank = new FluidTank(1000);
    public boolean isActive = false;

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public FluidNetwork getTransmitterNetwork(boolean createIfNull) {
        if (this.theNetwork == null && createIfNull) {
            TileEntity[] adjacentPipes = PipeUtils.getConnectedPipes(this);
            HashSet<FluidNetwork> connectedNets = new HashSet<FluidNetwork>();
            for (TileEntity pipe : adjacentPipes) {
                if (!TransmissionType.checkTransmissionType(pipe, this.getTransmissionType()) || ((ITransmitter)pipe).getTransmitterNetwork(false) == null) continue;
                connectedNets.add((FluidNetwork)((ITransmitter)pipe).getTransmitterNetwork());
            }
            if (connectedNets.size() == 0) {
                this.theNetwork = new FluidNetwork(this);
            } else if (connectedNets.size() == 1) {
                this.theNetwork = connectedNets.iterator().next();
                ((FluidNetwork)this.theNetwork).transmitters.add(this);
            } else {
                this.theNetwork = new FluidNetwork((Set<FluidNetwork>)connectedNets);
                ((FluidNetwork)this.theNetwork).transmitters.add(this);
            }
        }
        return (FluidNetwork)this.theNetwork;
    }

    @Override
    public void fixTransmitterNetwork() {
        ((FluidNetwork)this.getTransmitterNetwork()).fixMessedUpNetwork(this);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        ((FluidNetwork)this.getTransmitterNetwork()).split(this);
    }

    public void func_70313_j() {
        ((FluidNetwork)this.getTransmitterNetwork()).split(this);
        if (!this.field_70331_k.field_72995_K) {
            TransmitterNetworkRegistry.getInstance().pruneEmptyNetworks();
        }
        super.func_70313_j();
    }

    @Override
    public void removeFromTransmitterNetwork() {
        if (this.theNetwork != null) {
            ((FluidNetwork)this.theNetwork).removeTransmitter(this);
        }
    }

    @Override
    public void refreshTransmitterNetwork() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
            if (!TransmissionType.checkTransmissionType(tileEntity, this.getTransmissionType())) continue;
            ((FluidNetwork)this.getTransmitterNetwork()).merge((FluidNetwork)((ITransmitter)tileEntity).getTransmitterNetwork());
        }
        ((FluidNetwork)this.getTransmitterNetwork()).refresh();
    }

    @Override
    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K && this.isActive) {
            IFluidHandler[] connectedAcceptors;
            for (IFluidHandler container : connectedAcceptors = PipeUtils.getConnectedAcceptors(this)) {
                FluidStack received;
                ForgeDirection side = ForgeDirection.getOrientation((int)Arrays.asList(connectedAcceptors).indexOf(container));
                if (container == null || (received = container.drain(side.getOpposite(), 100, false)) == null || received.amount == 0) continue;
                container.drain(side.getOpposite(), ((FluidNetwork)this.getTransmitterNetwork()).emit(received, true, (TileEntity)container), true);
            }
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDataRequest().setParams(Object3D.get(this)), new Object[0]);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        this.isActive = dataStream.readBoolean();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.isActive);
        return data;
    }

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.isActive) {
            return ((FluidNetwork)this.getTransmitterNetwork()).emit(resource, doFill, Object3D.get(this).getFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k));
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.dummyTank.getInfo()};
    }

    @Override
    public int getTransmitterNetworkSize() {
        return ((FluidNetwork)this.getTransmitterNetwork()).getSize();
    }

    @Override
    public int getTransmitterNetworkAcceptorSize() {
        return ((FluidNetwork)this.getTransmitterNetwork()).getAcceptorSize();
    }

    @Override
    public String getTransmitterNetworkNeeded() {
        return ((FluidNetwork)this.getTransmitterNetwork()).getNeeded();
    }

    @Override
    public String getTransmitterNetworkFlow() {
        return ((FluidNetwork)this.getTransmitterNetwork()).getFlow();
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        this.isActive = !this.isActive;
        ((FluidNetwork)this.getTransmitterNetwork()).refresh();
        PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
        return true;
    }
}

