/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.Object3D;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasTransmitter;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.tileentity.TileEntityTransmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityPressurizedTube
extends TileEntityTransmitter<GasNetwork>
implements ITubeConnection,
IGasTransmitter {
    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public GasNetwork getTransmitterNetwork(boolean createIfNull) {
        if (this.theNetwork == null && createIfNull) {
            TileEntity[] adjacentTubes = GasTransmission.getConnectedTubes(this);
            HashSet<GasNetwork> connectedNets = new HashSet<GasNetwork>();
            for (TileEntity tube : adjacentTubes) {
                if (!TransmissionType.checkTransmissionType(tube, TransmissionType.GAS, this) || ((ITransmitter)tube).getTransmitterNetwork(false) == null) continue;
                connectedNets.add((GasNetwork)((ITransmitter)tube).getTransmitterNetwork());
            }
            if (connectedNets.size() == 0) {
                this.theNetwork = new GasNetwork(this);
            } else if (connectedNets.size() == 1) {
                this.theNetwork = (GasNetwork)connectedNets.iterator().next();
                ((GasNetwork)this.theNetwork).transmitters.add(this);
            } else {
                this.theNetwork = new GasNetwork((Set<GasNetwork>)connectedNets);
                ((GasNetwork)this.theNetwork).transmitters.add(this);
            }
        }
        return (GasNetwork)this.theNetwork;
    }

    @Override
    public void fixTransmitterNetwork() {
        ((GasNetwork)this.getTransmitterNetwork()).fixMessedUpNetwork(this);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        ((GasNetwork)this.getTransmitterNetwork()).split(this);
    }

    public void func_70313_j() {
        ((GasNetwork)this.getTransmitterNetwork()).split(this);
        if (!this.field_70331_k.field_72995_K) {
            TransmitterNetworkRegistry.getInstance().pruneEmptyNetworks();
        }
        super.func_70313_j();
    }

    @Override
    public void removeFromTransmitterNetwork() {
        if (this.theNetwork != null) {
            ((GasNetwork)this.theNetwork).removeTransmitter(this);
        }
    }

    @Override
    public void refreshTransmitterNetwork() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
            if (!TransmissionType.checkTransmissionType(tileEntity, TransmissionType.GAS, this)) continue;
            ((GasNetwork)this.getTransmitterNetwork()).merge((GasNetwork)((ITransmitter)tileEntity).getTransmitterNetwork());
        }
        ((GasNetwork)this.getTransmitterNetwork()).refresh();
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public int getTransmitterNetworkSize() {
        return ((GasNetwork)this.getTransmitterNetwork()).getSize();
    }

    @Override
    public int getTransmitterNetworkAcceptorSize() {
        return ((GasNetwork)this.getTransmitterNetwork()).getAcceptorSize();
    }

    @Override
    public String getTransmitterNetworkNeeded() {
        return ((GasNetwork)this.getTransmitterNetwork()).getNeeded();
    }

    @Override
    public String getTransmitterNetworkFlow() {
        return ((GasNetwork)this.getTransmitterNetwork()).getFlow();
    }

    @Override
    public boolean canTransferGasToTube(TileEntity tile) {
        return tile instanceof IGasTransmitter;
    }
}

