/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasStorage;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.RecipeHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.tileentity.TileEntityAdvancedElectricMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityPurificationChamber
extends TileEntityAdvancedElectricMachine
implements IGasAcceptor,
IGasStorage,
ITubeConnection {
    public TileEntityPurificationChamber() {
        super("PurificationChamber.ogg", "PurificationChamber", new ResourceLocation("mekanism", "gui/GuiPurificationChamber.png"), Mekanism.purificationChamberUsage, 1, 200, BlockMachine.MachineType.PURIFICATION_CHAMBER.baseEnergy, 1200);
    }

    @Override
    public Map getRecipes() {
        return RecipeHandler.Recipe.PURIFICATION_CHAMBER.get();
    }

    @Override
    public int getFuelTicks(ItemStack itemstack) {
        if (itemstack.func_77969_a(new ItemStack(Item.field_77804_ap))) {
            return 300;
        }
        if (itemstack.func_77969_a(new ItemStack(Mekanism.GasTank)) && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas() == GasRegistry.getGas("oxygen")) {
            return 1;
        }
        return 0;
    }

    @Override
    public GasStack getGas(Object ... data) {
        if (this.secondaryEnergyStored == 0) {
            return null;
        }
        return new GasStack(GasRegistry.getGas("oxygen"), this.secondaryEnergyStored);
    }

    @Override
    public void setGas(GasStack stack, Object ... data) {
        if (stack == null) {
            this.setSecondaryEnergy(0);
        } else if (stack.getGas() == GasRegistry.getGas("oxygen")) {
            this.setSecondaryEnergy(stack.amount);
        }
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getMaxGas(Object ... data) {
        return this.MAX_SECONDARY_ENERGY;
    }

    @Override
    public int receiveGas(GasStack stack) {
        if (stack.getGas() == GasRegistry.getGas("oxygen")) {
            int stored = this.getGas(new Object[0]) != null ? this.getGas((Object[])new Object[0]).amount : 0;
            int toUse = Math.min(this.getMaxGas(new Object[0]) - stored, stack.amount);
            this.setGas(new GasStack(stack.getGas(), stored + toUse), new Object[0]);
            return toUse;
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return type == GasRegistry.getGas("oxygen");
    }

    @Override
    public void handleSecondaryFuel() {
        if (this.inventory[1] != null && this.secondaryEnergyStored < this.MAX_SECONDARY_ENERGY) {
            GasStack removed = GasTransmission.removeGas(this.inventory[1], GasRegistry.getGas("oxygen"), this.MAX_SECONDARY_ENERGY - this.secondaryEnergyStored);
            this.setSecondaryEnergy(this.secondaryEnergyStored + (removed != null ? removed.amount : 0));
        }
        super.handleSecondaryFuel();
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }
}

