/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Object3D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasAcceptor;
import mekanism.api.gas.IGasStorage;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.IActiveState;
import mekanism.common.IRedstoneControl;
import mekanism.common.ISustainedTank;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityRotaryCondensentrator
extends TileEntityElectricBlock
implements IActiveState,
ISustainedTank,
IFluidHandler,
IGasStorage,
IGasAcceptor,
ITubeConnection,
IRedstoneControl {
    public GasStack gasTank;
    public FluidTank fluidTank;
    public static final int MAX_GAS = 10000;
    public int updateDelay;
    public int mode;
    public int gasOutput = 16;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public final double ENERGY_USAGE = Mekanism.rotaryCondensentratorUsage;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityRotaryCondensentrator() {
        super("RotaryCondensentrator", BlockMachine.MachineType.ROTARY_CONDENSENTRATOR.baseEnergy);
        this.fluidTank = new FluidTank(10000);
        this.inventory = new ItemStack[5];
    }

    @Override
    public void onUpdate() {
        if (this.field_70331_k.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            }
            ChargeUtils.discharge(4, this);
            if (this.mode == 0) {
                ItemStack filled;
                if (this.inventory[1] != null && (this.getGas(new Object[0]) == null || this.getGas((Object[])new Object[0]).amount < this.getMaxGas(new Object[0]))) {
                    if (this.getGas(new Object[0]) == null) {
                        this.setGas(GasTransmission.removeGas(this.inventory[1], null, this.getMaxGas(new Object[0])), new Object[0]);
                    } else {
                        GasStack removed = GasTransmission.removeGas(this.inventory[1], this.getGas(new Object[0]).getGas(), this.getMaxGas(new Object[0]) - this.getGas((Object[])new Object[0]).amount);
                        this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount + (removed != null ? removed.amount : 0)), new Object[0]);
                    }
                }
                if (this.inventory[2] != null && FluidContainerRegistry.isEmptyContainer((ItemStack)this.inventory[2]) && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)this.fluidTank.getFluid(), (ItemStack)this.inventory[2])) != null && (this.inventory[3] == null || this.inventory[3].func_77969_a(filled) && this.inventory[3].field_77994_a + 1 <= filled.func_77976_d())) {
                    --this.inventory[2].field_77994_a;
                    if (this.inventory[2].field_77994_a <= 0) {
                        this.inventory[2] = null;
                    }
                    if (this.inventory[3] == null) {
                        this.inventory[3] = filled;
                    } else {
                        ++this.inventory[3].field_77994_a;
                    }
                    this.fluidTank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount, true);
                }
                if (this.getEnergy() >= this.ENERGY_USAGE && MekanismUtils.canFunction(this) && this.isValidGas(this.gasTank) && (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount < 10000 && this.gasEquals(this.gasTank, this.fluidTank.getFluid()))) {
                    this.setActive(true);
                    this.fluidTank.fill(new FluidStack(this.getGas(new Object[0]).getGas().getFluid(), 1), true);
                    this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - 1), new Object[0]);
                    this.setEnergy(this.getEnergy() - this.ENERGY_USAGE);
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            } else if (this.mode == 1) {
                if (this.getGas(new Object[0]) != null && this.inventory[0] != null) {
                    this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - GasTransmission.addGas(this.inventory[0], this.getGas(new Object[0]))), new Object[0]);
                }
                if (this.getGas(new Object[0]) != null) {
                    GasStack toSend = new GasStack(this.getGas(new Object[0]).getGas(), Math.min(this.getGas((Object[])new Object[0]).amount, this.gasOutput));
                    this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - GasTransmission.emitGasToNetwork(toSend, this, MekanismUtils.getLeft(this.facing))), new Object[0]);
                    TileEntity tileEntity = Object3D.get(this).getFromSide(MekanismUtils.getLeft(this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
                    if (tileEntity instanceof IGasAcceptor && ((IGasAcceptor)tileEntity).canReceiveGas(MekanismUtils.getLeft(this.facing).getOpposite(), this.getGas(new Object[0]).getGas())) {
                        int added = ((IGasAcceptor)tileEntity).receiveGas(new GasStack(this.getGas(new Object[0]).getGas(), Math.min(this.getGas((Object[])new Object[0]).amount, this.gasOutput)));
                        this.setGas(new GasStack(this.getGas(new Object[0]).getGas(), this.getGas((Object[])new Object[0]).amount - added), new Object[0]);
                    }
                }
                if (FluidContainerRegistry.isFilledContainer((ItemStack)this.inventory[2])) {
                    FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[2]);
                    if (this.fluidTank.getFluid() == null && itemFluid.amount <= 10000 || this.fluidTank.getFluid().amount + itemFluid.amount <= 10000) {
                        if (this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(itemFluid)) {
                            return;
                        }
                        ItemStack containerItem = this.inventory[2].func_77973_b().getContainerItemStack(this.inventory[2]);
                        boolean filled = false;
                        if (containerItem != null) {
                            if (this.inventory[3] == null || this.inventory[3].func_77969_a(containerItem) && this.inventory[3].field_77994_a + 1 <= containerItem.func_77976_d()) {
                                this.inventory[2] = null;
                                if (this.inventory[3] == null) {
                                    this.inventory[3] = containerItem;
                                } else {
                                    ++this.inventory[3].field_77994_a;
                                }
                                filled = true;
                            }
                        } else {
                            --this.inventory[2].field_77994_a;
                            if (this.inventory[2].field_77994_a == 0) {
                                this.inventory[2] = null;
                            }
                            filled = true;
                        }
                        if (filled) {
                            this.fluidTank.fill(itemFluid, true);
                        }
                    }
                }
                if (this.getEnergy() >= this.ENERGY_USAGE && MekanismUtils.canFunction(this) && this.isValidFluid(this.fluidTank.getFluid()) && (this.gasTank == null || this.gasTank.amount < 10000 && this.gasEquals(this.gasTank, this.fluidTank.getFluid()))) {
                    this.setActive(true);
                    this.setGas(new GasStack(GasRegistry.getGas(this.fluidTank.getFluid().getFluid()), this.getGas(new Object[0]) != null ? this.getGas((Object[])new Object[0]).amount + 1 : 1), new Object[0]);
                    this.fluidTank.drain(1, true);
                    this.setEnergy(this.getEnergy() - this.ENERGY_USAGE);
                } else if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public boolean isValidGas(GasStack g) {
        if (g == null) {
            return false;
        }
        return g.getGas().hasFluid();
    }

    public boolean gasEquals(GasStack gas, FluidStack fluid) {
        if (fluid == null || gas == null || !gas.getGas().hasFluid()) {
            return false;
        }
        return gas.getGas().getFluid() == fluid.getFluid();
    }

    public boolean isValidFluid(FluidStack f) {
        if (f == null) {
            return false;
        }
        return GasRegistry.getGas(f.getFluid()) != null;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.mode = this.mode == 0 ? 1 : 0;
            }
            for (EntityPlayer player : this.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.mode = dataStream.readInt();
        this.isActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        if (dataStream.readBoolean()) {
            this.fluidTank.setFluid(new FluidStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.fluidTank.setFluid(null);
        }
        this.gasTank = dataStream.readBoolean() ? new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()) : null;
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.mode);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.fluidTank.getFluid() != null) {
            data.add(true);
            data.add(this.fluidTank.getFluid().fluidID);
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(false);
        }
        if (this.gasTank != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getID());
            data.add(this.gasTank.amount);
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.mode = nbtTags.func_74762_e("mode");
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.gasTank = GasStack.readFromNBT(nbtTags.func_74775_l("gasTank"));
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("mode", this.mode);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.gasTank != null) {
            nbtTags.func_74766_a("gasTank", this.gasTank.write(new NBTTagCompound()));
        }
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public int getScaledFluidLevel(int i) {
        return this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount * i / 10000 : 0;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank != null ? this.gasTank.amount * i / 10000 : 0;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing);
    }

    @Override
    public int receiveGas(GasStack stack) {
        if (this.gasTank == null || this.gasTank != null && this.gasTank.getGas() == stack.getGas()) {
            int stored = this.getGas(new Object[0]) != null ? this.getGas((Object[])new Object[0]).amount : 0;
            int toUse = Math.min(this.getMaxGas(new Object[0]) - stored, stack.amount);
            this.setGas(new GasStack(stack.getGas(), stored + toUse), new Object[0]);
            return toUse;
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.mode == 0 && (this.getGas(new Object[0]) == null || this.getGas(new Object[0]).getGas() == type) && side == MekanismUtils.getLeft(this.facing);
    }

    @Override
    public GasStack getGas(Object ... data) {
        return this.gasTank;
    }

    @Override
    public void setGas(GasStack stack, Object ... data) {
        this.gasTank = stack == null || stack.amount == 0 ? null : new GasStack(stack.getGas(), Math.max(Math.min(stack.amount, this.getMaxGas(new Object[0])), 0));
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int getMaxGas(Object ... data) {
        return 10000;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid()) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.mode == 1 && from == MekanismUtils.getRight(this.facing);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.mode == 0 && from == MekanismUtils.getRight(this.facing);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == MekanismUtils.getRight(this.facing)) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }
}

