/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IPeripheral;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Teleporter;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tileentity.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileEntityTeleporter
extends TileEntityElectricBlock
implements IPeripheral {
    public Teleporter.Code code;
    public AxisAlignedBB teleportBounds = null;
    public Set<Entity> didTeleport = new HashSet<Entity>();
    public int teleDelay = 0;
    public boolean shouldRender;
    public boolean prevShouldRender;
    public String status = (Object)((Object)EnumColor.DARK_RED) + "Not ready.";

    public TileEntityTeleporter() {
        super("Teleporter", BlockMachine.MachineType.TELEPORTER.baseEnergy);
        this.inventory = new ItemStack[1];
        this.code = new Teleporter.Code(0, 0, 0, 0);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.teleportBounds == null) {
            this.resetBounds();
        }
        if (!this.field_70331_k.field_72995_K) {
            byte b;
            if (Mekanism.teleporters.containsKey(this.code)) {
                if (!Mekanism.teleporters.get(this.code).contains(Object3D.get(this)) && this.hasFrame()) {
                    Mekanism.teleporters.get(this.code).add(Object3D.get(this));
                } else if (Mekanism.teleporters.get(this.code).contains(Object3D.get(this)) && !this.hasFrame()) {
                    Mekanism.teleporters.get(this.code).remove(Object3D.get(this));
                }
            } else if (this.hasFrame()) {
                ArrayList<Object3D> newCoords = new ArrayList<Object3D>();
                newCoords.add(Object3D.get(this));
                Mekanism.teleporters.put(this.code, newCoords);
            }
            switch (this.canTeleport()) {
                case 1: {
                    this.status = (Object)((Object)EnumColor.DARK_GREEN) + "Ready.";
                    break;
                }
                case 2: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "No frame.";
                    break;
                }
                case 3: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "No link found.";
                    break;
                }
                case 4: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Links > 2.";
                    break;
                }
                case 5: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Needs energy.";
                    break;
                }
                case 6: {
                    this.status = (Object)((Object)EnumColor.DARK_GREEN) + "Idle.";
                }
            }
            if (this.canTeleport() == 1 && this.teleDelay == 0) {
                this.teleport();
            }
            if (this.teleDelay == 0 && this.didTeleport.size() > 0) {
                this.cleanTeleportCache();
            }
            boolean bl = this.shouldRender = (b = this.canTeleport()) == 1 || b > 4;
            if (this.shouldRender != this.prevShouldRender) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Object3D.get(this), this.getNetworkedData(new ArrayList())), Object3D.get(this), 40.0);
            }
            this.prevShouldRender = this.shouldRender;
            this.teleDelay = Math.max(0, this.teleDelay - 1);
        }
        ChargeUtils.discharge(0, this);
    }

    public void cleanTeleportCache() {
        List list = this.field_70331_k.func_72872_a(Entity.class, this.teleportBounds);
        Set teleportCopy = (Set)((HashSet)this.didTeleport).clone();
        for (Entity entity : teleportCopy) {
            if (list.contains(entity)) continue;
            this.didTeleport.remove(entity);
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    public void resetBounds() {
        this.teleportBounds = AxisAlignedBB.func_72330_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 3), (double)(this.field_70327_n + 1));
    }

    public byte canTeleport() {
        if (!this.hasFrame()) {
            return 2;
        }
        if (!Mekanism.teleporters.containsKey(this.code) || Mekanism.teleporters.get(this.code).isEmpty()) {
            return 3;
        }
        if (Mekanism.teleporters.get(this.code).size() > 2) {
            return 4;
        }
        if (Mekanism.teleporters.get(this.code).size() == 2) {
            List<Entity> entitiesInPortal = this.getToTeleport();
            Object3D closestCoords = null;
            for (Object3D coords : Mekanism.teleporters.get(this.code)) {
                if (coords.equals(Object3D.get(this))) continue;
                closestCoords = coords;
                break;
            }
            int electricityNeeded = 0;
            for (Entity entity : entitiesInPortal) {
                electricityNeeded += this.calculateEnergyCost(entity, closestCoords);
            }
            if (entitiesInPortal.size() == 0) {
                return 6;
            }
            if (this.getEnergy() < (double)electricityNeeded) {
                return 5;
            }
            return 1;
        }
        return 3;
    }

    public void teleport() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        List<Entity> entitiesInPortal = this.getToTeleport();
        Object3D closestCoords = null;
        for (Object3D coords : Mekanism.teleporters.get(this.code)) {
            if (coords.equals(Object3D.get(this))) continue;
            closestCoords = coords;
            break;
        }
        for (Entity entity : entitiesInPortal) {
            WorldServer teleWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(closestCoords.dimensionId);
            TileEntityTeleporter teleporter = (TileEntityTeleporter)closestCoords.getTileEntity((IBlockAccess)teleWorld);
            if (teleporter == null) continue;
            teleporter.didTeleport.add(entity);
            teleporter.teleDelay = 5;
            if (entity instanceof EntityPlayerMP) {
                if (entity.field_70170_p.field_73011_w.field_76574_g != closestCoords.dimensionId) {
                    entity.func_71027_c(closestCoords.dimensionId);
                }
                ((EntityPlayerMP)entity).field_71135_a.func_72569_a((double)closestCoords.xCoord + 0.5, (double)(closestCoords.yCoord + 1), (double)closestCoords.zCoord + 0.5, entity.field_70177_z, entity.field_70125_A);
            } else {
                this.teleportEntityTo(entity, closestCoords, teleporter);
            }
            for (Object3D coords : Mekanism.teleporters.get(this.code)) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketPortalFX().setParams(coords), coords, 40.0);
            }
            this.setEnergy(this.getEnergy() - (double)this.calculateEnergyCost(entity, closestCoords));
            this.field_70331_k.func_72956_a(entity, "mob.endermen.portal", 1.0f, 1.0f);
        }
    }

    public void teleportEntityTo(Entity entity, Object3D coord, TileEntityTeleporter teleporter) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        WorldServer world = server.func_71218_a(coord.dimensionId);
        if (entity.field_70170_p.field_73011_w.field_76574_g != coord.dimensionId) {
            entity.field_70170_p.func_72900_e(entity);
            entity.field_70128_L = false;
            world.func_72838_d(entity);
            entity.func_70012_b((double)coord.xCoord + 0.5, (double)(coord.yCoord + 1), (double)coord.zCoord + 0.5, entity.field_70177_z, entity.field_70125_A);
            world.func_72866_a(entity, false);
            entity.func_70029_a((World)world);
            world.func_82742_i();
            Entity e = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)world);
            if (e != null) {
                e.func_82141_a(entity, true);
                world.func_72838_d(e);
                teleporter.didTeleport.add(e);
            }
            entity.field_70128_L = true;
        }
    }

    public List<Entity> getToTeleport() {
        List entities = this.field_70331_k.func_72872_a(Entity.class, this.teleportBounds);
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (this.didTeleport.contains(entity)) continue;
            ret.add(entity);
        }
        return ret;
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (!this.field_70331_k.field_72995_K && Mekanism.teleporters.containsKey(this.code)) {
            if (Mekanism.teleporters.get(this.code).contains(Object3D.get(this))) {
                Mekanism.teleporters.get(this.code).remove(Object3D.get(this));
            }
            if (Mekanism.teleporters.get(this.code).isEmpty()) {
                Mekanism.teleporters.remove(this.code);
            }
        }
    }

    public int calculateEnergyCost(Entity entity, Object3D coords) {
        int energyCost = 1000;
        if (entity.field_70170_p.field_73011_w.field_76574_g != coords.dimensionId) {
            energyCost += 10000;
        }
        int distance = (int)entity.func_70011_f((double)coords.xCoord, (double)coords.yCoord, (double)coords.zCoord);
        return energyCost += distance * 10;
    }

    public boolean hasFrame() {
        if (this.isFrame(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) && this.isFrame(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) && this.isFrame(this.field_70329_l - 1, this.field_70330_m + 1, this.field_70327_n) && this.isFrame(this.field_70329_l + 1, this.field_70330_m + 1, this.field_70327_n) && this.isFrame(this.field_70329_l - 1, this.field_70330_m + 2, this.field_70327_n) && this.isFrame(this.field_70329_l + 1, this.field_70330_m + 2, this.field_70327_n) && this.isFrame(this.field_70329_l - 1, this.field_70330_m + 3, this.field_70327_n) && this.isFrame(this.field_70329_l + 1, this.field_70330_m + 3, this.field_70327_n) && this.isFrame(this.field_70329_l, this.field_70330_m + 3, this.field_70327_n)) {
            return true;
        }
        return this.isFrame(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) && this.isFrame(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n - 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n + 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 2, this.field_70327_n - 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 2, this.field_70327_n + 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 3, this.field_70327_n - 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 3, this.field_70327_n + 1) && this.isFrame(this.field_70329_l, this.field_70330_m + 3, this.field_70327_n);
    }

    public boolean isFrame(int x, int y, int z) {
        return this.field_70331_k.func_72798_a(x, y, z) == Mekanism.basicBlockID && this.field_70331_k.func_72805_g(x, y, z) == 7;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.code.digitOne = nbtTags.func_74762_e("digitOne");
        this.code.digitTwo = nbtTags.func_74762_e("digitTwo");
        this.code.digitThree = nbtTags.func_74762_e("digitThree");
        this.code.digitFour = nbtTags.func_74762_e("digitFour");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("digitOne", this.code.digitOne);
        nbtTags.func_74768_a("digitTwo", this.code.digitTwo);
        nbtTags.func_74768_a("digitThree", this.code.digitThree);
        nbtTags.func_74768_a("digitFour", this.code.digitFour);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type;
            if (Mekanism.teleporters.containsKey(this.code)) {
                if (Mekanism.teleporters.get(this.code).contains(Object3D.get(this))) {
                    Mekanism.teleporters.get(this.code).remove(Object3D.get(this));
                }
                if (Mekanism.teleporters.get(this.code).isEmpty()) {
                    Mekanism.teleporters.remove(this.code);
                }
            }
            if ((type = dataStream.readInt()) == 0) {
                this.code.digitOne = dataStream.readInt();
            } else if (type == 1) {
                this.code.digitTwo = dataStream.readInt();
            } else if (type == 2) {
                this.code.digitThree = dataStream.readInt();
            } else if (type == 3) {
                this.code.digitFour = dataStream.readInt();
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.status = dataStream.readUTF().trim();
        this.code.digitOne = dataStream.readInt();
        this.code.digitTwo = dataStream.readInt();
        this.code.digitThree = dataStream.readInt();
        this.code.digitFour = dataStream.readInt();
        this.shouldRender = dataStream.readBoolean();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.status);
        data.add(this.code.digitOne);
        data.add(this.code.digitTwo);
        data.add(this.code.digitThree);
        data.add(this.code.digitFour);
        data.add(this.shouldRender);
        return data;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return ChargeUtils.canBeOutputted(itemstack, false);
    }

    @Override
    public String getType() {
        return this.func_70303_b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "canTeleport", "getMaxEnergy", "getEnergyNeeded", "teleport", "set"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        block0 : switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.canTeleport()};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 4: {
                this.teleport();
                return new Object[]{"Attempted to teleport."};
            }
            case 5: {
                if (!(arguments[0] instanceof Integer) || !(arguments[1] instanceof Integer)) {
                    return new Object[]{"Invalid parameters."};
                }
                int digit = (Integer)arguments[0];
                int newDigit = (Integer)arguments[1];
                switch (digit) {
                    case 0: {
                        this.code.digitOne = newDigit;
                        break block0;
                    }
                    case 1: {
                        this.code.digitTwo = newDigit;
                        break block0;
                    }
                    case 2: {
                        this.code.digitThree = newDigit;
                        break block0;
                    }
                    case 3: {
                        this.code.digitFour = newDigit;
                        break block0;
                    }
                }
                return new Object[]{"No digit found."};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

