/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.IConfigurable;
import mekanism.common.ITileNetwork;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public abstract class TileEntityTransmitter<N>
extends TileEntity
implements ITransmitter<N>,
ITileNetwork,
IConfigurable {
    public N theNetwork;
    public int delayTicks = 0;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean canUpdate() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K) {
            if (this.delayTicks == 3) {
                ++this.delayTicks;
                this.refreshTransmitterNetwork();
            } else if (this.delayTicks < 3) {
                ++this.delayTicks;
            }
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_70331_k.field_72995_K) {
            TransmitterNetworkRegistry.getInstance().pruneEmptyNetworks();
        }
    }

    @Override
    public void setTransmitterNetwork(N network) {
        if (network != this.theNetwork) {
            this.removeFromTransmitterNetwork();
            this.theNetwork = network;
        }
    }

    @Override
    public boolean areTransmitterNetworksEqual(TileEntity tileEntity) {
        return tileEntity instanceof ITransmitter && this.getTransmissionType() == ((ITransmitter)tileEntity).getTransmissionType();
    }

    @Override
    public N getTransmitterNetwork() {
        return (N)this.getTransmitterNetwork(true);
    }

    @Override
    public void chunkLoad() {
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) throws Exception {
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        return data;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        return false;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        this.fixTransmitterNetwork();
        return true;
    }
}

