/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tileentity;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Object3D;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.EnergyNetwork;
import mekanism.common.Mekanism;
import mekanism.common.tileentity.TileEntityTransmitter;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;

public class TileEntityUniversalCable
extends TileEntityTransmitter<EnergyNetwork>
implements IPowerReceptor,
IEnergySink,
IEnergyHandler,
IElectrical {
    public PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.STORAGE);
    public IElectricityNetwork ueNetwork;
    public double energyScale;

    public TileEntityUniversalCable() {
        this.powerHandler.configurePowerPerdition(0, 0);
        this.powerHandler.configure(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public EnergyNetwork getTransmitterNetwork(boolean createIfNull) {
        if (this.theNetwork == null && createIfNull) {
            TileEntity[] adjacentCables = CableUtils.getConnectedCables(this);
            HashSet<EnergyNetwork> connectedNets = new HashSet<EnergyNetwork>();
            for (TileEntity cable : adjacentCables) {
                if (!TransmissionType.checkTransmissionType(cable, TransmissionType.ENERGY) || ((ITransmitter)cable).getTransmitterNetwork(false) == null) continue;
                connectedNets.add((EnergyNetwork)((ITransmitter)cable).getTransmitterNetwork());
            }
            if (connectedNets.size() == 0) {
                this.theNetwork = new EnergyNetwork(this);
            } else if (connectedNets.size() == 1) {
                this.theNetwork = connectedNets.iterator().next();
                ((EnergyNetwork)this.theNetwork).transmitters.add(this);
            } else {
                this.theNetwork = new EnergyNetwork((Set<EnergyNetwork>)connectedNets);
                ((EnergyNetwork)this.theNetwork).transmitters.add(this);
            }
        }
        return (EnergyNetwork)this.theNetwork;
    }

    @Override
    public void fixTransmitterNetwork() {
        ((EnergyNetwork)this.getTransmitterNetwork()).fixMessedUpNetwork(this);
    }

    public void func_70313_j() {
        ((EnergyNetwork)this.getTransmitterNetwork()).split(this);
        if (!this.field_70331_k.field_72995_K) {
            TransmitterNetworkRegistry.getInstance().pruneEmptyNetworks();
            Mekanism.ic2Registered.remove(Object3D.get(this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        super.func_70313_j();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        ((EnergyNetwork)this.getTransmitterNetwork()).split(this);
        if (!this.field_70331_k.field_72995_K) {
            Mekanism.ic2Registered.remove(Object3D.get(this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    @Override
    public void removeFromTransmitterNetwork() {
        if (this.theNetwork != null) {
            ((EnergyNetwork)this.theNetwork).removeTransmitter(this);
        }
    }

    @Override
    public void refreshTransmitterNetwork() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
            if (!TransmissionType.checkTransmissionType(tileEntity, TransmissionType.ENERGY)) continue;
            ((EnergyNetwork)this.getTransmitterNetwork()).merge((EnergyNetwork)((ITransmitter)tileEntity).getTransmitterNetwork());
        }
        ((EnergyNetwork)this.getTransmitterNetwork()).refresh();
        this.reconfigure();
    }

    @Override
    public void chunkLoad() {
        this.register();
    }

    public void register() {
        if (!this.field_70331_k.field_72995_K && !Mekanism.ic2Registered.contains(Object3D.get(this))) {
            Mekanism.ic2Registered.add(Object3D.get(this));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded(this.getBuildCraftIgnored()) == 0.0) {
            return null;
        }
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    private void reconfigure() {
        if (MekanismUtils.useBuildcraft()) {
            float needed = (float)(((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded(this.getBuildCraftIgnored()) * Mekanism.TO_BC);
            this.powerHandler.configure(1.0f, needed, 0.0f, needed);
        }
    }

    public ArrayList<TileEntity> getBuildCraftIgnored() {
        ArrayList<TileEntity> ignored = new ArrayList<TileEntity>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IPowerEmitter emitter;
            TileEntity tile = Object3D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_70331_k);
            if (tile == null) continue;
            if (this.powerHandler.powerSources[side.ordinal()] > 0) {
                ignored.add(tile);
                continue;
            }
            if (!(tile instanceof IPowerEmitter) || !(emitter = (IPowerEmitter)tile).canEmitPowerFrom(side.getOpposite())) continue;
            ignored.add(tile);
        }
        return ignored;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (MekanismUtils.useBuildcraft()) {
            if (this.powerHandler.getEnergyStored() > 0.0f) {
                ((EnergyNetwork)this.getTransmitterNetwork()).emit((double)this.powerHandler.getEnergyStored() * Mekanism.FROM_BC, this.getBuildCraftIgnored());
            }
            this.powerHandler.setEnergy(0.0f);
            this.reconfigure();
        }
    }

    public void setCachedEnergy(double scale) {
        this.energyScale = scale;
    }

    public float getEnergyScale() {
        return (float)this.energyScale;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double demandedEnergyUnits() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded(this.getBuildCraftIgnored()) * Mekanism.TO_IC2;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection direction, double i) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        list.add(Object3D.get(this).getFromSide(direction).getTileEntity((IBlockAccess)this.field_70331_k));
        return ((EnergyNetwork)this.getTransmitterNetwork()).emit(i * Mekanism.FROM_IC2, list) * Mekanism.TO_IC2;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getTransmitterNetworkSize() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getSize();
    }

    @Override
    public int getTransmitterNetworkAcceptorSize() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getAcceptorSize();
    }

    @Override
    public String getTransmitterNetworkNeeded() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getNeeded();
    }

    @Override
    public String getTransmitterNetworkFlow() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getFlow();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        list.add(Object3D.get(this).getFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k));
        if (!simulate) {
            return maxReceive - (int)Math.round(((EnergyNetwork)this.getTransmitterNetwork()).emit((double)maxReceive * Mekanism.FROM_TE, list) * Mekanism.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        list.add(Object3D.get(this).getFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k));
        return (int)Math.round(((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded(list) * Mekanism.TO_TE);
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return true;
    }

    @Override
    public float receiveElectricity(ForgeDirection from, ElectricityPack receive, boolean doReceive) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        list.add(Object3D.get(this).getFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k));
        if (doReceive && receive != null && receive.getWatts() > 0.0f) {
            return receive.getWatts() - (float)((EnergyNetwork)this.getTransmitterNetwork()).emit((double)receive.getWatts() * Mekanism.FROM_UE, list);
        }
        return 0.0f;
    }

    @Override
    public ElectricityPack provideElectricity(ForgeDirection from, ElectricityPack request, boolean doProvide) {
        return null;
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        list.add(Object3D.get(this).getFromSide(direction).getTileEntity((IBlockAccess)this.field_70331_k));
        return (float)(((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded(list) * Mekanism.TO_UE);
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public float getVoltage() {
        return 120.0f;
    }
}

