/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transporter;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.common.transporter.InvStack;
import mekanism.common.transporter.TransporterFilter;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TOreDictFilter
extends TransporterFilter {
    public String oreDictName;

    @Override
    public boolean canFilter(ItemStack itemStack) {
        String oreKey = MekanismUtils.getOreDictName(itemStack);
        if (oreKey == null) {
            return false;
        }
        if (this.oreDictName.equals(oreKey) || this.oreDictName.equals("*")) {
            return true;
        }
        return this.oreDictName.endsWith("*") && !this.oreDictName.startsWith("*") ? oreKey.startsWith(this.oreDictName.substring(0, this.oreDictName.length() - 1)) : (this.oreDictName.startsWith("*") && !this.oreDictName.endsWith("*") ? oreKey.endsWith(this.oreDictName.substring(1)) : this.oreDictName.startsWith("*") && this.oreDictName.endsWith("*") && oreKey.contains(this.oreDictName.substring(1, this.oreDictName.length() - 1)));
    }

    @Override
    public InvStack getStackFromInventory(IInventory inv, ForgeDirection side) {
        return InventoryUtils.takeTopStack(inv, side.ordinal());
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74768_a("type", 1);
        nbtTags.func_74778_a("oreDictName", this.oreDictName);
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.oreDictName = nbtTags.func_74779_i("oreDictName");
    }

    @Override
    public void write(ArrayList data) {
        data.add(1);
        super.write(data);
        data.add(this.oreDictName);
    }

    @Override
    protected void read(ByteArrayDataInput dataStream) {
        super.read(dataStream);
        this.oreDictName = dataStream.readUTF();
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + super.hashCode();
        code = 31 * code + this.oreDictName.hashCode();
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return super.equals(filter) && filter instanceof TOreDictFilter && ((TOreDictFilter)filter).oreDictName.equals(this.oreDictName);
    }

    public TOreDictFilter clone() {
        TOreDictFilter filter = new TOreDictFilter();
        filter.color = this.color;
        filter.oreDictName = this.oreDictName;
        return filter;
    }
}

