/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Object3D;
import mekanism.common.tileentity.TileEntityLogisticalSorter;
import mekanism.common.tileentity.TileEntityLogisticalTransporter;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public final class TransporterPathfinder {
    public static List<Destination> getPaths(TileEntityLogisticalTransporter start, TransporterStack stack, int min) {
        Pathfinder.DestChecker checker = new Pathfinder.DestChecker(){

            @Override
            public boolean isValid(TransporterStack stack, int side, TileEntity tile) {
                return InventoryUtils.canInsert(tile, stack.color, stack.itemStack, side, false);
            }
        };
        InventoryFinder d = new InventoryFinder(start.field_70331_k, Object3D.get(start), stack);
        Set<Object3D> destsFound = d.find();
        ArrayList<Destination> paths = new ArrayList<Destination>();
        for (Object3D obj : destsFound) {
            Pathfinder p = new Pathfinder(checker, start.field_70331_k, obj, Object3D.get(start), stack);
            if (p.getPath().size() < 2 || TransporterManager.getToUse((ItemStack)stack.itemStack, (ItemStack)d.rejects.get((Object)obj)).field_77994_a < min) continue;
            paths.add(new Destination(p.getPath(), p.finalScore, false, d.rejects.get(obj)));
        }
        Collections.sort(paths);
        return paths;
    }

    public static Destination getNewBasePath(TileEntityLogisticalTransporter start, TransporterStack stack, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, min);
        if (paths.isEmpty()) {
            return null;
        }
        return paths.get(0);
    }

    public static Destination getNewRRPath(TileEntityLogisticalTransporter start, TransporterStack stack, TileEntityLogisticalSorter outputter, int min) {
        List<Destination> paths = TransporterPathfinder.getPaths(start, stack, min);
        HashMap<Object3D, Destination> destPaths = new HashMap<Object3D, Destination>();
        for (Destination d : paths) {
            if (destPaths.get(d.path.get(0)) != null && !(((Destination)destPaths.get((Object)d.path.get((int)0))).score < d.score)) continue;
            destPaths.put(d.path.get(0), d);
        }
        ArrayList dests = new ArrayList();
        dests.addAll(destPaths.values());
        Collections.sort(dests);
        Destination closest = null;
        if (!dests.isEmpty()) {
            if (outputter.rrIndex <= dests.size() - 1) {
                closest = (Destination)dests.get(outputter.rrIndex);
                if (outputter.rrIndex == dests.size() - 1) {
                    outputter.rrIndex = 0;
                } else if (outputter.rrIndex < dests.size() - 1) {
                    ++outputter.rrIndex;
                }
            } else {
                closest = (Destination)dests.get(dests.size() - 1);
                outputter.rrIndex = 0;
            }
        }
        if (closest == null) {
            return null;
        }
        return closest;
    }

    public static List<Object3D> getIdlePath(TileEntityLogisticalTransporter start, TransporterStack stack) {
        if (stack.homeLocation != null) {
            Pathfinder.DestChecker checker = new Pathfinder.DestChecker(){

                @Override
                public boolean isValid(TransporterStack stack, int side, TileEntity tile) {
                    return InventoryUtils.canInsert(tile, stack.color, stack.itemStack, side, true);
                }
            };
            Pathfinder p = new Pathfinder(checker, start.field_70331_k, stack.homeLocation, Object3D.get(start), stack);
            ArrayList<Object3D> path = p.getPath();
            if (path.size() >= 2) {
                stack.pathType = TransporterStack.Path.HOME;
                return path;
            }
            if (stack.homeLocation.getTileEntity((IBlockAccess)start.field_70331_k) == null) {
                stack.homeLocation = null;
            }
        }
        IdlePath d = new IdlePath(start.field_70331_k, Object3D.get(start), stack);
        List<Object3D> path = d.find();
        stack.pathType = TransporterStack.Path.NONE;
        if (path == null) {
            return null;
        }
        return path;
    }

    public static class Pathfinder {
        public final Set<Object3D> openSet;
        public final Set<Object3D> closedSet;
        public final HashMap<Object3D, Object3D> navMap;
        public final HashMap<Object3D, Double> gScore;
        public final HashMap<Object3D, Double> fScore;
        public final Object3D start;
        public final Object3D finalNode;
        public final TransporterStack transportStack;
        public final DestChecker destChecker;
        public double finalScore;
        public ArrayList<Object3D> results;
        private World worldObj;

        public Pathfinder(DestChecker checker, World world, Object3D finishObj, Object3D startObj, TransporterStack stack) {
            this.destChecker = checker;
            this.worldObj = world;
            this.finalNode = finishObj;
            this.start = startObj;
            this.transportStack = stack;
            this.openSet = new HashSet<Object3D>();
            this.closedSet = new HashSet<Object3D>();
            this.navMap = new HashMap();
            this.gScore = new HashMap();
            this.fScore = new HashMap();
            this.results = new ArrayList();
            this.find(this.start);
        }

        public boolean find(Object3D start) {
            this.openSet.add(start);
            this.gScore.put(start, 0.0);
            this.fScore.put(start, this.gScore.get(start) + this.getEstimate(start, this.finalNode));
            int blockCount = 0;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                Object3D neighbor = start.translate(direction.offsetX, direction.offsetY, direction.offsetZ);
                if (this.transportStack.canInsertToTransporter(neighbor.getTileEntity((IBlockAccess)this.worldObj)) || neighbor.equals(this.finalNode) && this.destChecker.isValid(this.transportStack, i, neighbor.getTileEntity((IBlockAccess)this.worldObj))) continue;
                ++blockCount;
            }
            if (blockCount >= 6) {
                return false;
            }
            double maxSearchDistance = start.distanceTo(this.finalNode) * 2;
            while (!this.openSet.isEmpty()) {
                Object3D currentNode = null;
                double lowestFScore = 0.0;
                for (Object3D node : this.openSet) {
                    if (currentNode != null && !(this.fScore.get(node) < lowestFScore)) continue;
                    currentNode = node;
                    lowestFScore = this.fScore.get(node);
                }
                if (currentNode == null && (double)start.distanceTo(currentNode) > maxSearchDistance) break;
                this.openSet.remove(currentNode);
                this.closedSet.add(currentNode);
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    Object3D neighbor = currentNode.getFromSide(direction);
                    if (this.transportStack.canInsertToTransporter(neighbor.getTileEntity((IBlockAccess)this.worldObj))) {
                        TileEntity currTile;
                        TileEntity tile = neighbor.getTileEntity((IBlockAccess)this.worldObj);
                        double tentativeG = this.gScore.get(currentNode) + (double)currentNode.distanceTo(neighbor);
                        if (neighbor.getMetadata((IBlockAccess)this.worldObj) == 4) {
                            tentativeG += 999.0;
                        }
                        if (this.closedSet.contains(neighbor) && tentativeG >= this.gScore.get(neighbor) || !TransporterUtils.checkDiversionLogic(currTile = currentNode.getTileEntity((IBlockAccess)this.worldObj), tile, i) || this.openSet.contains(neighbor) && !(tentativeG < this.gScore.get(neighbor))) continue;
                        this.navMap.put(neighbor, currentNode);
                        this.gScore.put(neighbor, tentativeG);
                        this.fScore.put(neighbor, this.gScore.get(neighbor) + this.getEstimate(neighbor, this.finalNode));
                        this.openSet.add(neighbor);
                        continue;
                    }
                    if (!neighbor.equals(this.finalNode) || !this.destChecker.isValid(this.transportStack, i, neighbor.getTileEntity((IBlockAccess)this.worldObj))) continue;
                    this.results = this.reconstructPath(this.navMap, currentNode);
                    return true;
                }
            }
            return false;
        }

        private ArrayList<Object3D> reconstructPath(HashMap<Object3D, Object3D> naviMap, Object3D currentNode) {
            ArrayList<Object3D> path = new ArrayList<Object3D>();
            path.add(currentNode);
            if (naviMap.containsKey(currentNode)) {
                path.addAll(this.reconstructPath(naviMap, naviMap.get(currentNode)));
            }
            this.finalScore = this.gScore.get(currentNode) + (double)currentNode.distanceTo(this.finalNode);
            return path;
        }

        public ArrayList<Object3D> getPath() {
            ArrayList<Object3D> path = new ArrayList<Object3D>();
            path.add(this.finalNode);
            path.addAll((ArrayList)this.results.clone());
            return path;
        }

        private double getEstimate(Object3D start, Object3D target2) {
            return start.distanceTo(target2);
        }

        public static class DestChecker {
            public boolean isValid(TransporterStack stack, int side, TileEntity tile) {
                return false;
            }
        }
    }

    public static class InventoryFinder {
        public World worldObj;
        public Set<Object3D> iterated = new HashSet<Object3D>();
        public Set<Object3D> destsFound = new HashSet<Object3D>();
        public Map<Object3D, ItemStack> rejects = new HashMap<Object3D, ItemStack>();
        public Object3D start;
        public TransporterStack transportStack;

        public InventoryFinder(World world, Object3D obj, TransporterStack stack) {
            this.worldObj = world;
            this.start = obj;
            this.transportStack = stack;
        }

        public void loop(Object3D pointer) {
            if (pointer == null) {
                return;
            }
            this.iterated.add(pointer);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = pointer.getFromSide(side).getTileEntity((IBlockAccess)this.worldObj);
                if (tile == null || Object3D.get(tile).equals(this.transportStack.originalLocation)) continue;
                if (tile instanceof IInventory) {
                    ItemStack stack = TransporterManager.getPredictedInsert(tile, this.transportStack.color, this.transportStack.itemStack, side.ordinal());
                    if (!TransporterManager.didEmit(this.transportStack.itemStack, stack)) continue;
                    this.destsFound.add(Object3D.get(tile));
                    this.rejects.put(Object3D.get(tile), stack);
                    continue;
                }
                if (!this.transportStack.canInsertToTransporter(tile) || this.iterated.contains(Object3D.get(tile))) continue;
                this.loop(Object3D.get(tile));
            }
        }

        public Set<Object3D> find() {
            this.loop(this.start);
            return this.destsFound;
        }
    }

    public static class Destination
    implements Comparable<Destination> {
        public List<Object3D> path = new ArrayList<Object3D>();
        public double score;
        public ItemStack rejected;

        public Destination(ArrayList<Object3D> list, double d, boolean inv, ItemStack rejects) {
            this.path = (List)list.clone();
            if (inv) {
                Collections.reverse(this.path);
            }
            this.score = d;
            this.rejected = rejects;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.path.hashCode();
            code = 31 * code + new Double(this.score).hashCode();
            return code;
        }

        public boolean equals(Object dest) {
            return dest instanceof Destination && ((Destination)dest).path.equals(this.path) && ((Destination)dest).score == this.score;
        }

        @Override
        public int compareTo(Destination dest) {
            if (this.score < dest.score) {
                return -1;
            }
            if (this.score > dest.score) {
                return 1;
            }
            return 0;
        }
    }

    public static class IdlePath {
        public World worldObj;
        public Object3D start;
        public Set<Destination> destinations = new HashSet<Destination>();
        public TransporterStack transportStack;

        public IdlePath(World world, Object3D obj, TransporterStack stack) {
            this.worldObj = world;
            this.start = obj;
            this.transportStack = stack;
        }

        public void loop(Object3D pointer, ArrayList<Object3D> currentPath, int dist) {
            if (pointer == null) {
                return;
            }
            currentPath.add(pointer);
            dist = pointer.getMetadata((IBlockAccess)this.worldObj) == 4 ? (dist += 1000) : ++dist;
            boolean found = false;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = pointer.getFromSide(side).getTileEntity((IBlockAccess)this.worldObj);
                if (!this.transportStack.canInsertToTransporter(tile) || currentPath.contains(Object3D.get(tile)) || !TransporterUtils.checkDiversionLogic(pointer.getTileEntity((IBlockAccess)this.worldObj), tile, side.ordinal())) continue;
                this.loop(Object3D.get(tile), (ArrayList)currentPath.clone(), dist);
                found = true;
            }
            if (!found) {
                this.destinations.add(new Destination(currentPath, dist, true, null));
            }
        }

        public List<Object3D> find() {
            this.loop(this.start, new ArrayList<Object3D>(), 0);
            Destination farthest = null;
            for (Destination obj : this.destinations) {
                if (farthest != null && !(obj.score > farthest.score) || obj.path.isEmpty() || obj.path.get(0).equals(this.start)) continue;
                farthest = obj;
            }
            if (farthest == null) {
                return null;
            }
            return farthest.path;
        }
    }
}

