/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transporter;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.common.tileentity.TileEntityLogisticalSorter;
import mekanism.common.tileentity.TileEntityLogisticalTransporter;
import mekanism.common.transporter.TransporterPathfinder;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TransporterStack {
    public ItemStack itemStack;
    public int progress;
    public EnumColor color = null;
    public boolean initiatedPath = false;
    public List<Object3D> pathToTarget = new ArrayList<Object3D>();
    public Object3D originalLocation;
    public Object3D homeLocation;
    public Object3D clientNext;
    public Object3D clientPrev;
    public Path pathType;

    public void write(TileEntityLogisticalTransporter tileEntity, ArrayList data) {
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.progress);
        data.add(this.pathType.ordinal());
        if (this.pathToTarget.indexOf(Object3D.get(tileEntity)) > 0) {
            data.add(true);
            this.getNext(tileEntity).write(data);
        } else {
            data.add(false);
        }
        this.getPrev(tileEntity).write(data);
        data.add(this.itemStack.field_77993_c);
        data.add(this.itemStack.field_77994_a);
        data.add(this.itemStack.func_77960_j());
    }

    public void read(ByteArrayDataInput dataStream) {
        int c = dataStream.readInt();
        this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
        this.progress = dataStream.readInt();
        this.pathType = Path.values()[dataStream.readInt()];
        if (dataStream.readBoolean()) {
            this.clientNext = Object3D.read(dataStream);
        }
        this.clientPrev = Object3D.read(dataStream);
        this.itemStack = new ItemStack(dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
    }

    public void write(NBTTagCompound nbtTags) {
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74768_a("progress", this.progress);
        nbtTags.func_74766_a("originalLocation", this.originalLocation.write(new NBTTagCompound()));
        if (this.homeLocation != null) {
            nbtTags.func_74766_a("homeLocation", this.homeLocation.write(new NBTTagCompound()));
        }
        nbtTags.func_74768_a("pathType", this.pathType.ordinal());
        this.itemStack.func_77955_b(nbtTags);
    }

    public void read(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.progress = nbtTags.func_74762_e("progress");
        this.originalLocation = Object3D.read(nbtTags.func_74775_l("originalLocation"));
        if (nbtTags.func_74764_b("homeLocation")) {
            this.homeLocation = Object3D.read(nbtTags.func_74775_l("homeLocation"));
        }
        this.pathType = Path.values()[nbtTags.func_74762_e("pathType")];
        this.itemStack = ItemStack.func_77949_a((NBTTagCompound)nbtTags);
    }

    public static TransporterStack readFromNBT(NBTTagCompound nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.read(nbtTags);
        return stack;
    }

    public static TransporterStack readFromPacket(ByteArrayDataInput dataStream) {
        TransporterStack stack = new TransporterStack();
        stack.read(dataStream);
        return stack;
    }

    public boolean hasPath() {
        return this.pathToTarget != null && this.pathToTarget.size() >= 2;
    }

    public ItemStack recalculatePath(TileEntityLogisticalTransporter tileEntity, int min) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewBasePath(tileEntity, this, min);
        if (newPath == null) {
            return this.itemStack;
        }
        this.pathToTarget = newPath.path;
        this.pathType = Path.DEST;
        this.initiatedPath = true;
        return newPath.rejected;
    }

    public ItemStack recalculateRRPath(TileEntityLogisticalSorter outputter, TileEntityLogisticalTransporter tileEntity, int min) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewRRPath(tileEntity, this, outputter, min);
        if (newPath == null) {
            return this.itemStack;
        }
        this.pathToTarget = newPath.path;
        this.pathType = Path.DEST;
        this.initiatedPath = true;
        return newPath.rejected;
    }

    public boolean calculateIdle(TileEntityLogisticalTransporter tileEntity) {
        List<Object3D> newPath = TransporterPathfinder.getIdlePath(tileEntity, this);
        if (newPath == null) {
            return false;
        }
        this.pathToTarget = newPath;
        this.originalLocation = Object3D.get(tileEntity);
        this.initiatedPath = true;
        return true;
    }

    public boolean isFinal(TileEntityLogisticalTransporter tileEntity) {
        return this.pathToTarget.indexOf(Object3D.get(tileEntity)) == (this.pathType == Path.NONE ? 0 : 1);
    }

    public Object3D getNext(TileEntityLogisticalTransporter tileEntity) {
        if (!tileEntity.field_70331_k.field_72995_K) {
            int index = this.pathToTarget.indexOf(Object3D.get(tileEntity)) - 1;
            if (index < 0) {
                return null;
            }
            return this.pathToTarget.get(index);
        }
        return this.clientNext;
    }

    public Object3D getPrev(TileEntityLogisticalTransporter tileEntity) {
        if (!tileEntity.field_70331_k.field_72995_K) {
            int index = this.pathToTarget.indexOf(Object3D.get(tileEntity)) + 1;
            if (index < this.pathToTarget.size()) {
                return this.pathToTarget.get(index);
            }
            return this.originalLocation;
        }
        return this.clientPrev;
    }

    public int getSide(TileEntityLogisticalTransporter tileEntity) {
        if (this.progress < 50) {
            if (this.getPrev(tileEntity) != null) {
                return Object3D.get(tileEntity).sideDifference(this.getPrev(tileEntity)).ordinal();
            }
        } else if (this.progress == 50 ? this.getNext(tileEntity) != null : this.progress > 50 && this.getNext(tileEntity) != null) {
            return this.getNext(tileEntity).sideDifference(Object3D.get(tileEntity)).ordinal();
        }
        return 0;
    }

    public boolean canInsertToTransporter(TileEntity tileEntity) {
        if (!(tileEntity instanceof TileEntityLogisticalTransporter)) {
            return false;
        }
        TileEntityLogisticalTransporter transporter = (TileEntityLogisticalTransporter)tileEntity;
        return transporter.color == this.color || transporter.color == null;
    }

    public Object3D getDest() {
        return this.pathToTarget.get(0);
    }

    public static enum Path {
        DEST,
        HOME,
        NONE;

    }
}

