/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mekanism.api.Object3D;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.EnergyNetwork;
import mekanism.common.Mekanism;
import mekanism.common.tileentity.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.electricity.ElectricityHelper;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;

public final class CableUtils {
    public static TileEntity[] getConnectedEnergyAcceptors(TileEntity tileEntity) {
        TileEntity[] acceptors = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity acceptor = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(acceptor instanceof IStrictEnergyAcceptor) && !(acceptor instanceof IEnergySink) && (!(acceptor instanceof IPowerReceptor) || acceptor instanceof ITransmitter || !MekanismUtils.useBuildcraft()) && !(acceptor instanceof IElectrical) && !(acceptor instanceof IEnergyHandler) || acceptor instanceof IConductor) continue;
            acceptors[orientation.ordinal()] = acceptor;
        }
        return acceptors;
    }

    public static TileEntity[] getConnectedCables(TileEntity tileEntity) {
        TileEntity[] cables = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity cable = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!TransmissionType.checkTransmissionType(cable, TransmissionType.ENERGY)) continue;
            cables[orientation.ordinal()] = cable;
        }
        return cables;
    }

    public static boolean[] getConnections(TileEntity tileEntity) {
        int side;
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        TileEntity[] connectedAcceptors = CableUtils.getConnectedEnergyAcceptors(tileEntity);
        TileEntity[] connectedCables = CableUtils.getConnectedCables(tileEntity);
        TileEntity[] connectedOutputters = CableUtils.getConnectedOutputters(tileEntity);
        for (TileEntity tile : connectedAcceptors) {
            side = Arrays.asList(connectedAcceptors).indexOf(tile);
            if (!CableUtils.canConnectToAcceptor(ForgeDirection.getOrientation((int)side), tileEntity)) continue;
            connectable[side] = true;
        }
        for (TileEntity tile : connectedOutputters) {
            if (tile == null) continue;
            side = Arrays.asList(connectedOutputters).indexOf(tile);
            connectable[side] = true;
        }
        for (TileEntity tile : connectedCables) {
            if (tile == null) continue;
            side = Arrays.asList(connectedCables).indexOf(tile);
            connectable[side] = true;
        }
        return connectable;
    }

    public static TileEntity[] getConnectedOutputters(TileEntity tileEntity) {
        TileEntity[] outputters = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity outputter = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(outputter instanceof ICableOutputter && ((ICableOutputter)outputter).canOutputTo(orientation.getOpposite()) || outputter instanceof IEnergySource && ((IEnergySource)outputter).emitsEnergyTo(tileEntity, orientation.getOpposite()) || outputter instanceof IElectrical && ((IElectrical)outputter).canConnect(orientation.getOpposite())) && (!(outputter instanceof IEnergyHandler) || !((IEnergyHandler)outputter).canInterface(orientation.getOpposite()))) continue;
            outputters[orientation.ordinal()] = outputter;
        }
        return outputters;
    }

    public static boolean canConnectToAcceptor(ForgeDirection side, TileEntity tile) {
        TileEntity tileEntity = Object3D.get(tile).getFromSide(side).getTileEntity((IBlockAccess)tile.field_70331_k);
        if (tileEntity instanceof IStrictEnergyAcceptor && ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(side.getOpposite())) {
            return true;
        }
        if (tileEntity instanceof IEnergyAcceptor && ((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(tile, side.getOpposite())) {
            return true;
        }
        if (tileEntity instanceof ICableOutputter && ((ICableOutputter)tileEntity).canOutputTo(side.getOpposite())) {
            return true;
        }
        if (tileEntity instanceof IElectrical && ((IElectrical)tileEntity).canConnect(side.getOpposite())) {
            return true;
        }
        if (tileEntity instanceof IEnergyHandler && ((IEnergyHandler)tileEntity).canInterface(side.getOpposite())) {
            return true;
        }
        return !(!(tileEntity instanceof IPowerReceptor) || tileEntity instanceof ITransmitter || !MekanismUtils.useBuildcraft() || tileEntity instanceof IEnergyAcceptor && !((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(null, side.getOpposite()) || tileEntity instanceof IEnergySource && !((IEnergySource)tileEntity).emitsEnergyTo(null, side.getOpposite()));
    }

    public static double emitEnergyToNetwork(double amount, TileEntity sender, ForgeDirection facing) {
        TileEntity pointer = Object3D.get(sender).getFromSide(facing).getTileEntity((IBlockAccess)sender.field_70331_k);
        if (TransmissionType.checkTransmissionType(pointer, TransmissionType.ENERGY)) {
            ITransmitter cable = (ITransmitter)pointer;
            ArrayList<TileEntity> ignored = new ArrayList<TileEntity>();
            ignored.add(sender);
            return ((EnergyNetwork)cable.getTransmitterNetwork()).emit(amount, ignored);
        }
        return amount;
    }

    public static void emit(TileEntityElectricBlock emitter) {
        double sendingEnergy;
        if (!emitter.field_70331_k.field_72995_K && MekanismUtils.canFunction(emitter) && (sendingEnergy = Math.min(emitter.getEnergy(), emitter.getMaxOutput())) > 0.0) {
            ArrayList<ForgeDirection> outputtingSides = new ArrayList<ForgeDirection>();
            boolean[] connectable = CableUtils.getConnections(emitter);
            for (ForgeDirection side : emitter.getOutputtingSides()) {
                if (!connectable[side.ordinal()]) continue;
                outputtingSides.add(side);
            }
            if (outputtingSides.size() > 0) {
                double totalToSend = sendingEnergy;
                boolean cont = false;
                do {
                    cont = false;
                    double prev = totalToSend;
                    if (!(prev - (totalToSend -= totalToSend - CableUtils.emit_do(emitter, outputtingSides, totalToSend)) > 0.0) || !(totalToSend > 0.0)) continue;
                    cont = true;
                } while (cont);
                emitter.setEnergy(emitter.getEnergy() - (sendingEnergy - totalToSend));
            }
        }
    }

    private static double emit_do(TileEntityElectricBlock emitter, List<ForgeDirection> outputtingSides, double totalToSend) {
        double remains = totalToSend % (double)outputtingSides.size();
        double splitSend = (totalToSend - remains) / (double)outputtingSides.size();
        ArrayList<ForgeDirection> toRemove = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : outputtingSides) {
            TileEntity tileEntity = Object3D.get(emitter).getFromSide(side).getTileEntity((IBlockAccess)emitter.field_70331_k);
            double toSend = splitSend + remains;
            remains = 0.0;
            double prev = totalToSend;
            if (prev - (totalToSend -= toSend - CableUtils.emit_do_do(emitter, tileEntity, side, toSend)) != 0.0) continue;
            toRemove.add(side);
        }
        for (ForgeDirection side : toRemove) {
            outputtingSides.remove(side);
        }
        return totalToSend;
    }

    private static double emit_do_do(TileEntityElectricBlock from, TileEntity tileEntity, ForgeDirection side, double sendingEnergy) {
        PowerHandler.PowerReceiver receiver;
        if (TransmissionType.checkTransmissionType(tileEntity, TransmissionType.ENERGY)) {
            sendingEnergy -= sendingEnergy - CableUtils.emitEnergyToNetwork(sendingEnergy, from, side);
        } else if (tileEntity instanceof IStrictEnergyAcceptor) {
            IStrictEnergyAcceptor acceptor = (IStrictEnergyAcceptor)tileEntity;
            sendingEnergy -= sendingEnergy - acceptor.transferEnergyToAcceptor(side.getOpposite(), sendingEnergy);
        } else if (tileEntity instanceof IConductor) {
            IElectricityNetwork outputNetwork;
            ForgeDirection outputDirection = side;
            float provide = from.getProvide(outputDirection);
            if (provide > 0.0f && (outputNetwork = ElectricityHelper.getNetworkFromTileEntity(tileEntity, outputDirection)) != null) {
                TileEntity[] tileEntityArray = new TileEntity[]{from};
                ElectricityPack request = outputNetwork.getRequest(tileEntityArray);
                if (request.getWatts() > 0.0f) {
                    float ueSend = (float)(sendingEnergy * Mekanism.TO_UE);
                    ElectricityPack sendPack = ElectricityPack.min(ElectricityPack.getFromWatts(ueSend, from.getVoltage()), ElectricityPack.getFromWatts(provide, from.getVoltage()));
                    float rejectedPower = outputNetwork.produce(sendPack, from);
                    sendingEnergy -= (double)(sendPack.getWatts() - rejectedPower) * Mekanism.FROM_UE;
                }
            }
        } else if (tileEntity instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tileEntity;
            int used = handler.receiveEnergy(side.getOpposite(), (int)Math.round(sendingEnergy * Mekanism.TO_TE), false);
            sendingEnergy -= (double)used * Mekanism.FROM_TE;
        } else if (tileEntity instanceof IEnergySink) {
            double toSend = Math.min(sendingEnergy, Math.min((double)((IEnergySink)tileEntity).getMaxSafeInput(), ((IEnergySink)tileEntity).demandedEnergyUnits()) * Mekanism.FROM_IC2);
            double rejects = ((IEnergySink)tileEntity).injectEnergyUnits(side.getOpposite(), toSend * Mekanism.TO_IC2) * Mekanism.FROM_IC2;
            sendingEnergy -= toSend - rejects;
        } else if (tileEntity instanceof IElectrical) {
            double toSend = Math.min(sendingEnergy, (double)((IElectrical)tileEntity).getRequest(side.getOpposite()) * Mekanism.FROM_UE);
            ElectricityPack pack = ElectricityPack.getFromWatts((float)(toSend * Mekanism.TO_UE), ((IElectrical)tileEntity).getVoltage());
            sendingEnergy -= (double)((IElectrical)tileEntity).receiveElectricity(side.getOpposite(), pack, true) * Mekanism.FROM_UE;
        } else if (tileEntity instanceof IPowerReceptor && MekanismUtils.useBuildcraft() && (receiver = ((IPowerReceptor)tileEntity).getPowerReceiver(side.getOpposite())) != null) {
            double transferEnergy = Math.min(sendingEnergy, (double)receiver.powerRequest() * Mekanism.FROM_BC);
            float sent = receiver.receiveEnergy(PowerHandler.Type.STORAGE, (float)(transferEnergy * Mekanism.TO_BC), side.getOpposite());
            sendingEnergy -= (double)sent;
        }
        return sendingEnergy;
    }
}

