/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ListUtils {
    public static <V> List<V> inverse(List<V> list) {
        ArrayList<V> toReturn = new ArrayList<V>();
        for (int i = list.size() - 1; i >= 0; --i) {
            toReturn.add(list.get(i));
        }
        return toReturn;
    }

    public static <V> List<V> cap(List<V> list, int cap) {
        List<Object> toReturn = new ArrayList();
        if (list.size() <= cap) {
            toReturn = ListUtils.copy(list);
        } else {
            int count = 0;
            for (V obj : list) {
                toReturn.add(obj);
                if (++count != cap) continue;
                break;
            }
        }
        return toReturn;
    }

    public static <V> List<V> copy(List<V> list) {
        ArrayList<V> toReturn = new ArrayList<V>();
        for (V obj : list) {
            toReturn.add(obj);
        }
        return toReturn;
    }

    public static <V> List<V> merge(List<V> listOne, List<V> listTwo) {
        ArrayList<V> newList = new ArrayList<V>();
        for (V obj : listOne) {
            newList.add(obj);
        }
        for (V obj : listTwo) {
            newList.add(obj);
        }
        return newList;
    }

    public static <V> List<V> capRemains(List<V> list, int cap) {
        ArrayList<V> toReturn = new ArrayList<V>();
        if (list.size() <= cap) {
            return toReturn;
        }
        List<V> inverse = ListUtils.inverse(list);
        int iterNeeded = list.size() - cap;
        int count = 0;
        for (V obj : list) {
            toReturn.add(obj);
            if (++count != iterNeeded) continue;
            break;
        }
        return toReturn;
    }

    public static <V> ArrayList<List<V>> split(List<V> list, int divide) {
        int remain = list.size() % divide;
        int size = (list.size() - remain) / divide;
        ArrayList<List<V>> toReturn = new ArrayList<List<V>>();
        for (int i = 0; i < divide; ++i) {
            toReturn.add(i, new ArrayList());
        }
        for (List list2 : toReturn) {
            ArrayList<V> removed = new ArrayList<V>();
            int toAdd = size;
            if (remain > 0) {
                --remain;
                ++toAdd;
            }
            for (Object obj : list) {
                if (toAdd == 0) break;
                list2.add(obj);
                removed.add(obj);
                --toAdd;
            }
            for (Object obj : removed) {
                list.remove(obj);
            }
        }
        return toReturn;
    }

    public static <V> V getTop(List<V> list) {
        Iterator<V> i$ = list.iterator();
        if (i$.hasNext()) {
            V obj = i$.next();
            return obj;
        }
        return null;
    }

    public static <V> List<V> asList(Set<V> set) {
        return Arrays.asList(set.toArray());
    }

    public static <V> List<V> asList(V ... values) {
        return Arrays.asList(values);
    }
}

