/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.server.FMLServerHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.common.DynamicTankCache;
import mekanism.common.IActiveState;
import mekanism.common.IFactory;
import mekanism.common.IInvConfiguration;
import mekanism.common.IModule;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Teleporter;
import mekanism.common.Tier;
import mekanism.common.Version;
import mekanism.common.inventory.container.ContainerElectricChest;
import mekanism.common.item.ItemBlockEnergyCube;
import mekanism.common.item.ItemBlockGasTank;
import mekanism.common.network.PacketElectricChest;
import mekanism.common.tileentity.TileEntityAdvancedBoundingBlock;
import mekanism.common.tileentity.TileEntityBoundingBlock;
import mekanism.common.tileentity.TileEntityDynamicTank;
import mekanism.common.tileentity.TileEntityElectricChest;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import universalelectricity.core.electricity.ElectricityDisplay;

public final class MekanismUtils {
    public static final ForgeDirection[] SIDE_DIRS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};

    public static boolean checkForUpdates(EntityPlayer entityplayer) {
        try {
            if (Mekanism.updateNotifications && Mekanism.latestVersionNumber != null && Mekanism.recentNews != null) {
                if (!Mekanism.latestVersionNumber.equals("null")) {
                    ArrayList<IModule> list = new ArrayList<IModule>();
                    for (IModule module : Mekanism.modulesLoaded) {
                        if (Version.get(Mekanism.latestVersionNumber).comparedState(module.getVersion()) != 1) continue;
                        list.add(module);
                    }
                    if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1 || !list.isEmpty()) {
                        entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " -------------");
                        entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + " Using outdated version on one or more modules.");
                        if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1) {
                            entityplayer.func_71035_c((Object)((Object)EnumColor.INDIGO) + " Mekanism: " + (Object)((Object)EnumColor.DARK_RED) + Mekanism.versionNumber);
                        }
                        for (IModule module : list) {
                            entityplayer.func_71035_c((Object)((Object)EnumColor.INDIGO) + " Mekanism" + module.getName() + ": " + (Object)((Object)EnumColor.DARK_RED) + module.getVersion());
                        }
                        entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + " Consider updating to version " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.latestVersionNumber);
                        entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + " New features: " + (Object)((Object)EnumColor.INDIGO) + Mekanism.recentNews);
                        entityplayer.func_71035_c((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------");
                        return true;
                    }
                    if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == -1) {
                        entityplayer.func_71035_c((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + "Using developer build " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.versionNumber);
                        return true;
                    }
                } else {
                    System.out.println("[Mekanism] Minecraft is in offline mode, could not check for updates.");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getLatestVersion() {
        String[] text = MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Mod%20Versions/Mekanism.txt").split(":");
        if (!(text[0].contains("UTF-8") || text[0].contains("HTML") || text[0].contains("http"))) {
            return text[0];
        }
        return "null";
    }

    public static String getRecentNews() {
        String[] text = MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Mod%20Versions/Mekanism.txt").split(":");
        if (!(text.length <= 1 || text[1].contains("UTF-8") || text[1].contains("HTML") || text[1].contains("http"))) {
            return text[1];
        }
        return "null";
    }

    public static String getHTML(String urlToRead) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result = result + line;
                sb.append(line);
            }
            rd.close();
        }
        catch (Exception e) {
            result = "null";
            System.err.println("[Mekanism] An error occured while connecting to URL '" + urlToRead + ".'");
        }
        return result;
    }

    public static void sendChatMessageToPlayer(String playerUsername, String msg) {
        EntityPlayerMP player = FMLServerHandler.instance().getServer().func_71203_ab().func_72361_f(playerUsername);
        Packet3Chat chatPacket = new Packet3Chat(msg);
        if (player != null) {
            player.field_71135_a.func_72567_b((Packet)chatPacket);
        }
    }

    public static Object3D getClosestCoords(Teleporter.Code teleCode, EntityPlayer player) {
        if (Mekanism.teleporters.get(teleCode).size() == 1) {
            return Mekanism.teleporters.get(teleCode).get(0);
        }
        int dimensionId = player.field_70170_p.field_73011_w.field_76574_g;
        Object3D coords0 = Mekanism.teleporters.get(teleCode).get(0);
        Object3D coords1 = Mekanism.teleporters.get(teleCode).get(1);
        int distance0 = (int)player.func_70011_f((double)coords0.xCoord, (double)coords0.yCoord, (double)coords0.zCoord);
        int distance1 = (int)player.func_70011_f((double)coords1.xCoord, (double)coords1.yCoord, (double)coords1.zCoord);
        if (dimensionId == coords0.dimensionId && dimensionId != coords1.dimensionId) {
            return coords0;
        }
        if (dimensionId == coords1.dimensionId && dimensionId != coords0.dimensionId) {
            return coords1;
        }
        if (dimensionId == coords0.dimensionId && dimensionId == coords1.dimensionId) {
            if (distance0 < distance1) {
                return coords0;
            }
            if (distance0 > distance1) {
                return coords1;
            }
        } else if (dimensionId != coords0.dimensionId && dimensionId != coords1.dimensionId) {
            if (distance0 < distance1) {
                return coords0;
            }
            if (distance0 > distance1) {
                return coords1;
            }
        }
        return null;
    }

    public static void sendChatMessageToAllPlayers(String msg) {
        PacketDispatcher.sendPacketToAllPlayers((Packet)new Packet3Chat(msg));
    }

    public static boolean noUpdates() {
        if (Mekanism.latestVersionNumber.contains("null")) {
            return true;
        }
        if (Mekanism.versionNumber.comparedState(Version.get(Mekanism.latestVersionNumber)) == -1) {
            return false;
        }
        for (IModule module : Mekanism.modulesLoaded) {
            if (module.getVersion().comparedState(Version.get(Mekanism.latestVersionNumber)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isOffline() {
        try {
            new URL("http://www.apple.com").openConnection().connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void doFakeEntityExplosion(EntityPlayer entityplayer) {
        World world = entityplayer.field_70170_p;
        world.func_72869_a("hugeexplosion", entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, 0.0, 0.0, 0.0);
        world.func_72956_a((Entity)entityplayer, "random.explode", 1.0f, 1.0f);
    }

    public static void doFakeBlockExplosion(World world, int x, int y, int z) {
        world.func_72869_a("hugeexplosion", (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        world.func_72980_b((double)x, (double)y, (double)z, "random.explode", 1.0f, 1.0f, true);
    }

    public static ItemStack size(ItemStack itemstack, int size) {
        ItemStack newStack = itemstack.func_77946_l();
        newStack.field_77994_a = size;
        return newStack;
    }

    public static void addRecipe(ItemStack output, Object[] params) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(output, params));
    }

    public static ItemStack getEnergyCube(Tier.EnergyCubeTier tier) {
        ItemStack itemstack = ((ItemBlockEnergyCube)new ItemStack(Mekanism.EnergyCube).func_77973_b()).getUnchargedItem(tier);
        return itemstack;
    }

    public static ItemStack getEmptyGasTank() {
        ItemStack itemstack = ((ItemBlockGasTank)new ItemStack(Mekanism.GasTank).func_77973_b()).getEmptyItem();
        return itemstack;
    }

    public static ItemStack getFactory(Tier.FactoryTier tier, IFactory.RecipeType type) {
        ItemStack itemstack = new ItemStack(Mekanism.MachineBlock, 1, 5 + tier.ordinal());
        ((IFactory)itemstack.func_77973_b()).setRecipeType(type.ordinal(), itemstack);
        return itemstack;
    }

    public static boolean isActive(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity != null && tileEntity instanceof IActiveState) {
            return ((IActiveState)tileEntity).getActive();
        }
        return false;
    }

    public static ForgeDirection getLeft(int orientation) {
        switch (orientation) {
            case 2: {
                return ForgeDirection.EAST;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
            case 4: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.SOUTH;
    }

    public static ForgeDirection getRight(int orientation) {
        return MekanismUtils.getLeft(orientation).getOpposite();
    }

    public static boolean oreDictCheck(ItemStack check, String oreDict) {
        boolean hasResource = false;
        for (ItemStack ore : OreDictionary.getOres((String)oreDict)) {
            if (!ore.func_77969_a(check)) continue;
            hasResource = true;
        }
        return hasResource;
    }

    public static String getOreDictName(ItemStack check) {
        HashMap oreStacks = (HashMap)MekanismUtils.getPrivateValue(null, OreDictionary.class, new String[]{"oreStacks"});
        int idFound = -1;
        for (Map.Entry entry : oreStacks.entrySet()) {
            for (ItemStack stack : (ArrayList)entry.getValue()) {
                if (!stack.func_77969_a(check)) continue;
                idFound = (Integer)entry.getKey();
                break;
            }
            if (idFound == -1) continue;
            break;
        }
        if (idFound == -1) {
            return null;
        }
        return OreDictionary.getOreName((int)idFound);
    }

    public static int getBaseOrientation(int side, int blockFacing) {
        if (blockFacing == 3 || side == 1 || side == 0) {
            if (side == 2 || side == 3) {
                return ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            }
            return side;
        }
        if (blockFacing == 2) {
            if (side == 2 || side == 3) {
                return side;
            }
            return ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
        }
        if (blockFacing == 4) {
            if (side == 2 || side == 3) {
                return MekanismUtils.getRight(side).ordinal();
            }
            return MekanismUtils.getLeft(side).ordinal();
        }
        if (blockFacing == 5) {
            if (side == 2 || side == 3) {
                return MekanismUtils.getLeft(side).ordinal();
            }
            return MekanismUtils.getRight(side).ordinal();
        }
        return side;
    }

    public static String localize(String s) {
        return StatCollector.func_74838_a((String)s);
    }

    public static void incrementOutput(IInvConfiguration config, int side) {
        int max = config.getSideData().size() - 1;
        int current = config.getSideData().indexOf(config.getSideData().get(config.getConfiguration()[side]));
        if (current < max) {
            config.getConfiguration()[side] = (byte)(current + 1);
        } else if (current == max) {
            config.getConfiguration()[side] = 0;
        }
    }

    public static void decrementOutput(IInvConfiguration config, int side) {
        int max = config.getSideData().size() - 1;
        int current = config.getSideData().indexOf(config.getSideData().get(config.getConfiguration()[side]));
        if (current > 0) {
            config.getConfiguration()[side] = (byte)(current - 1);
        } else if (current == 0) {
            config.getConfiguration()[side] = (byte)max;
        }
    }

    public static int getTicks(int speedUpgrade, int def) {
        return (int)((double)def * Math.pow(10.0, (double)(-speedUpgrade) / 9.0));
    }

    public static double getEnergyPerTick(int speedUpgrade, int energyUpgrade, double def) {
        return def * Math.pow(10.0, (double)(speedUpgrade - energyUpgrade) / 9.0);
    }

    public static double getEnergy(int energyUpgrade, double def) {
        return (int)(def * Math.pow(10.0, (double)energyUpgrade / 9.0));
    }

    public static void makeBoundingBlock(World world, int x, int y, int z, Object3D orig) {
        world.func_94575_c(x, y, z, Mekanism.BoundingBlock.field_71990_ca);
        if (!world.field_72995_K) {
            ((TileEntityBoundingBlock)world.func_72796_p(x, y, z)).setMainLocation(orig.xCoord, orig.yCoord, orig.zCoord);
        }
    }

    public static void makeAdvancedBoundingBlock(World world, int x, int y, int z, Object3D orig) {
        world.func_72832_d(x, y, z, Mekanism.BoundingBlock.field_71990_ca, 1, 3);
        if (!world.field_72995_K) {
            ((TileEntityAdvancedBoundingBlock)world.func_72796_p(x, y, z)).setMainLocation(orig.xCoord, orig.yCoord, orig.zCoord);
        }
    }

    public static void updateBlock(World world, int x, int y, int z) {
        if (!(world.func_72796_p(x, y, z) instanceof IActiveState) || ((IActiveState)world.func_72796_p(x, y, z)).renderUpdate()) {
            world.func_72902_n(x, y, z);
        }
        if (!(world.func_72796_p(x, y, z) instanceof IActiveState) || ((IActiveState)world.func_72796_p(x, y, z)).lightUpdate()) {
            world.func_72969_x(x, y, z);
        }
    }

    public static boolean isFluid(World world, int x, int y, int z) {
        return MekanismUtils.getFluid(world, x, y, z) != null;
    }

    public static FluidStack getFluid(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == 0) {
            return null;
        }
        if ((id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca) && meta == 0) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if ((id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca) && meta == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (Block.field_71973_m[id] instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock)Block.field_71973_m[id];
            if (meta == 0) {
                return new FluidStack(fluid.getFluid(), 1000);
            }
        }
        return null;
    }

    public static int getFluidId(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == 0) {
            return 0;
        }
        if (id == Block.field_71942_A.field_71990_ca) {
            return FluidRegistry.WATER.getID();
        }
        if (id == Block.field_71944_C.field_71990_ca) {
            return FluidRegistry.LAVA.getID();
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid.getBlockID() != id) continue;
            return fluid.getID();
        }
        return 0;
    }

    public static boolean isDeadFluid(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == 0) {
            return false;
        }
        if ((id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca) && meta != 0) {
            return true;
        }
        if ((id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca) && meta != 0) {
            return true;
        }
        if (Block.field_71973_m[id] instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock)Block.field_71973_m[id];
            if (meta != 0) {
                return true;
            }
        }
        return false;
    }

    public static void openElectricChestGui(EntityPlayerMP player, TileEntityElectricChest tileEntity, IInventory inventory, boolean isBlock) {
        player.func_71117_bO();
        player.func_71128_l();
        int id = player.field_71139_cq;
        if (isBlock) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 0, id, true, Object3D.get(tileEntity)}), player);
        } else {
            PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 0, id, false}), player);
        }
        player.field_71070_bA = new ContainerElectricChest(player.field_71071_by, tileEntity, inventory, isBlock);
        player.field_71070_bA.field_75152_c = id;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    public static DynamicTankCache pullInventory(World world, int id) {
        DynamicTankCache toReturn = Mekanism.dynamicInventories.get(id);
        for (Object3D obj : Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)id)).locations) {
            TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)obj.getTileEntity((IBlockAccess)world);
            if (tileEntity == null) continue;
            tileEntity.cachedFluid = null;
            tileEntity.inventory = new ItemStack[2];
            tileEntity.inventoryID = -1;
        }
        Mekanism.dynamicInventories.remove(id);
        return toReturn;
    }

    public static void updateCache(int inventoryID, FluidStack fluid, ItemStack[] inventory, TileEntityDynamicTank tileEntity) {
        if (!Mekanism.dynamicInventories.containsKey(inventoryID)) {
            DynamicTankCache cache = new DynamicTankCache();
            cache.inventory = inventory;
            cache.fluid = fluid;
            cache.locations.add(Object3D.get(tileEntity));
            Mekanism.dynamicInventories.put(inventoryID, cache);
            return;
        }
        Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)inventoryID)).inventory = inventory;
        Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)inventoryID)).fluid = fluid;
        Mekanism.dynamicInventories.get((Object)Integer.valueOf((int)inventoryID)).locations.add(Object3D.get(tileEntity));
    }

    public static int getUniqueInventoryID() {
        int id = 0;
        for (Integer i : Mekanism.dynamicInventories.keySet()) {
            if (id != i) continue;
            ++id;
        }
        return id;
    }

    public static String getName(ItemStack itemStack) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack));
    }

    public static Object getPrivateValue(Object obj, Class c, String[] fields) {
        for (String field : fields) {
            try {
                Field f = c.getDeclaredField(field);
                f.setAccessible(true);
                return f.get(obj);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static void setPrivateValue(Object obj, Object value, Class c, String[] fields) {
        for (String field : fields) {
            try {
                Field f = c.getDeclaredField(field);
                f.setAccessible(true);
                f.set(obj, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static Method getPrivateMethod(Class c, String[] methods, Class ... params) {
        for (String method : methods) {
            try {
                Method m = c.getDeclaredMethod(method, params);
                m.setAccessible(true);
                return m;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static ResourceLocation getResource(ResourceType type, String name) {
        return new ResourceLocation("mekanism", type.getPrefix() + name);
    }

    public static boolean removeRecipes(ItemStack ... itemStacks) {
        boolean didRemove = false;
        Iterator itr = CraftingManager.func_77594_a().func_77592_b().iterator();
        block0: while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof IRecipe) || ((IRecipe)obj).func_77571_b() == null) continue;
            for (ItemStack itemStack : itemStacks) {
                if (!((IRecipe)obj).func_77571_b().func_77969_a(itemStack)) continue;
                itr.remove();
                didRemove = true;
                continue block0;
            }
        }
        return didRemove;
    }

    public static void saveChunk(TileEntity tileEntity) {
        if (tileEntity == null || tileEntity.func_70320_p() || tileEntity.field_70331_k == null) {
            return;
        }
        tileEntity.field_70331_k.func_72944_b(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n, tileEntity);
    }

    public static boolean canFunction(TileEntity tileEntity) {
        if (!(tileEntity instanceof IRedstoneControl)) {
            return true;
        }
        World world = tileEntity.field_70331_k;
        IRedstoneControl control = (IRedstoneControl)tileEntity;
        if (control.getControlType() == IRedstoneControl.RedstoneControl.DISABLED) {
            return true;
        }
        if (control.getControlType() == IRedstoneControl.RedstoneControl.HIGH) {
            return world.func_72864_z(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n);
        }
        if (control.getControlType() == IRedstoneControl.RedstoneControl.LOW) {
            return !world.func_72864_z(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n);
        }
        return false;
    }

    public static MovingObjectPosition rayTrace(World world, EntityPlayer player) {
        double reach = Mekanism.proxy.getReach(player);
        Vec3 headVec = MekanismUtils.getHeadVec(player);
        Vec3 lookVec = player.func_70676_i(1.0f);
        Vec3 endVec = headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
        return world.func_72831_a(headVec, endVec, true, false);
    }

    private static Vec3 getHeadVec(EntityPlayer player) {
        Vec3 vec = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        if (!player.field_70170_p.field_72995_K) {
            vec.field_72448_b += (double)player.func_70047_e();
            if (player instanceof EntityPlayerMP && player.func_70093_af()) {
                vec.field_72448_b -= 0.08;
            }
        }
        return vec;
    }

    public static String getEnergyDisplay(double energy) {
        return ElectricityDisplay.getDisplayShort((float)(energy * Mekanism.TO_UE), ElectricityDisplay.ElectricUnit.JOULES);
    }

    public static boolean useBuildcraft() {
        return Mekanism.hooks.BuildCraftLoaded || Mekanism.forceBuildcraft;
    }

    public static String getCoordDisplay(Object3D obj) {
        return "[" + obj.xCoord + ", " + obj.yCoord + ", " + obj.zCoord + "]";
    }

    public static List<String> getSplitText(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] split = s.split("!n");
        ret.addAll(Arrays.asList(split));
        return ret;
    }

    public static enum ResourceType {
        GUI("gui"),
        SOUND("sound"),
        RENDER("render"),
        TEXTURE_BLOCKS("textures/blocks"),
        TEXTURE_ITEMS("textures/items"),
        MODEL("models"),
        INFUSE("infuse");

        private String prefix;

        private ResourceType(String s) {
            this.prefix = s;
        }

        public String getPrefix() {
            return this.prefix + "/";
        }
    }
}

