/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class StackUtils {
    public static List<ItemStack> split(ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (stack.field_77994_a == 1) {
            ret.add(stack);
            return ret;
        }
        int remain = stack.field_77994_a % 2;
        int split = (int)((float)stack.field_77994_a / 2.0f);
        ret.add(StackUtils.size(stack, split + remain));
        ret.add(StackUtils.size(stack, split));
        return ret;
    }

    public static Item getItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.func_77973_b();
    }

    public static boolean diffIgnoreNull(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.field_77993_c != stack2.field_77993_c || stack1.func_77960_j() != stack2.func_77960_j();
    }

    public static boolean equalsWildcard(ItemStack wild, ItemStack check) {
        return wild.field_77993_c == check.field_77993_c && (wild.func_77960_j() == Short.MAX_VALUE || wild.func_77960_j() == check.func_77960_j());
    }

    public static List<ItemStack> even(ItemStack stack1, ItemStack stack2) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (StackUtils.getSize(stack1) == StackUtils.getSize(stack2) || Math.abs(StackUtils.getSize(stack1) - StackUtils.getSize(stack2)) == 1) {
            ret.add(stack1);
            ret.add(stack2);
            return ret;
        }
        if (StackUtils.getSize(stack1) > StackUtils.getSize(stack2)) {
            int diff = StackUtils.getSize(stack1) - StackUtils.getSize(stack2);
            List<ItemStack> split = StackUtils.split(StackUtils.size(stack1, diff));
            ret.add(StackUtils.subtract(stack1, split.get(0)));
            ret.add(StackUtils.add(stack2, split.get(0)));
        } else if (StackUtils.getSize(stack2) > StackUtils.getSize(stack1)) {
            int diff = StackUtils.getSize(stack2) - StackUtils.getSize(stack1);
            List<ItemStack> split = StackUtils.split(StackUtils.size(stack2, diff));
            ret.add(StackUtils.subtract(stack2, split.get(0)));
            ret.add(StackUtils.add(stack1, split.get(0)));
        }
        return ret;
    }

    public static ItemStack add(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null) {
            return stack2;
        }
        if (stack2 == null) {
            return stack1;
        }
        return StackUtils.size(stack1, StackUtils.getSize(stack1) + StackUtils.getSize(stack2));
    }

    public static ItemStack subtract(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null) {
            return null;
        }
        if (stack2 == null) {
            return stack1;
        }
        return StackUtils.size(stack1, StackUtils.getSize(stack1) - StackUtils.getSize(stack2));
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack == null) {
            return null;
        }
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = size;
        return ret;
    }

    public static int getSize(ItemStack stack) {
        return stack != null ? stack.field_77994_a : 0;
    }
}

