/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import java.util.Arrays;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.Object3D;
import mekanism.api.transmitters.ITransmitter;
import mekanism.common.tileentity.TileEntityDiversionTransporter;
import mekanism.common.tileentity.TileEntityLogisticalSorter;
import mekanism.common.tileentity.TileEntityLogisticalTransporter;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public final class TransporterUtils {
    public static List<EnumColor> colors = ListUtils.asList(EnumColor.DARK_BLUE, EnumColor.DARK_GREEN, EnumColor.DARK_AQUA, EnumColor.DARK_RED, EnumColor.PURPLE, EnumColor.INDIGO, EnumColor.BRIGHT_GREEN, EnumColor.AQUA, EnumColor.RED, EnumColor.PINK, EnumColor.YELLOW, EnumColor.BLACK);

    public static TileEntity[] getConnectedTransporters(TileEntityLogisticalTransporter tileEntity) {
        TileEntity[] transporters = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(tile instanceof TileEntityLogisticalTransporter)) continue;
            TileEntityLogisticalTransporter transporter = (TileEntityLogisticalTransporter)tile;
            if (transporter.color != null && tileEntity.color != null && transporter.color != tileEntity.color) continue;
            transporters[orientation.ordinal()] = transporter;
        }
        return transporters;
    }

    public static boolean[] getConnections(TileEntityLogisticalTransporter tileEntity) {
        boolean redstone;
        int mode;
        int side;
        IInventory[] connectedInventories;
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        TileEntity[] connectedTransporters = TransporterUtils.getConnectedTransporters(tileEntity);
        for (IInventory iInventory : connectedInventories = TransporterUtils.getConnectedInventories(tileEntity)) {
            if (iInventory == null) continue;
            side = Arrays.asList(connectedInventories).indexOf(iInventory);
            if (tileEntity instanceof TileEntityDiversionTransporter) {
                mode = ((TileEntityDiversionTransporter)tileEntity).modes[side];
                redstone = tileEntity.field_70331_k.func_72864_z(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n);
                if (mode == 2 && redstone || mode == 1 && !redstone) continue;
            }
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side).getOpposite();
            if (MekanismUtils.useBuildcraft() && iInventory instanceof IPowerReceptor && ((IPowerReceptor)iInventory).getPowerReceiver(forgeSide) != null && ((IPowerReceptor)iInventory).getPowerReceiver(forgeSide).getType() == PowerHandler.Type.MACHINE) {
                connectable[side] = true;
                continue;
            }
            if (iInventory.func_70302_i_() <= 0) continue;
            if (iInventory instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)iInventory;
                if (sidedInventory.func_94128_d(forgeSide.ordinal()) == null || sidedInventory.func_94128_d(forgeSide.ordinal()).length <= 0) continue;
                connectable[side] = true;
                continue;
            }
            connectable[side] = true;
        }
        for (IInventory iInventory : connectedTransporters) {
            if (iInventory == null) continue;
            side = Arrays.asList(connectedTransporters).indexOf(iInventory);
            if (tileEntity instanceof TileEntityDiversionTransporter) {
                mode = ((TileEntityDiversionTransporter)tileEntity).modes[side];
                redstone = tileEntity.field_70331_k.func_72864_z(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n);
                if (mode == 2 && redstone || mode == 1 && !redstone) continue;
            }
            if (iInventory instanceof TileEntityDiversionTransporter) {
                mode = ((TileEntityDiversionTransporter)iInventory).modes[ForgeDirection.VALID_DIRECTIONS[side].getOpposite().ordinal()];
                redstone = iInventory.field_70331_k.func_72864_z(iInventory.field_70329_l, iInventory.field_70330_m, iInventory.field_70327_n);
                if (mode == 2 && redstone || mode == 1 && !redstone) continue;
            }
            connectable[side] = true;
        }
        return connectable;
    }

    public static IInventory[] getConnectedInventories(TileEntityLogisticalTransporter tileEntity) {
        IInventory[] inventories = new IInventory[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity inventory = Object3D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!(inventory instanceof IInventory) || inventory instanceof ITransmitter) continue;
            inventories[orientation.ordinal()] = (IInventory)inventory;
        }
        return inventories;
    }

    public static ItemStack insert(TileEntity outputter, TileEntityLogisticalTransporter tileEntity, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        return tileEntity.insert(Object3D.get(outputter), itemStack.func_77946_l(), color, doEmit, min);
    }

    public static ItemStack insertRR(TileEntityLogisticalSorter outputter, TileEntityLogisticalTransporter tileEntity, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        return tileEntity.insertRR(outputter, itemStack.func_77946_l(), color, doEmit, min);
    }

    public static EnumColor increment(EnumColor color) {
        if (color == null) {
            return colors.get(0);
        }
        if (colors.indexOf((Object)color) == colors.size() - 1) {
            return null;
        }
        return colors.get(colors.indexOf((Object)color) + 1);
    }

    public static EnumColor decrement(EnumColor color) {
        if (color == null) {
            return colors.get(colors.size() - 1);
        }
        if (colors.indexOf((Object)color) == 0) {
            return null;
        }
        return colors.get(colors.indexOf((Object)color) - 1);
    }

    public static boolean checkDiversionLogic(TileEntity currTile, TileEntity tile, int side) {
        boolean redstone;
        int mode;
        if (currTile instanceof TileEntityDiversionTransporter) {
            mode = ((TileEntityDiversionTransporter)currTile).modes[side];
            redstone = currTile.field_70331_k.func_72864_z(currTile.field_70329_l, currTile.field_70330_m, currTile.field_70327_n);
            if (mode == 2 && redstone || mode == 1 && !redstone) {
                return false;
            }
        }
        if (tile instanceof TileEntityDiversionTransporter) {
            mode = ((TileEntityDiversionTransporter)tile).modes[ForgeDirection.getOrientation((int)side).getOpposite().ordinal()];
            redstone = tile.field_70331_k.func_72864_z(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
            if (mode == 2 && redstone || mode == 1 && !redstone) {
                return false;
            }
        }
        return true;
    }

    public static void drop(TileEntityLogisticalTransporter tileEntity, TransporterStack stack) {
        float[] pos = null;
        pos = stack.pathToTarget != null ? TransporterUtils.getStackPosition(tileEntity, stack, 0.0f) : new float[]{0.0f, 0.0f, 0.0f};
        TransporterManager.remove(stack);
        EntityItem entityItem = new EntityItem(tileEntity.field_70331_k, (double)((float)tileEntity.field_70329_l + pos[0]), (double)((float)tileEntity.field_70330_m + pos[1]), (double)((float)tileEntity.field_70327_n + pos[2]), stack.itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
        tileEntity.field_70331_k.func_72838_d((Entity)entityItem);
    }

    public static float[] getStackPosition(TileEntityLogisticalTransporter tileEntity, TransporterStack stack, float partial) {
        Object3D offset = new Object3D(0, 0, 0).step(ForgeDirection.getOrientation((int)stack.getSide(tileEntity)));
        float progress = ((float)stack.progress + partial) / 100.0f - 0.5f;
        float itemFix = 0.0f;
        if (!(stack.itemStack.func_77973_b() instanceof ItemBlock)) {
            itemFix = 0.1f;
        }
        return new float[]{0.5f + (float)offset.xCoord * progress, 0.5f + (float)offset.yCoord * progress - itemFix, 0.5f + (float)offset.zCoord * progress};
    }

    public static void incrementColor(TileEntityLogisticalTransporter tileEntity) {
        if (tileEntity.color == null) {
            tileEntity.color = colors.get(0);
            return;
        }
        if (colors.indexOf((Object)tileEntity.color) == colors.size() - 1) {
            tileEntity.color = null;
            return;
        }
        int index = colors.indexOf((Object)tileEntity.color);
        tileEntity.color = colors.get(index + 1);
    }
}

