/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.voice;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemWalkieTalkie;
import mekanism.common.voice.VoiceServerManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class VoiceConnection {
    public Socket socket;
    public String username;
    public boolean open = true;
    public DataInputStream input;
    public DataOutputStream output;
    public MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();

    public VoiceConnection(Socket s) {
        this.socket = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            VoiceServerManager voiceServerManager = Mekanism.voiceManager;
            synchronized (voiceServerManager) {
                int retryCount = 0;
                while (this.username == null && retryCount <= 100) {
                    try {
                        List l = Collections.synchronizedList((List)((ArrayList)this.server.func_71203_ab().field_72404_b).clone());
                        for (Object obj : l) {
                            if (!(obj instanceof EntityPlayerMP)) continue;
                            EntityPlayerMP playerMP = (EntityPlayerMP)obj;
                            String playerIP = playerMP.func_71114_r();
                            if (!this.server.func_71262_S() && playerIP.equals("127.0.0.1") && !Mekanism.voiceManager.foundLocal) {
                                Mekanism.voiceManager.foundLocal = true;
                                this.username = playerMP.field_71092_bJ;
                                break;
                            }
                            if (!playerIP.equals(this.socket.getInetAddress().getHostAddress())) continue;
                            this.username = playerMP.field_71092_bJ;
                            break;
                        }
                        ++retryCount;
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
                if (this.username == null) {
                    System.out.println("[Mekanism] VoiceServer: Unable to trace connection's IP address.");
                    this.kill();
                    return;
                }
                System.out.println("[Mekanism] VoiceServer: Traced IP in " + retryCount + " attempts.");
            }
        }
        catch (Exception e) {
            System.err.println("[Mekanism] VoiceServer: Error while starting server-based connection.");
            e.printStackTrace();
            this.open = false;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (VoiceConnection.this.open) {
                    try {
                        short byteCount = VoiceConnection.this.input.readShort();
                        byte[] audioData = new byte[byteCount];
                        VoiceConnection.this.input.readFully(audioData);
                        if (byteCount <= 0) continue;
                        Mekanism.voiceManager.sendToPlayers(byteCount, audioData, VoiceConnection.this);
                    }
                    catch (Exception e) {
                        VoiceConnection.this.open = false;
                    }
                }
                if (!VoiceConnection.this.open) {
                    VoiceConnection.this.kill();
                }
            }
        }).start();
    }

    public void kill() {
        try {
            this.input.close();
            this.output.close();
            this.socket.close();
            Mekanism.voiceManager.connections.remove(this);
        }
        catch (Exception e) {
            System.err.println("[Mekanism] VoiceServer: Error while stopping server-based connection.");
            e.printStackTrace();
        }
    }

    public void sendToPlayer(short byteCount, byte[] audioData, VoiceConnection connection) {
        if (!this.open) {
            this.kill();
        }
        try {
            this.output.writeShort(byteCount);
            this.output.write(audioData);
            this.output.flush();
        }
        catch (Exception e) {
            System.err.println("[Mekanism] VoiceServer: Error while sending data to player.");
            e.printStackTrace();
        }
    }

    public boolean canListen(int channel) {
        for (ItemStack itemStack : this.getPlayer().field_71071_by.field_70462_a) {
            if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemWalkieTalkie) || !((ItemWalkieTalkie)itemStack.func_77973_b()).getOn(itemStack) || ((ItemWalkieTalkie)itemStack.func_77973_b()).getChannel(itemStack) != channel) continue;
            return true;
        }
        return false;
    }

    public int getCurrentChannel() {
        ItemWalkieTalkie walkieTalkie;
        ItemStack itemStack = this.getPlayer().func_71045_bC();
        if (itemStack != null && (walkieTalkie = (ItemWalkieTalkie)itemStack.func_77973_b()) != null && walkieTalkie.getOn(itemStack)) {
            return walkieTalkie.getChannel(itemStack);
        }
        return 0;
    }

    public EntityPlayerMP getPlayer() {
        return this.server.func_71203_ab().func_72361_f(this.username);
    }
}

