/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import cpw.mods.fml.common.Loader;
import universalelectricity.compatibility.UniversalNetwork;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.NetworkLoader;

public class Compatibility {
    public static String BCx_VERSION = "@BCxVersion@";
    public static String ICx_VERSION = "@ICxVersion@";
    public static String TEx_VERSION = "@TExVersion@";
    public static boolean INIT = false;
    public static float BC3_RATIO = 2.814f;
    public static float TE_RATIO = BC3_RATIO / 10.0f;
    public static float IC2_RATIO = 0.11256f;
    public static float TO_BC_RATIO = 1.0f / BC3_RATIO;
    public static float TO_TE_RATIO = 1.0f / TE_RATIO;
    public static float TO_IC2_RATIO = 1.0f / IC2_RATIO;

    public static void initiate() {
        if (!INIT) {
            System.out.println("[UniversalElectricity] Loading compatibility API version 5.6.0");
            System.out.println("[UniversalElectricity] Compiled with IndustrialCraft API version " + ICx_VERSION);
            System.out.println("[UniversalElectricity] Compiled with BuildCraft API version " + BCx_VERSION);
            System.out.println("[UniversalElectricity] Compiled with ThermalExpansion  API version " + TEx_VERSION);
            UniversalElectricity.CONFIGURATION.load();
            IC2_RATIO = (float)UniversalElectricity.CONFIGURATION.get("Compatiblity", "IndustrialCraft Conversion Ratio", (double)IC2_RATIO).getDouble((double)IC2_RATIO);
            TE_RATIO = (float)UniversalElectricity.CONFIGURATION.get("Compatiblity", "Thermal Expansion Conversion Ratio", (double)TE_RATIO).getDouble((double)TE_RATIO);
            BC3_RATIO = (float)UniversalElectricity.CONFIGURATION.get("Compatiblity", "BuildCraft Conversion Ratio", (double)BC3_RATIO).getDouble((double)BC3_RATIO);
            TO_IC2_RATIO = 1.0f / IC2_RATIO;
            TO_BC_RATIO = 1.0f / BC3_RATIO;
            UniversalElectricity.CONFIGURATION.save();
            NetworkLoader.setNetworkClass(UniversalNetwork.class);
        }
    }

    public static boolean isIndustrialCraft2Loaded() {
        return Loader.isModLoaded((String)"IC2");
    }

    public static boolean isBuildcraftLoaded() {
        return Loader.isModLoaded((String)"BuildCraft|Energy");
    }

    public static boolean isThermalExpansionLoaded() {
        return Loader.isModLoaded((String)"ThermalExpansion");
    }
}

