/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.tile.TileEntityConductor;

public abstract class TileEntityUniversalConductor
extends TileEntityConductor
implements IEnergySink,
IPowerReceptor,
IEnergyHandler {
    protected boolean isAddedToEnergyNet;
    public PowerHandler powerHandler;
    public float buildcraftBuffer = Compatibility.BC3_RATIO * 50.0f;

    public TileEntityUniversalConductor() {
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.PIPE);
        this.powerHandler.configure(0.0f, this.buildcraftBuffer, this.buildcraftBuffer, this.buildcraftBuffer * 2.0f);
        this.powerHandler.configurePowerPerdition(0, 0);
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = new TileEntity[6];
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                ForgeDirection side = ForgeDirection.getOrientation((int)i);
                TileEntity tileEntity = VectorHelper.getTileEntityFromSide(this.field_70331_k, new Vector3(this), side);
                if (tileEntity instanceof IConnector) {
                    if (!((IConnector)tileEntity).canConnect(side.getOpposite())) continue;
                    this.adjacentConnections[i] = tileEntity;
                    continue;
                }
                if (tileEntity instanceof IEnergyTile) {
                    if (tileEntity instanceof IEnergyAcceptor && ((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(this, side.getOpposite())) {
                        this.adjacentConnections[i] = tileEntity;
                        continue;
                    }
                    if (tileEntity instanceof IEnergyEmitter && ((IEnergyEmitter)tileEntity).emitsEnergyTo(tileEntity, side.getOpposite())) {
                        this.adjacentConnections[i] = tileEntity;
                        continue;
                    }
                    this.adjacentConnections[i] = tileEntity;
                    continue;
                }
                if (tileEntity instanceof IPowerReceptor) {
                    if (((IPowerReceptor)tileEntity).getPowerReceiver(side.getOpposite()) == null) continue;
                    this.adjacentConnections[i] = tileEntity;
                    continue;
                }
                if (!(tileEntity instanceof IEnergyHandler) || !((IEnergyHandler)tileEntity).canInterface(side.getOpposite())) continue;
                this.adjacentConnections[i] = tileEntity;
            }
        }
        return this.adjacentConnections;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (!this.field_70331_k.field_72995_K && !this.isAddedToEnergyNet) {
            this.initIC();
        }
    }

    @Override
    public void func_70313_j() {
        this.unloadTileIC2();
        super.func_70313_j();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.isAddedToEnergyNet = true;
    }

    protected void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_70331_k != null) {
            if (Compatibility.isIndustrialCraft2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @Override
    public double demandedEnergyUnits() {
        if (this.getNetwork() == null) {
            return 0.0;
        }
        return this.getNetwork().getRequest(this).getWatts() * Compatibility.TO_IC2_RATIO;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        TileEntity tile = VectorHelper.getTileEntityFromSide(this.field_70331_k, new Vector3(this), directionFrom);
        ElectricityPack pack = ElectricityPack.getFromWatts((float)(amount * (double)Compatibility.IC2_RATIO), 1.0f);
        return this.getNetwork().produce(pack, this, tile) * Compatibility.TO_IC2_RATIO;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        HashSet<TileEntity> ignoreTiles = new HashSet<TileEntity>();
        ignoreTiles.add(this);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = new Vector3(this).modifyPositionFromSide(direction).getTileEntity((IBlockAccess)this.field_70331_k);
            ignoreTiles.add(tile);
        }
        ElectricityPack pack = ElectricityPack.getFromWatts(workProvider.useEnergy(0.0f, this.getNetwork().getRequest(this).getWatts() * Compatibility.TO_BC_RATIO, true) * Compatibility.BC3_RATIO, 1.0f);
        this.getNetwork().produce(pack, ignoreTiles.toArray(new TileEntity[0]));
    }

    @Override
    public World getWorld() {
        return this.func_70314_l();
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        ElectricityPack pack = ElectricityPack.getFromWatts((float)maxReceive * Compatibility.TE_RATIO, 1.0f);
        float request = this.getMaxEnergyStored(from);
        if (!simulate) {
            if (request > 0.0f) {
                float reject = this.getNetwork().produce(pack, new Vector3(this).modifyPositionFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k));
                return (int)((float)maxReceive - reject * Compatibility.TO_TE_RATIO);
            }
            return 0;
        }
        return (int)Math.min((float)maxReceive, request * Compatibility.TO_TE_RATIO);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)(this.getNetwork().getRequest(new Vector3(this).modifyPositionFromSide(from).getTileEntity((IBlockAccess)this.field_70331_k)).getWatts() * Compatibility.TO_TE_RATIO);
    }
}

