/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.tile.TileEntityElectrical;

public abstract class TileEntityUniversalElectrical
extends TileEntityElectrical
implements IEnergySink,
IEnergySource,
IPowerReceptor,
IEnergyHandler {
    protected boolean isAddedToEnergyNet;
    public PowerHandler bcPowerHandler;
    public PowerHandler.Type bcBlockType = PowerHandler.Type.MACHINE;
    public float maxInputEnergy = 100.0f;

    @Override
    public void recharge(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof IItemElectric) {
                super.recharge(itemStack);
            } else if (itemStack.func_77973_b() instanceof ISpecialElectricItem) {
                ISpecialElectricItem electricItem = (ISpecialElectricItem)itemStack.func_77973_b();
                IElectricItemManager manager = electricItem.getManager(itemStack);
                float energy = Math.max(this.getProvide(ForgeDirection.UNKNOWN) * Compatibility.IC2_RATIO, 0.0f);
                energy = (float)manager.charge(itemStack, (int)(energy * Compatibility.TO_IC2_RATIO), 0, false, false) * Compatibility.IC2_RATIO;
                this.provideElectricity(energy, true);
            } else if (itemStack.func_77973_b() instanceof IEnergyContainerItem) {
                float forgienEnergyAccepted = ((IEnergyContainerItem)itemStack.func_77973_b()).receiveEnergy(itemStack, (int)(this.getProvide(ForgeDirection.UNKNOWN) * Compatibility.TO_TE_RATIO), false);
                this.provideElectricity(forgienEnergyAccepted * Compatibility.TE_RATIO, true);
            }
        }
    }

    @Override
    public void discharge(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof IItemElectric) {
                super.discharge(itemStack);
            } else if (itemStack.func_77973_b() instanceof ISpecialElectricItem) {
                ISpecialElectricItem electricItem = (ISpecialElectricItem)itemStack.func_77973_b();
                if (electricItem.canProvideEnergy(itemStack)) {
                    IElectricItemManager manager = electricItem.getManager(itemStack);
                    float energy = Math.max(this.getRequest(ForgeDirection.UNKNOWN) * Compatibility.IC2_RATIO, 0.0f);
                    energy = manager.discharge(itemStack, (int)(energy * Compatibility.TO_IC2_RATIO), 0, false, false);
                    this.receiveElectricity(energy, true);
                }
            } else if (itemStack.func_77973_b() instanceof IEnergyContainerItem) {
                float forgienEnergy = ((IEnergyContainerItem)itemStack.func_77973_b()).extractEnergy(itemStack, (int)(this.getRequest(ForgeDirection.UNKNOWN) * Compatibility.TO_TE_RATIO), false);
                this.receiveElectricity(forgienEnergy * Compatibility.TE_RATIO, true);
            }
        }
    }

    @Override
    public void initiate() {
        super.initiate();
        this.initBuildCraft();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (!this.isAddedToEnergyNet) {
                this.initIC();
            }
            if (this.bcPowerHandler == null) {
                this.initBuildCraft();
            }
            if (Compatibility.isBuildcraftLoaded() && this.bcPowerHandler.getEnergyStored() > 0.0f) {
                this.receiveElectricity(this.bcPowerHandler.getEnergyStored() * Compatibility.BC3_RATIO, true);
                this.bcPowerHandler.setEnergy(0.0f);
            }
        }
    }

    @Override
    public void produce() {
        if (!this.field_70331_k.field_72995_K) {
            for (ForgeDirection outputDirection : this.getOutputDirections()) {
                if (outputDirection == ForgeDirection.UNKNOWN || this.produceUE(outputDirection) || this.produceThermalExpansion(outputDirection)) continue;
                this.produceBuildCraft(outputDirection);
            }
        }
    }

    public boolean produceThermalExpansion(ForgeDirection outputDirection) {
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN) {
            TileEntity tileEntity;
            float provide = this.getProvide(outputDirection);
            if (this.getEnergyStored() >= provide && provide > 0.0f && Compatibility.isThermalExpansionLoaded() && (tileEntity = new Vector3(this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_70331_k)) instanceof IEnergyHandler) {
                IEnergyHandler receiver = (IEnergyHandler)tileEntity;
                int convertedProvide = (int)(provide * Compatibility.TO_TE_RATIO);
                if (receiver.canInterface(outputDirection.getOpposite()) && receiver.receiveEnergy(outputDirection.getOpposite(), convertedProvide, true) > 0) {
                    int forgienEnergyUsed = receiver.receiveEnergy(outputDirection.getOpposite(), convertedProvide, false);
                    this.provideElectricity((float)forgienEnergyUsed * Compatibility.TE_RATIO, true);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean produceBuildCraft(ForgeDirection outputDirection) {
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN) {
            PowerHandler.PowerReceiver receiver;
            TileEntity tileEntity;
            float provide = this.getProvide(outputDirection);
            if (this.getEnergyStored() >= provide && provide > 0.0f && Compatibility.isBuildcraftLoaded() && (tileEntity = new Vector3(this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_70331_k)) instanceof IPowerReceptor && (receiver = ((IPowerReceptor)tileEntity).getPowerReceiver(outputDirection.getOpposite())) != null && receiver.powerRequest() > 0.0f) {
                float convertedProvide = provide * Compatibility.TO_BC_RATIO;
                float forgienEnergyUsed = receiver.receiveEnergy(this.bcBlockType, convertedProvide, outputDirection.getOpposite());
                this.provideElectricity(forgienEnergyUsed * Compatibility.BC3_RATIO, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return (int)(this.receiveElectricity(from, ElectricityPack.getFromWatts((float)maxReceive * Compatibility.TE_RATIO, this.getVoltage()), !simulate) * Compatibility.TO_TE_RATIO);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return (int)(this.provideElectricity(from, ElectricityPack.getFromWatts((float)maxExtract * Compatibility.TE_RATIO, this.getVoltage()), !simulate).getWatts() * Compatibility.TO_TE_RATIO);
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return this.canConnect(from);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return (int)(this.getEnergyStored() * Compatibility.TO_TE_RATIO);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)(this.getMaxEnergyStored() * Compatibility.TO_TE_RATIO);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.getInputDirections().contains(direction);
    }

    @Override
    public double getOfferedEnergy() {
        return this.getProvide(ForgeDirection.UNKNOWN) * Compatibility.TO_IC2_RATIO;
    }

    @Override
    public void drawEnergy(double amount) {
        this.provideElectricity((float)amount * Compatibility.IC2_RATIO, true);
    }

    public void func_70313_j() {
        this.unloadTileIC2();
        super.func_70313_j();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (Compatibility.isIndustrialCraft2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
        this.isAddedToEnergyNet = true;
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_70331_k != null) {
            if (Compatibility.isIndustrialCraft2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @Override
    public double demandedEnergyUnits() {
        return this.getRequest(ForgeDirection.UNKNOWN) * Compatibility.TO_IC2_RATIO;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection direction, double amount) {
        if (this.getInputDirections().contains(direction)) {
            float convertedEnergy = (float)(amount * (double)Compatibility.IC2_RATIO);
            ElectricityPack toSend = ElectricityPack.getFromWatts(convertedEnergy, this.getVoltage());
            float receive = this.receiveElectricity(direction, toSend, true);
            return Math.round(amount - (double)(receive * Compatibility.TO_IC2_RATIO));
        }
        return amount;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return receiver instanceof IEnergyTile && this.getOutputDirections().contains(direction);
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    public void initBuildCraft() {
        if (this.bcPowerHandler == null) {
            this.bcPowerHandler = new PowerHandler(this, this.bcBlockType);
        }
        this.bcPowerHandler.configure(0.0f, this.maxInputEnergy, 0.0f, (int)Math.ceil(this.getMaxEnergyStored() * Compatibility.BC3_RATIO));
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        this.initBuildCraft();
        return this.bcPowerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public World getWorld() {
        return this.func_70314_l();
    }
}

