/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.FMLLog;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.block.INetworkConnection;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricalEvent;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.ElectricityNetwork;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.path.PathfinderChecker;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public class UniversalNetwork
extends ElectricityNetwork {
    @Override
    public float produce(ElectricityPack electricity, TileEntity ... ignoreTiles) {
        float totalEnergyRequest;
        Set<TileEntity> avaliableEnergyTiles;
        float totalUsableEnergy;
        ElectricalEvent.ElectricityProductionEvent evt = new ElectricalEvent.ElectricityProductionEvent(this, electricity, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        float totalEnergy = electricity.getWatts();
        float networkResistance = this.getTotalResistance();
        float proportionWasted = this.getTotalResistance() / (this.getTotalResistance() + this.acceptorResistance);
        float energyWasted = totalEnergy * proportionWasted;
        float remainingUsableEnergy = totalUsableEnergy = totalEnergy - energyWasted;
        float voltage = electricity.voltage;
        if (!evt.isCanceled() && !(avaliableEnergyTiles = this.getAcceptors()).isEmpty() && (totalEnergyRequest = this.getRequest(ignoreTiles).getWatts()) > 0.0f) {
            boolean markRefresh = false;
            for (TileEntity tileEntity : avaliableEnergyTiles) {
                if (tileEntity != null && !tileEntity.func_70320_p()) {
                    Object electricalTile;
                    if (!(remainingUsableEnergy > 0.0f) || Arrays.asList(ignoreTiles).contains(tileEntity)) continue;
                    if (tileEntity instanceof IElectrical) {
                        electricalTile = (IElectrical)tileEntity;
                        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                            float energyToSend;
                            if (!electricalTile.canConnect(direction) || !this.getConductors().contains(VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction)) || !((energyToSend = totalUsableEnergy * (Math.min(electricalTile.getRequest(direction), totalEnergyRequest) / totalEnergyRequest)) > 0.0f)) continue;
                            ElectricityPack electricityToSend = ElectricityPack.getFromWatts(energyToSend, voltage);
                            remainingUsableEnergy -= electricalTile.receiveElectricity(direction, electricityToSend, true);
                        }
                        continue;
                    }
                    if (tileEntity instanceof IEnergySink) {
                        electricalTile = (IEnergySink)tileEntity;
                        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                            float energyToSend;
                            TileEntity conductor = VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction);
                            if (!this.getConductors().contains(conductor) || !electricalTile.acceptsEnergyFrom(conductor, direction) || !((energyToSend = (float)Math.min((double)totalUsableEnergy * (electricalTile.demandedEnergyUnits() * (double)Compatibility.IC2_RATIO / (double)totalEnergyRequest), (double)((float)electricalTile.getMaxSafeInput() * Compatibility.IC2_RATIO))) > 0.0f)) continue;
                            remainingUsableEnergy = (float)((double)remainingUsableEnergy - electricalTile.injectEnergyUnits(direction, energyToSend * Compatibility.TO_IC2_RATIO) * (double)Compatibility.IC2_RATIO);
                        }
                        continue;
                    }
                    if (tileEntity instanceof IPowerReceptor) {
                        electricalTile = (IPowerReceptor)tileEntity;
                        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                            float energyToSend;
                            TileEntity conductor = VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction);
                            PowerHandler.PowerReceiver receiver = electricalTile.getPowerReceiver(direction);
                            if (receiver == null || !this.getConductors().contains(conductor) || !((energyToSend = totalUsableEnergy * (receiver.powerRequest() * Compatibility.BC3_RATIO / totalEnergyRequest)) > 0.0f)) continue;
                            remainingUsableEnergy -= receiver.receiveEnergy(PowerHandler.Type.PIPE, energyToSend * Compatibility.TO_BC_RATIO, direction) * Compatibility.BC3_RATIO;
                        }
                        continue;
                    }
                    if (!(tileEntity instanceof IEnergyHandler)) continue;
                    IEnergyHandler receiver = (IEnergyHandler)tileEntity;
                    for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                        float energyToSend;
                        TileEntity conductor = VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction);
                        if (!receiver.canInterface(direction) || !this.getConductors().contains(conductor) || !((energyToSend = totalUsableEnergy * ((float)receiver.receiveEnergy(direction, (int)(remainingUsableEnergy * Compatibility.TO_TE_RATIO), true) * Compatibility.TE_RATIO / totalEnergyRequest)) > 0.0f)) continue;
                        remainingUsableEnergy -= (float)receiver.receiveEnergy(direction, (int)(energyToSend * Compatibility.TO_TE_RATIO), false) * Compatibility.TE_RATIO;
                    }
                    continue;
                }
                markRefresh = true;
            }
            if (markRefresh) {
                this.refresh();
            }
        }
        return remainingUsableEnergy;
    }

    @Override
    public ElectricityPack getRequest(TileEntity ... ignoreTiles) {
        ArrayList<ElectricityPack> requests = new ArrayList<ElectricityPack>();
        block0: for (TileEntity tileEntity : new HashSet<TileEntity>(this.getAcceptors())) {
            ElectricityPack pack;
            if (Arrays.asList(ignoreTiles).contains(tileEntity) || tileEntity == null || tileEntity.func_70320_p() || tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) != tileEntity) continue;
            if (tileEntity instanceof IElectrical) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (!((IElectrical)tileEntity).canConnect(direction) || !this.getConductors().contains(VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction))) continue;
                    requests.add(ElectricityPack.getFromWatts(((IElectrical)tileEntity).getRequest(direction), ((IElectrical)tileEntity).getVoltage()));
                }
                continue;
            }
            if (tileEntity instanceof IEnergyHandler) {
                IEnergyHandler receiver = (IEnergyHandler)tileEntity;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    ElectricityPack pack2;
                    TileEntity conductor = VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction);
                    if (!receiver.canInterface(direction) || !this.getConductors().contains(conductor) || !((pack2 = ElectricityPack.getFromWatts((float)receiver.receiveEnergy(direction, Integer.MAX_VALUE, true) * Compatibility.TE_RATIO, 1.0f)).getWatts() > 0.0f)) continue;
                    requests.add(pack2);
                    continue block0;
                }
                continue;
            }
            if (tileEntity instanceof IEnergySink) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (!((IEnergySink)tileEntity).acceptsEnergyFrom(VectorHelper.getTileEntityFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction), direction) || !this.getConductors().contains(VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction)) || !((pack = ElectricityPack.getFromWatts((float)(((IEnergySink)tileEntity).demandedEnergyUnits() * (double)Compatibility.IC2_RATIO), 1.0f)).getWatts() > 0.0f)) continue;
                    requests.add(pack);
                }
                continue;
            }
            if (!(tileEntity instanceof IPowerReceptor)) continue;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (((IPowerReceptor)tileEntity).getPowerReceiver(direction) == null || !((pack = ElectricityPack.getFromWatts(((IPowerReceptor)tileEntity).getPowerReceiver(direction).powerRequest() * Compatibility.BC3_RATIO, 1.0f)).getWatts() > 0.0f)) continue;
                requests.add(pack);
                continue block0;
            }
        }
        ElectricityPack mergedPack = ElectricityPack.merge(requests);
        ElectricalEvent.ElectricityRequestEvent evt = new ElectricalEvent.ElectricityRequestEvent(this, mergedPack, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return mergedPack;
    }

    @Override
    public void refresh() {
        this.electricalTiles.clear();
        try {
            Iterator<IConductor> it = this.getConductors().iterator();
            while (it.hasNext()) {
                IConductor conductor = it.next();
                if (conductor == null) {
                    it.remove();
                    continue;
                }
                if (((TileEntity)conductor).func_70320_p() || ((TileEntity)conductor).func_70314_l() == null) {
                    it.remove();
                    continue;
                }
                if (((TileEntity)conductor).func_70314_l().func_72796_p(((TileEntity)conductor).field_70329_l, ((TileEntity)conductor).field_70330_m, ((TileEntity)conductor).field_70327_n) != conductor) {
                    it.remove();
                    continue;
                }
                conductor.setNetwork(this);
                for (int i = 0; i < conductor.getAdjacentConnections().length; ++i) {
                    TileEntity acceptor = conductor.getAdjacentConnections()[i];
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    if (acceptor instanceof IConductor || !(acceptor instanceof IElectrical) && !(acceptor instanceof IEnergyHandler) && !(acceptor instanceof IEnergyAcceptor) && !(acceptor instanceof IPowerReceptor)) continue;
                    ArrayList possibleDirections = null;
                    possibleDirections = this.electricalTiles.containsKey(acceptor) ? (ArrayList)this.electricalTiles.get(acceptor) : new ArrayList();
                    if (acceptor instanceof IElectrical && ((IElectrical)acceptor).canConnect(direction)) {
                        possibleDirections.add(direction);
                    } else if (acceptor instanceof IEnergyHandler && ((IEnergyHandler)acceptor).canInterface(direction)) {
                        possibleDirections.add(direction);
                    } else if (acceptor instanceof IEnergyAcceptor && ((IEnergyAcceptor)acceptor).acceptsEnergyFrom((TileEntity)conductor, direction)) {
                        possibleDirections.add(direction);
                    } else if (acceptor instanceof IPowerReceptor && ((IPowerReceptor)acceptor).getPowerReceiver(direction) != null) {
                        possibleDirections.add(direction);
                    }
                    if (possibleDirections.isEmpty()) continue;
                    this.electricalTiles.put(acceptor, possibleDirections);
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Universal Electricity: Failed to refresh conductor.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public void merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            UniversalNetwork newNetwork = new UniversalNetwork();
            newNetwork.getConductors().addAll(this.getConductors());
            newNetwork.getConductors().addAll(network.getConductors());
            newNetwork.refresh();
        }
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.getConductors().remove(splitPoint);
            TileEntity[] connectedBlocks = splitPoint.getAdjacentConnections();
            for (int i = 0; i < connectedBlocks.length; ++i) {
                TileEntity connectedBlockA = connectedBlocks[i];
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (int ii = 0; ii < connectedBlocks.length; ++ii) {
                    TileEntity connectedBlockB = connectedBlocks[ii];
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).field_70331_k, (INetworkConnection)connectedBlockB, splitPoint);
                    finder.init(new Vector3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (Vector3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    UniversalNetwork newNetwork = new UniversalNetwork();
                    for (Vector3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getConductors().add((IConductor)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    @Override
    public String toString() {
        return "UniversalNetwork[" + this.hashCode() + "|Wires:" + this.getConductors().size() + "|Acceptors:" + this.electricalTiles.size() + "]";
    }
}

