/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.grid;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.block.INetworkConnection;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricalEvent;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.path.PathfinderChecker;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public class ElectricityNetwork
implements IElectricityNetwork {
    public Map<TileEntity, ArrayList<ForgeDirection>> electricalTiles = new HashMap<TileEntity, ArrayList<ForgeDirection>>();
    private final Set<IConductor> conductors = new HashSet<IConductor>();
    public float acceptorResistance = 500.0f;

    @Override
    public float produce(ElectricityPack electricity, TileEntity ... ignoreTiles) {
        float totalEnergyRequest;
        Set<TileEntity> avaliableEnergyTiles;
        float totalUsableEnergy;
        ElectricalEvent.ElectricityProductionEvent evt = new ElectricalEvent.ElectricityProductionEvent(this, electricity, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        float totalEnergy = electricity.getWatts();
        float networkResistance = this.getTotalResistance();
        float proportionWasted = this.getTotalResistance() / (this.getTotalResistance() + this.acceptorResistance);
        float energyWasted = totalEnergy * proportionWasted;
        float remainingUsableEnergy = totalUsableEnergy = totalEnergy - energyWasted;
        float voltage = electricity.voltage;
        if (!evt.isCanceled() && !(avaliableEnergyTiles = this.getAcceptors()).isEmpty() && (totalEnergyRequest = this.getRequest(ignoreTiles).getWatts()) > 0.0f) {
            for (TileEntity tileEntity : avaliableEnergyTiles) {
                if (Arrays.asList(ignoreTiles).contains(tileEntity) || !(tileEntity instanceof IElectrical)) continue;
                IElectrical electricalTile = (IElectrical)tileEntity;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    float energyToSend;
                    if (!electricalTile.canConnect(direction) || !this.getConductors().contains(VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction)) || !((energyToSend = totalUsableEnergy * (electricalTile.getRequest(direction) / totalEnergyRequest)) > 0.0f)) continue;
                    ElectricityPack electricityToSend = ElectricityPack.getFromWatts(energyToSend, voltage);
                    remainingUsableEnergy -= ((IElectrical)tileEntity).receiveElectricity(direction, electricityToSend, true);
                }
            }
        }
        return remainingUsableEnergy;
    }

    @Override
    public ElectricityPack getRequest(TileEntity ... ignoreTiles) {
        ArrayList<ElectricityPack> requests = new ArrayList<ElectricityPack>();
        for (TileEntity tileEntity : this.getAcceptors()) {
            if (Arrays.asList(ignoreTiles).contains(tileEntity) || !(tileEntity instanceof IElectrical) || tileEntity.func_70320_p() || tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) != tileEntity) continue;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (!((IElectrical)tileEntity).canConnect(direction) || !this.getConductors().contains(VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction))) continue;
                requests.add(ElectricityPack.getFromWatts(((IElectrical)tileEntity).getRequest(direction), ((IElectrical)tileEntity).getVoltage()));
            }
        }
        ElectricityPack mergedPack = ElectricityPack.merge(requests);
        ElectricalEvent.ElectricityRequestEvent evt = new ElectricalEvent.ElectricityRequestEvent(this, mergedPack, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return mergedPack;
    }

    @Override
    public Set<TileEntity> getAcceptors() {
        return this.electricalTiles.keySet();
    }

    @Override
    public ArrayList<ForgeDirection> getPossibleDirections(TileEntity tile) {
        return this.electricalTiles.containsKey(tile) ? this.electricalTiles.get(tile) : null;
    }

    @Override
    public void refresh() {
        this.electricalTiles.clear();
        try {
            Iterator<IConductor> it = this.conductors.iterator();
            while (it.hasNext()) {
                IConductor conductor = it.next();
                if (conductor == null) {
                    it.remove();
                } else if (((TileEntity)conductor).func_70320_p()) {
                    it.remove();
                } else {
                    conductor.setNetwork(this);
                }
                for (int i = 0; i < conductor.getAdjacentConnections().length; ++i) {
                    TileEntity acceptor = conductor.getAdjacentConnections()[i];
                    if (acceptor instanceof IConductor || !(acceptor instanceof IConnector)) continue;
                    ArrayList<ForgeDirection> possibleDirections = null;
                    possibleDirections = this.electricalTiles.containsKey(acceptor) ? this.electricalTiles.get(acceptor) : new ArrayList<ForgeDirection>();
                    possibleDirections.add(ForgeDirection.getOrientation((int)i));
                    this.electricalTiles.put(acceptor, possibleDirections);
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Universal Electricity: Failed to refresh conductor.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public float getTotalResistance() {
        float resistance = 0.0f;
        for (IConductor conductor : this.conductors) {
            resistance += conductor.getResistance();
        }
        return resistance;
    }

    @Override
    public float getLowestCurrentCapacity() {
        float lowestAmperage = 0.0f;
        for (IConductor conductor : this.conductors) {
            if (lowestAmperage != 0.0f && !(conductor.getCurrentCapacity() < lowestAmperage)) continue;
            lowestAmperage = conductor.getCurrentCapacity();
        }
        return lowestAmperage;
    }

    @Override
    public Set<IConductor> getConductors() {
        return this.conductors;
    }

    @Override
    public void merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            ElectricityNetwork newNetwork = new ElectricityNetwork();
            newNetwork.getConductors().addAll(this.getConductors());
            newNetwork.getConductors().addAll(network.getConductors());
            newNetwork.refresh();
        }
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.getConductors().remove(splitPoint);
            TileEntity[] connectedBlocks = splitPoint.getAdjacentConnections();
            for (int i = 0; i < connectedBlocks.length; ++i) {
                TileEntity connectedBlockA = connectedBlocks[i];
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (int ii = 0; ii < connectedBlocks.length; ++ii) {
                    TileEntity connectedBlockB = connectedBlocks[ii];
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).field_70331_k, (INetworkConnection)connectedBlockB, splitPoint);
                    finder.init(new Vector3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (Vector3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    ElectricityNetwork newNetwork = new ElectricityNetwork();
                    for (Vector3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getConductors().add((IConductor)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "ElectricityNetwork[" + this.hashCode() + "|Wires:" + this.conductors.size() + "|Acceptors:" + this.electricalTiles.size() + "]";
    }
}

