/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.vector;

import universalelectricity.core.vector.Vector3;

public class Quaternion
implements Cloneable {
    public static final float TOLERANCE = 1.0E-5f;
    public double x;
    public double y;
    public double z;
    public double w;

    public Quaternion() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public Quaternion(Quaternion copy) {
        this(copy.x, copy.y, copy.z, copy.w);
    }

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion(float pitch, float yaw, float roll) {
        float p = (float)((double)pitch * (Math.PI / 180) / 2.0);
        float y = (float)((double)yaw * (Math.PI / 180) / 2.0);
        float r = (float)((double)roll * (Math.PI / 180) / 2.0);
        float sinp = (float)Math.sin(p);
        float siny = (float)Math.sin(y);
        float sinr = (float)Math.sin(r);
        float cosp = (float)Math.cos(p);
        float cosy = (float)Math.cos(y);
        float cosr = (float)Math.cos(r);
        this.x = sinr * cosp * cosy - cosr * sinp * siny;
        this.y = cosr * sinp * cosy + sinr * cosp * siny;
        this.z = cosr * cosp * siny - sinr * sinp * cosy;
        this.w = cosr * cosp * cosy + sinr * sinp * siny;
        this.normalize();
    }

    public Quaternion(Vector3 vector, double w) {
        this(vector.x, vector.y, vector.z, w);
    }

    public static Quaternion IDENTITY() {
        return new Quaternion();
    }

    public Quaternion set(Quaternion quaternion) {
        this.w = quaternion.w;
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        return this;
    }

    public Quaternion set(double x, double y, double z, double w) {
        return this.set(new Quaternion(x, y, z, w));
    }

    public Quaternion normalize() {
        double magnitude = this.magnitude();
        this.x /= magnitude;
        this.y /= magnitude;
        this.z /= magnitude;
        this.w /= magnitude;
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Quaternion inverse() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        return new Quaternion(this.x / d, -this.y / d, -this.z / d, -this.w / d);
    }

    public Quaternion getConjugate() {
        return this.clone().conjugate();
    }

    public Quaternion conjugate() {
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Quaternion getMultiply(Quaternion b) {
        return this.clone().multiply(b);
    }

    public Quaternion multiply(Quaternion b) {
        Quaternion a = this;
        double newX = a.x * b.x - a.y * b.y - a.z * b.z - a.w * b.w;
        double newY = a.x * b.y + a.y * b.x + a.z * b.w - a.w * b.z;
        double newZ = a.x * b.z - a.y * b.w + a.z * b.x + a.w * b.y;
        double newW = a.x * b.w + a.y * b.z - a.z * b.y + a.w * b.x;
        this.set(newX, newY, newZ, newW);
        return this;
    }

    public Quaternion divide(Quaternion b) {
        Quaternion a = this;
        return a.inverse().multiply(b);
    }

    public Vector3 multi(Vector3 vec) {
        Vector3 vn = vec.clone();
        Quaternion vecQuat = new Quaternion(0.0, 0.0, 0.0, 1.0);
        vecQuat.x = (float)vn.x;
        vecQuat.y = (float)vn.y;
        vecQuat.z = (float)vn.z;
        vecQuat.w = 0.0;
        Quaternion resQuat = vecQuat.multiply(this.getConjugate());
        resQuat = this.multiply(resQuat);
        return new Vector3(resQuat.x, resQuat.y, resQuat.z);
    }

    public static Quaternion fromAxis(Vector3 vector, double angle) {
        Vector3 vn = vector.clone().normalize();
        float sinAngle = (float)Math.sin(angle *= 0.5);
        return new Quaternion(vn.x * (double)sinAngle, vn.y * (double)sinAngle, vn.z * (double)sinAngle, Math.cos(angle));
    }

    public void getAxisAngle(Vector3 axis, float angle) {
        float scale = (float)axis.getMagnitude();
        this.x /= (double)scale;
        this.y /= (double)scale;
        this.z /= (double)scale;
        angle = (float)(Math.acos(this.w) * 2.0);
    }

    public Quaternion clone() {
        return new Quaternion(this);
    }

    public String toString() {
        return "Quaternion [" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
    }
}

