/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.client.Settings;
import net.gliby.voicechat.client.device.DeviceHandler;
import net.gliby.voicechat.client.gui.EnumUIPlacement;

@SideOnly(value=Side.CLIENT)
public class Configuration {
    public static final String MICROPHONE = "mic_name";
    public static final String WORLD_VOLUME = "world_volume";
    public static final String INPUT_BOOST = "input_boost";
    public static final String UI_OPACITY = "ui_opa";
    public static final String SPEAK_MODE = "speak_mode";
    public static final String VERSION = "save-version";
    public static final String DEBUG_MODE = "debug_enabled";
    public static final String ENCODING_QUALITY = "enc_quality";
    public static final String ENCODING_MODE = "enc_mode";
    public static final String UI_POSITION_PLATE = "uipos_plate";
    public static final String UI_POSITION_SPEAK = "uipos_speak";
    public static final String SNOOPER_ALLOWED = "snop";
    public static final String ENCODING_ENCHANTMENT = "enc_ench";
    private Properties properties = new Properties();
    private final File file;
    private Settings settings;

    public Configuration(Settings settings, File file) {
        this.settings = settings;
        this.file = file;
    }

    private boolean load(DeviceHandler handler) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.file);
            this.properties.load(is);
            if (handler.getDefaultDevice() != null) {
                this.settings.setInputDevice(handler.getDeviceByName(this.properties.getProperty(MICROPHONE, handler.getDefaultDevice().getName())));
            }
            this.settings.setWorldVolume(Float.parseFloat(this.properties.getProperty(WORLD_VOLUME)));
            this.settings.setInputBoost(Float.parseFloat(this.properties.getProperty(INPUT_BOOST)));
            this.settings.setUIOpacity(Float.parseFloat(this.properties.getProperty(UI_OPACITY)));
            this.settings.setSpeakMode(Integer.parseInt(this.properties.getProperty(SPEAK_MODE)));
            this.settings.setDebugMode(Boolean.parseBoolean(this.properties.getProperty(DEBUG_MODE)));
            this.settings.setEncodingQuality(Float.parseFloat(this.properties.getProperty(ENCODING_QUALITY)));
            this.settings.setEncodingMode(Integer.parseInt(this.properties.getProperty(ENCODING_MODE)));
            this.settings.setSnooperAllowed(Boolean.parseBoolean(this.properties.getProperty(SNOOPER_ALLOWED)));
            this.settings.setPerceptualEnchantment(Boolean.parseBoolean(this.properties.getProperty(ENCODING_ENCHANTMENT)));
            String[] positionArray = ((String)this.properties.get(UI_POSITION_SPEAK)).split(":");
            this.settings.setUIPosition(EnumUIPlacement.SPEAK, Float.parseFloat(positionArray[0]), Float.parseFloat(positionArray[1]), Float.parseFloat(positionArray[3]), Integer.parseInt(positionArray[2]));
            positionArray = ((String)this.properties.get(UI_POSITION_PLATE)).split(":");
            this.settings.setUIPosition(EnumUIPlacement.VOICE_PLATES, Float.parseFloat(positionArray[0]), Float.parseFloat(positionArray[1]), Float.parseFloat(positionArray[3]), Integer.parseInt(positionArray[2]));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean save(DeviceHandler deviceHandler) {
        try {
            this.properties.setProperty(VERSION, VoiceChat.getProxyInstance().getVersion());
            if (this.settings.getInputDevice().getName() != null) {
                this.properties.setProperty(MICROPHONE, this.settings.getInputDevice().getName());
            }
            this.properties.setProperty(WORLD_VOLUME, "" + this.settings.getWorldVolume());
            this.properties.setProperty(INPUT_BOOST, "" + this.settings.getInputBoost());
            this.properties.setProperty(SPEAK_MODE, "" + this.settings.getSpeakMode());
            this.properties.setProperty(UI_OPACITY, "" + this.settings.getUIOpacity());
            this.properties.setProperty(DEBUG_MODE, "" + this.settings.getDebugMode());
            this.properties.setProperty(ENCODING_QUALITY, "" + this.settings.getEncodingQuality());
            this.properties.setProperty(ENCODING_MODE, "" + this.settings.getEncodingMode());
            this.properties.setProperty(SNOOPER_ALLOWED, "" + this.settings.isSnooperAllowed());
            this.properties.setProperty(ENCODING_ENCHANTMENT, "" + this.settings.isPerceptualEnchantmentAllowed());
            this.properties.setProperty(UI_POSITION_SPEAK, this.settings.getUIPositionSpeak().x + ":" + this.settings.getUIPositionSpeak().y + ":" + this.settings.getUIPositionSpeak().type + ":" + this.settings.getUIPositionSpeak().scale);
            this.properties.setProperty(UI_POSITION_PLATE, this.settings.getUIPositionPlate().x + ":" + this.settings.getUIPositionPlate().y + ":" + this.settings.getUIPositionPlate().type + ":" + this.settings.getUIPositionPlate().scale);
            FileOutputStream out = new FileOutputStream(this.file);
            this.properties.store(out, "Properties for Gliby's Voice Chat Mod for Forge, VERSION: " + VoiceChat.getProxyInstance().getVersion());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void init(DeviceHandler deviceHandler) {
        if (!this.load(deviceHandler)) {
            VoiceChat.getLogger().info("No Configuration file found, will create one with default settings.");
            this.settings.setSetupNeeded(true);
            if (this.save(deviceHandler)) {
                VoiceChat.getLogger().info("Created Configuration file with default settings.");
            }
        }
    }
}

