/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import net.gliby.voicechat.client.Configuration;
import net.gliby.voicechat.client.device.Device;
import net.gliby.voicechat.client.device.DeviceHandler;
import net.gliby.voicechat.client.gui.EnumUIPlacement;
import net.gliby.voicechat.client.gui.UIPosition;
import net.gliby.voicechat.common.MathUtility;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;

@SideOnly(value=Side.CLIENT)
public class Settings {
    private final DeviceHandler deviceHandler = new DeviceHandler();
    private boolean debugMode;
    private Device inputDevice;
    private float worldVolume = 1.0f;
    private float inputBoost = 0.0f;
    private float uiOpacity = 1.0f;
    private int speakMode = 0;
    private int encodingMode = 0;
    public int minQuality = 0;
    public int maxQuality = 10;
    private float encodingQuality = 0.6f;
    public UIPosition uiPositionSpeak;
    public UIPosition uiPositionPlate;
    private boolean perceptualEnchantment = true;
    private boolean setupNeeded;
    private boolean snooperEnabled = true;
    public int maxSoundDistance = 63;
    Configuration configuration;

    public Settings(File file) {
        this.configuration = new Configuration(this, file);
        this.uiPositionSpeak = new UIPosition(EnumUIPlacement.SPEAK, EnumUIPlacement.SPEAK.x, EnumUIPlacement.SPEAK.y, EnumUIPlacement.SPEAK.positionType, 1.0f);
        this.uiPositionPlate = new UIPosition(EnumUIPlacement.VOICE_PLATES, EnumUIPlacement.VOICE_PLATES.x, EnumUIPlacement.VOICE_PLATES.y, EnumUIPlacement.VOICE_PLATES.positionType, 1.0f);
    }

    public void init() {
        this.deviceHandler.loadDevices();
        this.configuration.init(this.deviceHandler);
    }

    public Device getInputDevice() {
        if (this.inputDevice == null) {
            this.inputDevice = this.deviceHandler.getDefaultDevice();
        }
        return this.inputDevice;
    }

    public void setInputDevice(Device loadedDevice) {
        this.inputDevice = loadedDevice;
    }

    public float getWorldVolume() {
        return this.worldVolume;
    }

    public void setWorldVolume(float worldVolume) {
        this.worldVolume = worldVolume;
    }

    public float getInputBoost() {
        return this.inputBoost;
    }

    public void setInputBoost(float inputBoost) {
        this.inputBoost = inputBoost;
    }

    public float getUIOpacity() {
        return this.uiOpacity;
    }

    public void setUIOpacity(float chatIconOpacity) {
        this.uiOpacity = chatIconOpacity;
    }

    public int getSpeakMode() {
        return this.speakMode;
    }

    public void setSpeakMode(int speakMode) {
        this.speakMode = speakMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public DeviceHandler getDeviceHandler() {
        return this.deviceHandler;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public float getEncodingQuality() {
        return MathUtility.clamp(this.encodingQuality, 0.0f, 1.0f);
    }

    public void setEncodingQuality(float encodingQuality) {
        this.encodingQuality = encodingQuality;
    }

    public int getEncodingMode() {
        return (int)MathUtility.clamp(this.encodingMode, 0.0f, 2.0f);
    }

    public void setEncodingMode(int encodingMode) {
        this.encodingMode = encodingMode;
    }

    public String getEncodingModeString() {
        String s = "Narrowband";
        switch (this.encodingMode) {
            case 0: {
                s = "Narrowband";
                break;
            }
            case 1: {
                s = "Wideband";
                break;
            }
            case 2: {
                s = "Ultrawideband";
            }
        }
        return s;
    }

    public boolean isSetupNeeded() {
        return this.setupNeeded;
    }

    public void setSetupNeeded(boolean setupNeeded) {
        this.setupNeeded = setupNeeded;
    }

    public int getUDPPort() {
        return 54777;
    }

    public int getTCPPort() {
        return 54555;
    }

    public EnumVoiceNetworkType getVoiceServerType() {
        return EnumVoiceNetworkType.MINECRAFT;
    }

    public float getTimeToAuthenticate() {
        return 350.0f;
    }

    public boolean isPerceptualEnchantmentAllowed() {
        return this.perceptualEnchantment;
    }

    public void setPerceptualEnchantment(boolean perceptualEnchantment) {
        this.perceptualEnchantment = perceptualEnchantment;
    }

    public UIPosition getUIPositionSpeak() {
        return this.uiPositionSpeak;
    }

    public UIPosition getUIPositionPlate() {
        return this.uiPositionPlate;
    }

    public void setUIPosition(EnumUIPlacement placement, float x, float y, float scale, int type) {
        if (placement == EnumUIPlacement.SPEAK) {
            this.uiPositionSpeak = new UIPosition(placement, x, y, type, scale);
        }
        if (placement == EnumUIPlacement.VOICE_PLATES) {
            this.uiPositionPlate = new UIPosition(placement, x, y, type, scale);
        }
    }

    public void resetUI(int width, int height) {
        this.uiPositionSpeak.type = this.uiPositionSpeak.info.positionType;
        this.uiPositionSpeak.x = this.uiPositionSpeak.info.x;
        this.uiPositionSpeak.y = this.uiPositionSpeak.info.y;
        this.uiPositionSpeak.scale = 1.0f;
        this.uiPositionPlate.type = this.uiPositionPlate.info.positionType;
        this.uiPositionPlate.x = this.uiPositionPlate.info.x;
        this.uiPositionPlate.y = this.uiPositionPlate.info.y;
        this.uiPositionPlate.scale = 1.0f;
    }

    public void setSoundDistance(int soundDist) {
        this.maxSoundDistance = soundDist;
    }

    public int getSoundDistance() {
        return this.maxSoundDistance;
    }

    public boolean isSnooperAllowed() {
        return this.snooperEnabled;
    }

    public void resetQuality() {
        this.minQuality = 0;
        this.maxQuality = 10;
    }

    public void setSnooperAllowed(boolean b) {
        this.snooperEnabled = b;
    }

    public void setBandwidthLimit(int x, int x1) {
        this.minQuality = x;
        this.maxQuality = x1;
    }
}

