/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.gliby.snooper.GSnooper;
import net.gliby.snooper.UpdateStatus;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.client.Settings;
import net.gliby.voicechat.client.UpdatedSoundManager;
import net.gliby.voicechat.client.debug.Statistics;
import net.gliby.voicechat.client.gui.GuiInGameHandler;
import net.gliby.voicechat.client.keybindings.KeyManager;
import net.gliby.voicechat.client.networking.ClientNetwork;
import net.gliby.voicechat.client.networking.game.ClientPlayerTracker;
import net.gliby.voicechat.client.render.RenderPlayerVoiceIcon;
import net.gliby.voicechat.client.sound.PlayableStream;
import net.gliby.voicechat.client.sound.SoundManager;
import net.gliby.voicechat.common.VoiceChatServer;
import net.minecraftforge.common.MinecraftForge;

public class VoiceChatClient
extends VoiceChatServer {
    @SideOnly(value=Side.CLIENT)
    private File configurationDirectory;
    @SideOnly(value=Side.CLIENT)
    private Settings settings;
    @SideOnly(value=Side.CLIENT)
    public KeyManager keyManager;
    @SideOnly(value=Side.CLIENT)
    private UpdateStatus updateStatus;
    @SideOnly(value=Side.CLIENT)
    private static SoundManager soundManager;
    @SideOnly(value=Side.CLIENT)
    private ClientNetwork clientNetwork;
    @SideOnly(value=Side.CLIENT)
    private static Statistics stats;
    @SideOnly(value=Side.CLIENT)
    private boolean recorderActive;
    @SideOnly(value=Side.CLIENT)
    public List<PlayableStream> activeStreams = new ArrayList<PlayableStream>();
    VoiceChat voiceChat;
    String[] specialPlayers = new String[]{"captaindogfish", "starguy1245", "SheheryaB", "arsham123", "Chris9awesome", "TechnoX_X", "bubz052", "McJackson3180", "InfamousArgyle", "jdf2", "XxNotexX0", "SirDenerim", "Frankspark", "smith70831", "killazombiecow", "CraftAeternalis", "choclaterainxx", "dragonballkid4", "TH3_CR33PER", "yetshadow", "KristinnVikarJ", "TheMCBros99", "kevinlame"};

    @Override
    public void initClient(VoiceChat voiceChat, FMLStateEvent event) {
        atv mc = atv.w();
        new UpdatedSoundManager(this, mc.v).init();
        this.voiceChat = voiceChat;
        this.keyManager.init();
        if (this.settings.getDebugMode()) {
            stats = new Statistics();
        }
        voiceChat.getLogger().info("Started client-side on version (" + this.getVersion() + ")" + "");
        this.clientNetwork = new ClientNetwork(this);
        GameRegistry.registerPlayerTracker((IPlayerTracker)new ClientPlayerTracker(this));
        MinecraftForge.EVENT_BUS.register((Object)new GuiInGameHandler(this));
        MinecraftForge.EVENT_BUS.register((Object)new RenderPlayerVoiceIcon(this, mc));
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        this.configurationDirectory = new File(event.getModConfigurationDirectory(), "gvc");
        if (!this.configurationDirectory.exists()) {
            this.configurationDirectory.mkdir();
        }
        this.settings = new Settings(new File(this.configurationDirectory, "config.properties"));
        this.settings.init();
        this.updateStatus = new UpdateStatus(event);
        GSnooper.launchMod(this.updateStatus, this.settings.isSnooperAllowed(), atv.w().H().a(), 0, VoiceChatClient.getMinecraftVersion(), this.getVersion());
        this.keyManager = new KeyManager(this);
        soundManager = new SoundManager(atv.w(), this);
        soundManager.init();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public UpdateStatus getUpdateStatus() {
        return this.updateStatus;
    }

    public static Statistics getStatistics() {
        return stats;
    }

    public static SoundManager getSoundManager() {
        return soundManager;
    }

    public ClientNetwork getClientNetwork() {
        return this.clientNetwork;
    }

    public static synchronized Logger getLogger() {
        Logger l = Logger.getLogger("Gliby's Voice Chat Mod");
        l.setParent(FMLLog.getLogger());
        return l;
    }

    public boolean isRecorderActive() {
        return this.recorderActive;
    }

    public void setRecorderActive(boolean b) {
        if (this.clientNetwork.voiceClientExists()) {
            this.recorderActive = b;
        }
    }

    public String getShortVersion() {
        return this.getVersion().replaceAll("\\.", "");
    }

    public String[] getSpecialPlayers() {
        return this.specialPlayers;
    }
}

