/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.keybindings;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.keybindings.EnumBinding;
import net.gliby.voicechat.client.keybindings.KeyBindingHandler;
import net.gliby.voicechat.client.keybindings.KeyEvent;
import net.gliby.voicechat.client.keybindings.KeyGuiOptionsEvent;
import net.gliby.voicechat.client.keybindings.KeySpeakEvent;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class KeyManager {
    private VoiceChatClient voiceChat;
    @SideOnly(value=Side.CLIENT)
    private List<KeyEvent> keyEvents = new ArrayList<KeyEvent>();

    public KeyManager(VoiceChatClient voiceChat) {
        this.voiceChat = voiceChat;
    }

    @SideOnly(value=Side.CLIENT)
    public List<KeyEvent> getKeyEvents() {
        return this.keyEvents;
    }

    public void init() {
        this.keyEvents.add(new KeySpeakEvent(this.voiceChat, EnumBinding.SPEAK, 47, false));
        this.keyEvents.add(new KeyGuiOptionsEvent(this.voiceChat, EnumBinding.OPEN_GUI_OPTIONS, 52, false));
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyBindingHandler(this.compileKeyBindings(), this.compileRepeating(), this));
    }

    private boolean[] compileRepeating() {
        boolean[] keyRepeating = new boolean[this.keyEvents.size()];
        for (int i = 0; i < keyRepeating.length; ++i) {
            KeyEvent keyEvent = this.keyEvents.get(i);
            keyRepeating[i] = keyEvent.repeating;
        }
        return keyRepeating;
    }

    private ats[] compileKeyBindings() {
        ats[] keyBinding = new ats[this.keyEvents.size()];
        for (int i = 0; i < keyBinding.length; ++i) {
            KeyEvent keyEvent = this.keyEvents.get(i);
            keyBinding[i] = new ats(keyEvent.keyBind.name, keyEvent.keyID);
        }
        return keyBinding;
    }

    public String getKeyName(EnumBinding binding) {
        for (int i = 0; i < this.keyEvents.size(); ++i) {
            KeyEvent event = this.keyEvents.get(i);
            if (event.keyBind != binding) continue;
            return Keyboard.getKeyName((int)event.keyID);
        }
        return null;
    }
}

