/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.networking;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.InetSocketAddress;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;

public class ClientPacketHandler
implements IPacketHandler {
    public void onPacketData(cm manager, ea packet, Player player) {
        String channel = packet.a;
        this.executePacket(manager, channel, packet, player);
    }

    private void executePacket(cm manager, String channel, ea packet, Player player) {
        if (channel.equals("GVC-SMPL")) {
            this.handleVoiceData(packet, player);
        } else if (channel.equals("GVC-SMPLE")) {
            this.handleVoiceEnd(packet, player);
        } else if (channel.equals("GVC-CHSMPL")) {
            this.handleChunkVoiceData(packet, player);
        } else if (channel.equals("GVC-VSA")) {
            this.handleVoiceServerAuthentication(manager, packet, player);
        } else if (channel.equals("GVC-VS")) {
            this.handleVoiceServer(manager, packet, player);
        } else if (channel.equals("GVC-E")) {
            this.handleEntityPosition(packet, player);
        } else if (channel.equals("GVC-ED")) {
            this.handleEntityData(packet, player);
        } else if (channel.equals("GVC-FORCEB")) {
            this.handleForceBandwidth(packet, player);
        }
    }

    private void handleForceBandwidth(ea packet, Player player) {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.c);
        DataInputStream dis = new DataInputStream(bais);
        int x = -1;
        int x1 = -1;
        try {
            x = dis.readInt();
            x1 = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().setQuality(x, x1);
    }

    private void handleEntityData(ea packet, Player player) {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.c);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        double motX = -1.0;
        double motY = -1.0;
        double motZ = -1.0;
        String name = null;
        try {
            entityID = dis.readInt();
            name = dis.readUTF();
            x = dis.readDouble();
            y = dis.readDouble();
            z = dis.readDouble();
            motX = dis.readDouble();
            motY = dis.readDouble();
            motZ = dis.readDouble();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (name != null) {
            VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handleEntityData(entityID, name, x, y, z, motX, motY, motZ);
        }
    }

    private void handleEntityPosition(ea packet, Player player) {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.c);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        double x = -1.0;
        double y = -1.0;
        double z = -1.0;
        double motX = -1.0;
        double motY = -1.0;
        double motZ = -1.0;
        try {
            entityID = dis.readInt();
            x = dis.readDouble();
            y = dis.readDouble();
            z = dis.readDouble();
            motX = dis.readDouble();
            motY = dis.readDouble();
            motZ = dis.readDouble();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handleEntityPosition(entityID, x, y, z, motX, motY, motZ);
    }

    private void handleVoiceData(ea packet, Player player) {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.c);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        int global = 0;
        byte[] data = null;
        try {
            int size = dis.readInt();
            data = new byte[size];
            for (int i = 0; i < size; ++i) {
                data[i] = dis.readByte();
            }
            entityID = dis.readInt();
            global = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handlePacket(entityID, data, data.length, global);
    }

    private void handleChunkVoiceData(ea packet, Player player) {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.c);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        int chunkSize = -1;
        int global = 0;
        byte[] data = null;
        try {
            int size = dis.readInt();
            data = new byte[size];
            for (int i = 0; i < size; ++i) {
                data[i] = dis.readByte();
            }
            chunkSize = dis.readInt();
            entityID = dis.readInt();
            global = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handlePacket(entityID, data, chunkSize, global);
    }

    private void handleVoiceServerAuthentication(cm manager, ea packet, Player player) {
        String serverAddress = null;
        if (manager.c() instanceof InetSocketAddress) {
            InetSocketAddress netAddress = (InetSocketAddress)manager.c();
            serverAddress = netAddress.getAddress().getHostAddress();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.c);
        DataInputStream dis = new DataInputStream(bais);
        int type = 0;
        String hash = null;
        int udp = 0;
        int maxSoundDistance = 63;
        try {
            maxSoundDistance = dis.readInt();
            type = dis.readInt();
            hash = dis.readUTF();
            udp = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().startClientNetwork(EnumVoiceNetworkType.values()[type], hash, serverAddress, udp, maxSoundDistance);
    }

    private void handleVoiceServer(cm manager, ea packet, Player player) {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.c);
        DataInputStream dis = new DataInputStream(bais);
        int type = 0;
        int maxSoundDistance = 63;
        try {
            maxSoundDistance = dis.readInt();
            type = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().startClientNetwork(EnumVoiceNetworkType.values()[type], null, null, 0, maxSoundDistance);
    }

    private void handleVoiceEnd(ea packet, Player player) {
        ByteArrayInputStream bais = new ByteArrayInputStream(packet.c);
        DataInputStream dis = new DataInputStream(bais);
        int entityID = -1;
        try {
            entityID = dis.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VoiceChat.getProxyInstance().getClientNetwork().getVoiceClient().handleEnd(entityID);
    }
}

