/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.sound;

import java.util.Comparator;
import net.gliby.voicechat.client.debug.MovingAverage;
import net.gliby.voicechat.client.sound.JitterBuffer;
import net.gliby.voicechat.client.sound.SoundManager;
import net.gliby.voicechat.common.EntityVector;

public class PlayableStream {
    public final int id;
    public int special;
    public int voiceMode;
    public nn entity;
    public boolean end;
    public long lastUpdated;
    public long lastFlushed;
    private MovingAverage jitterAverage = new MovingAverage(5);
    public JitterBuffer buffer;
    private SoundManager manager;

    public PlayableStream(SoundManager manager, int id, int voiceMode) {
        this.manager = manager;
        this.id = id;
        this.voiceMode = voiceMode;
        this.lastUpdated = System.currentTimeMillis();
        this.lastFlushed = System.currentTimeMillis();
        this.buffer = new JitterBuffer(SoundManager.universalAudioFormat, 0);
    }

    public int getJitterRate() {
        return this.jitterAverage.getAverage().intValue();
    }

    public String getEntityName() {
        EntityVector vector = this.getEntityVector();
        return this.entity != null ? this.entity.an() : (vector.entityName != null ? vector.entityName : "missingno" + this.id);
    }

    public boolean isEntityPlayer() {
        return this.entity instanceof beu;
    }

    public void update(int l) {
        this.jitterAverage.add(l);
    }

    public EntityVector getCustomEntityVector() {
        EntityVector vector = this.getEntityVector();
        return this.entity != null ? new EntityVector(this.id, "", this.entity.u, this.entity.v, this.entity.w, this.entity.x, this.entity.y, this.entity.z) : (vector.entityName != null ? vector : EntityVector.NULL);
    }

    public EntityVector getEntityVector() {
        if (this.manager.entityData.containsKey(this.id)) {
            return this.manager.entityData.get(this.id);
        }
        return null;
    }

    public beu getPlayer() {
        return (beu)this.entity;
    }

    public void setEntity(nn entity) {
        this.entity = entity;
    }

    public static class PlayableStreamComparator
    implements Comparator<PlayableStream> {
        @Override
        public int compare(PlayableStream a2, PlayableStream b) {
            int f = a2.id > b.id ? 1 : (a2.id < b.id ? -1 : 0);
            return f;
        }
    }
}

