/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.sound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sound.sampled.AudioFormat;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.sound.Datalet;
import net.gliby.voicechat.client.sound.PlayableStream;
import net.gliby.voicechat.client.sound.SoundPreProcessor;
import net.gliby.voicechat.client.sound.thread.ThreadQueue;
import net.gliby.voicechat.client.sound.thread.ThreadUpdateStream;
import net.gliby.voicechat.common.EntityVector;

public class SoundManager {
    public static AudioFormat universalAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
    public ConcurrentLinkedQueue<Datalet> queue = new ConcurrentLinkedQueue();
    public ConcurrentHashMap<Integer, PlayableStream> streaming = new ConcurrentHashMap();
    private final SoundPreProcessor soundPreProcessor;
    public ConcurrentHashMap<Integer, EntityVector> entityData = new ConcurrentHashMap();
    private atv mc;
    private Thread threadUpdate;
    private ThreadQueue queueThread;
    private VoiceChatClient voiceChatClient;

    public SoundManager(atv mc, VoiceChatClient voiceChatClient) {
        this.mc = mc;
        this.voiceChatClient = voiceChatClient;
        this.soundPreProcessor = new SoundPreProcessor(voiceChatClient, mc);
    }

    public void init() {
        this.queueThread = new ThreadQueue(this);
        new Thread((Runnable)this.queueThread, "Client Stream Queue").start();
        this.threadUpdate = new Thread((Runnable)new ThreadUpdateStream(this), "Client Stream Updater");
        this.threadUpdate.start();
    }

    public void addQueue(byte[] decoded_data, int global, int id) {
        this.queue.offer(new Datalet(global, id, decoded_data));
        this.queueThread.notifyQueue();
    }

    public boolean newDatalet(Datalet let) {
        if (this.streaming.containsKey(let.id)) {
            PlayableStream stream = this.streaming.get(let.id);
            return stream.voiceMode != let.global;
        }
        return true;
    }

    public void createStream(Datalet data) {
        if (this.streaming.containsKey(data.id)) {
            this.replaceStream(data);
            return;
        }
        String identifier = this.generateSource(data.id);
        if (data.global == 1) {
            nn entity = this.mc.f.a(data.id);
            EntityVector vector = this.entityData.get(data.id);
            if (entity != null) {
                this.mc.v.b.rawDataStream(universalAudioFormat, false, identifier, (float)entity.u, (float)entity.v, (float)entity.w, 2, (float)this.voiceChatClient.getSettings().getSoundDistance());
            } else if (vector != null) {
                this.mc.v.b.rawDataStream(universalAudioFormat, false, identifier, (float)vector.x, (float)vector.y, (float)vector.z, 2, (float)this.voiceChatClient.getSettings().getSoundDistance());
            } else {
                this.mc.v.b.rawDataStream(universalAudioFormat, false, identifier, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            }
        } else {
            this.mc.v.b.rawDataStream(universalAudioFormat, false, identifier, 0.0f, 0.0f, 0.0f, 0, 0.0f);
        }
        this.mc.v.b.setPitch(identifier, 1.0f);
        this.mc.v.b.setVolume(identifier, this.voiceChatClient.getSettings().getWorldVolume());
        this.addStreamSafe(new PlayableStream(this, data.id, data.global));
        this.giveStream(data);
    }

    public void replaceStream(Datalet data) {
        PlayableStream stream = this.streaming.get(data.id);
        stream.voiceMode = data.global;
        this.mc.v.b.setDistOrRoll(this.generateSource(stream.id), (float)this.voiceChatClient.getSettings().getSoundDistance());
    }

    public void giveStream(Datalet data) {
        PlayableStream stream = this.getStreamByID(data.id);
        if (stream != null) {
            String identifier = this.generateSource(data.id);
            stream.update((int)(System.currentTimeMillis() - stream.lastUpdated));
            stream.buffer.push(data.data);
            stream.buffer.updateJitter(stream.getJitterRate());
            if (stream.buffer.isReady() || stream.end) {
                this.mc.v.b.flush(identifier);
                this.mc.v.b.feedRawAudioData(identifier, stream.buffer.get());
                stream.buffer.clearBuffer(stream.getJitterRate());
            }
            stream.lastUpdated = System.currentTimeMillis();
        }
    }

    public void giveEnd(int id) {
        PlayableStream stream = this.streaming.get(id);
        if (stream != null) {
            stream.end = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStreamSafe(PlayableStream stream) {
        String entityName;
        nn entity;
        if (!this.streaming.containsKey(stream.id)) {
            this.streaming.put(stream.id, stream);
            Thread thread = this.threadUpdate;
            synchronized (thread) {
                this.threadUpdate.notify();
            }
        }
        if ((entity = this.mc.f.a(stream.id)) != null) {
            stream.setEntity(entity);
        }
        if ((entityName = stream.getEntityName()) != null) {
            for (int i = 0; i < this.voiceChatClient.getSpecialPlayers().length; ++i) {
                String name = this.voiceChatClient.getSpecialPlayers()[i];
                if (!entityName.equals(name)) continue;
                stream.special = 2;
            }
            if (entityName.equals("MG211") || entityName.equals("Rinto") || entityName.equals("DanielSturk")) {
                stream.special = 1;
            }
            if (entityName.equals("CraftAeternalis")) {
                stream.special = 3;
            }
            if (entityName.equals("DanielSturk")) {
                stream.special = 4;
            }
            if (entityName.equals("yetshadow")) {
                stream.special = 5;
            }
            if (entityName.equals("McJackson3180")) {
                stream.special = 6;
            }
            if (entityName.equals("smith70831")) {
                stream.special = 7;
            }
            if (entityName.equals("XxNotexX0")) {
                stream.special = 8;
            }
        }
        if (!this.containsGuiStream(stream.id)) {
            ArrayList<PlayableStream> streams = new ArrayList<PlayableStream>(this.voiceChatClient.activeStreams);
            streams.add(stream);
            Collections.sort(streams, new PlayableStream.PlayableStreamComparator());
            this.voiceChatClient.activeStreams.removeAll(this.voiceChatClient.activeStreams);
            this.voiceChatClient.activeStreams.addAll(streams);
        }
    }

    private String generateSource(int let) {
        return "" + let;
    }

    public void killStream(int id) {
        PlayableStream stream = this.getGuiStreamByID(id);
        if (stream != null) {
            ArrayList<PlayableStream> streams = new ArrayList<PlayableStream>(this.voiceChatClient.activeStreams);
            streams.remove(stream);
            Collections.sort(streams, new PlayableStream.PlayableStreamComparator());
            this.voiceChatClient.activeStreams.removeAll(this.voiceChatClient.activeStreams);
            this.voiceChatClient.activeStreams.addAll(streams);
            this.voiceChatClient.activeStreams.remove(stream);
            Collections.sort(this.voiceChatClient.activeStreams, new PlayableStream.PlayableStreamComparator());
            this.streaming.remove(id);
        }
    }

    public PlayableStream getStreamByID(int id) {
        return this.streaming.get(id);
    }

    public PlayableStream getGuiStreamByID(int id) {
        for (int i = 0; i < this.voiceChatClient.activeStreams.size(); ++i) {
            PlayableStream stream = this.voiceChatClient.activeStreams.get(i);
            if (stream.id != id) continue;
            return stream;
        }
        return null;
    }

    public boolean containsGuiStream(int id) {
        PlayableStream currentStream = this.streaming.get(id);
        for (int i = 0; i < this.voiceChatClient.activeStreams.size(); ++i) {
            PlayableStream stream = this.voiceChatClient.activeStreams.get(i);
            String currentName = currentStream.getEntityName();
            String otherName = stream.getEntityName();
            if (stream.getEntityName() != null && currentStream.getEntityName() != null && currentName.equals(otherName)) {
                return true;
            }
            if (stream.id != id) continue;
            return true;
        }
        return false;
    }

    public SoundPreProcessor getSoundPreProcessor() {
        return this.soundPreProcessor;
    }

    public static AudioFormat getUniversalAudioFormat() {
        return universalAudioFormat;
    }

    public void setPosition(String string, float posX, float posY, float posZ) {
        this.mc.v.b.setPosition(string, posX, posY, posZ);
    }

    public void alertEnd(int id) {
        this.queue.offer(new Datalet(id, 0, null));
        this.queueThread.notifyQueue();
    }

    public void reset() {
        this.streaming.clear();
        this.voiceChatClient.activeStreams.clear();
        this.entityData.clear();
    }
}

