/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.lang.reflect.Field;
import java.util.logging.Logger;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.common.ServerSettings;
import net.gliby.voicechat.common.commands.CommandVoiceMute;
import net.gliby.voicechat.common.networking.CommonPlayerTracker;
import net.gliby.voicechat.common.networking.ServerNetwork;
import net.gliby.voicechat.common.networking.voiceservers.ConnectionHandler;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;
import net.gliby.voicechat.common.networking.voiceservers.MinecraftVoiceServer;
import net.gliby.voicechat.common.networking.voiceservers.VoiceServer;
import net.minecraft.server.MinecraftServer;

public class VoiceChatServer {
    private static final String VERSION = "0.4.0";
    private static final String MC_VERSION = new c(null).a();
    public static final int VOICESERVER_UDP = 5447;
    private VoiceServer voiceServer;
    private Thread voiceServerThread;
    private ServerNetwork serverNetwork;
    private ServerSettings settings;
    private File configurationDirectory;

    public void initServer(FMLServerStartingEvent event) {
        GameRegistry.registerPlayerTracker((IPlayerTracker)new CommonPlayerTracker(this));
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new ConnectionHandler(this));
        this.voiceServerThread = this.startVoiceServer();
        VoiceChatServer.getLogger().info("Gliby's Voice Chat Mod for Forge Server has started.");
        this.settings = new ServerSettings(this);
        if (MinecraftServer.F().V()) {
            try {
                Field fileField = MinecraftServer.class.getField("anvilFile");
                fileField.setAccessible(true);
                File file = (File)fileField.get(MinecraftServer.F());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configurationDirectory = new File(MinecraftServer.F().L(), "gliby_vc");
            if (!this.configurationDirectory.exists()) {
                this.configurationDirectory.mkdir();
            }
            this.settings.init(new File(this.configurationDirectory, "server-config.properties"));
        }
        event.registerServerCommand((ab)new CommandVoiceMute());
    }

    private Thread startVoiceServer() {
        this.serverNetwork = new ServerNetwork(this);
        this.serverNetwork.init();
        this.voiceServer = new MinecraftVoiceServer(this, EnumVoiceNetworkType.MINECRAFT);
        Thread thread = new Thread((Runnable)this.voiceServer, "Voice Server");
        thread.start();
        VoiceChat.getLogger().info("Started [" + this.voiceServer.getType().name + "] Server.");
        return thread;
    }

    public synchronized VoiceServer getVoiceServer() {
        return this.voiceServer;
    }

    public synchronized ServerNetwork getServerNetwork() {
        return this.serverNetwork;
    }

    public static synchronized Logger getLogger() {
        Logger l = Logger.getLogger("Gliby's Voice Chat Mod");
        l.setParent(FMLLog.getLogger());
        return l;
    }

    public void initClient(VoiceChat voiceChat, FMLStateEvent event) {
    }

    public void postInit(VoiceChat voiceChat, FMLPostInitializationEvent event) {
    }

    public void preInitServer(FMLServerAboutToStartEvent event) {
    }

    public String getVersion() {
        return VERSION;
    }

    public void preInitClient(FMLPreInitializationEvent event) {
    }

    public static String getMinecraftVersion() {
        return MC_VERSION;
    }

    public ServerSettings getServerSettings() {
        return this.settings;
    }
}

