/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.DataStream;
import net.gliby.voicechat.common.networking.ServerDatalet;
import net.gliby.voicechat.common.networking.ThreadDataQueue;
import net.gliby.voicechat.common.networking.ThreadKillDataStream;
import net.minecraft.server.MinecraftServer;

public class DataManager {
    public ConcurrentLinkedQueue<ServerDatalet> dataQueue;
    public ConcurrentHashMap<Integer, DataStream> streaming;
    private HashMap<Integer, List<Integer>> receivedEntityData;
    Thread threadKill;
    Thread treadQueue;
    VoiceChatServer voiceChat;
    public List<String> mutedPlayers;

    public DataManager(VoiceChatServer voiceChat) {
        this.voiceChat = voiceChat;
    }

    public void init() {
        this.mutedPlayers = new ArrayList<String>();
        this.dataQueue = new ConcurrentLinkedQueue();
        this.streaming = new ConcurrentHashMap();
        this.receivedEntityData = new HashMap();
        this.treadQueue = new Thread((Runnable)new ThreadDataQueue(this), "Stream Queue");
        this.treadQueue.start();
        this.threadKill = new Thread((Runnable)new ThreadKillDataStream(this), "Stream Kill");
        this.threadKill.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(Player player, byte[] decoded_data, int id, boolean end) {
        jv pl = (jv)player;
        if (this.mutedPlayers.contains(pl.bu)) {
            return;
        }
        this.dataQueue.offer(new ServerDatalet(player, id, decoded_data, end));
        Thread thread = this.treadQueue;
        synchronized (thread) {
            this.treadQueue.notify();
        }
    }

    public boolean newDatalet(ServerDatalet let) {
        return this.streaming.get(let.id) == null;
    }

    public void createStream(ServerDatalet data) {
        this.addStreamSafe(new DataStream(data.player, data.id, this.generateSource(data)));
        this.giveEntity(data);
        this.giveStream(data);
    }

    private void giveEntity(ServerDatalet data) {
        Player[] players = this.voiceChat.getServerNetwork().getPlayers();
        jv sender = (jv)data.player;
        for (int i = 0; i < players.length; ++i) {
            Player player = players[i];
            if (sender == (jv)player) continue;
            this.voiceChat.getVoiceServer().sendEntityData(player, sender.k, sender.an(), sender.u, sender.v, sender.w, sender.x, sender.y, sender.z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStreamSafe(DataStream stream) {
        if (this.streaming.get(stream.id) == null) {
            this.streaming.put(stream.id, stream);
            Thread thread = this.threadKill;
            synchronized (thread) {
                this.threadKill.notify();
            }
        }
    }

    public void giveStream(ServerDatalet let) {
        Player sender = let.player;
        if (sender != null) {
            this.sendVoiceToWorldWithinDistance(let, this.voiceChat.getServerSettings().getSoundDistance());
        }
        if (let.end) {
            this.killStream(let.id);
        }
    }

    public void sendVoiceToWorldWithinDistance(ServerDatalet let, int distance) {
        uf curPlayer = (uf)let.player;
        List players = curPlayer.q.h;
        int tickRate = MinecraftServer.F().aj();
        if (let.end) {
            for (int i = 0; i < players.size(); ++i) {
                double d6;
                double d5;
                double d4;
                uf player = (uf)players.get(i);
                if (player == curPlayer || !((d4 = curPlayer.u - player.u) * d4 + (d5 = curPlayer.v - player.v) * d5 + (d6 = curPlayer.w - player.w) * d6 < (double)(distance * distance))) continue;
                this.voiceChat.getVoiceServer().sendVoiceEnd((Player)player, let.id);
            }
        } else {
            for (int i = 0; i < players.size(); ++i) {
                double d6;
                double d5;
                double d4;
                uf player = (uf)players.get(i);
                if (player == curPlayer || !((d4 = curPlayer.u - player.u) * d4 + (d5 = curPlayer.v - player.v) * d5 + (d6 = curPlayer.w - player.w) * d6 < (double)(distance * distance))) continue;
                if (distance > 63) {
                    if (!this.hasEntityData(let.id, player.k)) {
                        this.voiceChat.getVoiceServer().sendEntityData((Player)player, let.id, curPlayer.an(), curPlayer.u, curPlayer.v, curPlayer.w, curPlayer.x, curPlayer.y, curPlayer.z);
                        this.addReceivedEntityData(let.id, player.k);
                    }
                    if (tickRate % 7 == 0) {
                        this.voiceChat.getVoiceServer().sendEntityPosition((Player)player, let.id, curPlayer.u, curPlayer.v, curPlayer.w, curPlayer.x, curPlayer.y, curPlayer.z);
                    }
                }
                this.voiceChat.getVoiceServer().sendVoiceData((Player)player, let.id, 1, let.data);
            }
        }
    }

    private String generateSource(ServerDatalet let) {
        return Integer.toString(let.id);
    }

    public void killStream(int id) {
        this.streaming.remove(id);
    }

    private void addReceivedEntityData(int id, int entityId) {
        List<Integer> list = this.receivedEntityData.get(id);
        if (list != null) {
            list.add(entityId);
        } else {
            list = new ArrayList<Integer>();
            list.add(entityId);
            this.receivedEntityData.put(id, list);
        }
    }

    public boolean hasEntityData(int entityID, int hasEntityID) {
        if (this.receivedEntityData.containsKey(entityID)) {
            return this.receivedEntityData.get(entityID).contains(hasEntityID);
        }
        return false;
    }

    public void playerDisconnect(uf player) {
        List<Integer> list = this.receivedEntityData.get(player.k);
        if (list != null) {
            this.receivedEntityData.remove(player.k);
        }
        for (Map.Entry<Integer, List<Integer>> pairs : this.receivedEntityData.entrySet()) {
            List<Integer> idList = this.receivedEntityData.get(pairs.getKey());
            for (int i = 0; i < idList.size(); ++i) {
                if (idList.get(i) != player.k) continue;
                idList.remove(i);
            }
        }
    }
}

