/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.common.networking.voiceservers;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import net.gliby.voicechat.common.VoiceChatServer;
import net.gliby.voicechat.common.networking.voiceservers.EnumVoiceNetworkType;
import net.gliby.voicechat.common.networking.voiceservers.VoiceServer;

public class MinecraftVoiceServer
extends VoiceServer {
    private VoiceChatServer voiceChat;

    public MinecraftVoiceServer(VoiceChatServer voiceChat, EnumVoiceNetworkType enumVoiceServer) {
        super(enumVoiceServer);
        this.voiceChat = voiceChat;
    }

    @Override
    public boolean start() {
        return false;
    }

    @Override
    public void handleVoiceData(Player player, byte[] data, int id, boolean end) {
        this.voiceChat.getServerNetwork().getDataManager().addQueue(player, data, id, end);
    }

    @Override
    public void sendVoiceData(Player player, int entityID, int global, byte[] samples) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        if (samples != null) {
            try {
                outputStream.writeInt(samples.length);
                for (int i = 0; i < samples.length; ++i) {
                    outputStream.writeByte(samples[i]);
                }
                outputStream.writeInt(entityID);
                outputStream.writeInt(global);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ea packet = new ea();
            packet.a = "GVC-SMPL";
            packet.c = bos.toByteArray();
            packet.b = bos.size();
            PacketDispatcher.sendPacketToPlayer((ey)packet, (Player)player);
        }
    }

    @Override
    public void sendChunkVoiceData(Player player, int entityID, int global, byte[] samples, int chunkSize) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        if (samples != null) {
            try {
                outputStream.writeInt(samples.length);
                for (int i = 0; i < samples.length; ++i) {
                    outputStream.writeByte(samples[i]);
                }
                outputStream.writeInt(chunkSize);
                outputStream.writeInt(entityID);
                outputStream.writeInt(global);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ea packet = new ea();
            packet.a = "GVC-CHSMPL";
            packet.c = bos.toByteArray();
            packet.b = bos.size();
            PacketDispatcher.sendPacketToPlayer((ey)packet, (Player)player);
        }
    }

    @Override
    public void sendVoiceEnd(Player player, int id) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ea packet = new ea();
        packet.a = "GVC-SMPLE";
        packet.c = bos.toByteArray();
        packet.b = bos.size();
        PacketDispatcher.sendPacketToPlayer((ey)packet, (Player)player);
    }

    @Override
    public void sendEntityData(Player player, int entityID, String name, double x, double y, double z2, double motX, double motY, double motZ) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(entityID);
            outputStream.writeUTF(name);
            outputStream.writeDouble(x);
            outputStream.writeDouble(y);
            outputStream.writeDouble(z2);
            outputStream.writeDouble(motX);
            outputStream.writeDouble(motY);
            outputStream.writeDouble(motZ);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ea packet = new ea();
        packet.a = "GVC-ED";
        packet.c = bos.toByteArray();
        packet.b = bos.size();
        PacketDispatcher.sendPacketToPlayer((ey)packet, (Player)player);
    }

    @Override
    public void sendEntityPosition(Player player, int entityID, double x, double y, double z2, double motX, double motY, double motZ) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(entityID);
            outputStream.writeDouble(x);
            outputStream.writeDouble(y);
            outputStream.writeDouble(z2);
            outputStream.writeDouble(motX);
            outputStream.writeDouble(motY);
            outputStream.writeDouble(motZ);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ea packet = new ea();
        packet.a = "GVC-E";
        packet.c = bos.toByteArray();
        packet.b = bos.size();
        PacketDispatcher.sendPacketToPlayer((ey)packet, (Player)player);
    }
}

