/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.fluids;

import abo.pipes.ABOPipe;
import abo.pipes.fluids.Neighbor;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TileGenericPipe;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsBalance
extends ABOPipe<PipeTransportFluids> {
    private final int blockTexture = 80;

    public PipeFluidsBalance(int itemID) {
        super(new PipeTransportFluids(), itemID);
        ((PipeTransportFluids)this.transport).flowRate = (short)160;
        ((PipeTransportFluids)this.transport).travelDelay = 1;
    }

    public int getIconIndex(ForgeDirection direction) {
        return 8;
    }

    public void updateEntity() {
        super.updateEntity();
        this.doWork();
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (tile == null || !(tile instanceof IFluidHandler) || tile instanceof TileGenericPipe) {
            return false;
        }
        return super.canPipeConnect(tile, side);
    }

    public void doWork() {
        LinkedList<Neighbor> neighbors = new LinkedList<Neighbor>();
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.container.getTile(o);
            if (tile == null || tile instanceof TileGenericPipe || !(tile instanceof IFluidHandler)) continue;
            Neighbor neighbor = new Neighbor((IFluidHandler)tile, o);
            neighbors.add(neighbor);
        }
        int fluidID = 0;
        int fluidAmount = 0;
        int fluidCapacity = 0;
        int fluidNeighbors = 0;
        for (FluidTankInfo tank : ((PipeTransportFluids)this.transport).getTankInfo(ForgeDirection.UNKNOWN)) {
            FluidStack fluid;
            if (tank == null || (fluid = tank.fluid) == null) continue;
            fluidAmount += fluid.amount;
        }
        FluidTankInfo tank = ((PipeTransportFluids)this.transport).getTankInfo(ForgeDirection.UNKNOWN)[0];
        FluidStack fluid = null;
        if (tank != null) {
            fluid = tank.fluid;
        }
        if (fluid != null && fluid.amount > 0) {
            fluidID = fluid.fluidID;
        }
        if (fluidID == 0) {
            Neighbor neighbor;
            Iterator i$ = neighbors.iterator();
            while (i$.hasNext() && ((neighbor = (Neighbor)i$.next()) == null || (fluidID = neighbor.getFluidId()) == 0)) {
            }
        }
        for (Neighbor neighbor : neighbors) {
            if (neighbor == null || neighbor.getFluidCapacity() <= 0 || fluidID != neighbor.getFluidId() && neighbor.getFluidId() != 0) continue;
            fluidAmount += neighbor.getFluidAmount();
            fluidCapacity += neighbor.getFluidCapacity();
            ++fluidNeighbors;
        }
        if (fluidCapacity == 0 || fluidNeighbors == 0) {
            return;
        }
        int liquidAverage = fluidAmount / fluidNeighbors;
        for (Neighbor neighbor : neighbors) {
            int filled;
            FluidStack liquidExtracted;
            int liquidToExtract = neighbor.getFluidAmount() - liquidAverage;
            if (liquidToExtract > 1) {
                liquidExtracted = neighbor.getTankEntity().drain(neighbor.getOrientation(), liquidToExtract > ((PipeTransportFluids)this.transport).flowRate ? (int)((PipeTransportFluids)this.transport).flowRate : liquidToExtract, false);
                if (liquidExtracted == null || (filled = ((PipeTransportFluids)this.transport).fill(neighbor.getOrientation(), liquidExtracted, true)) == 0) continue;
                liquidExtracted = neighbor.getTankEntity().drain(neighbor.getOrientation(), filled, true);
                continue;
            }
            if (liquidToExtract >= 1 || (liquidExtracted = ((PipeTransportFluids)this.transport).drain(neighbor.getOrientation().getOpposite(), liquidToExtract > ((PipeTransportFluids)this.transport).flowRate ? (int)((PipeTransportFluids)this.transport).flowRate : liquidToExtract, false)) == null || (filled = neighbor.getTankEntity().fill(neighbor.getOrientation().getOpposite(), liquidExtracted, true)) == 0) continue;
            liquidExtracted = ((PipeTransportFluids)this.transport).drain(neighbor.getOrientation().getOpposite(), filled, true);
        }
    }
}

