/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.fluids;

import abo.ABO;
import abo.network.IFluidSlotChange;
import abo.pipes.ABOPipe;
import buildcraft.core.network.IClientState;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeTransportFluids;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTankInfo;

public class PipeFluidsDistribution
extends ABOPipe<PipeTransportFluids>
implements IClientState,
IFluidSlotChange {
    public final Fluid[] fluids = new Fluid[54];

    public PipeFluidsDistribution(int itemID) {
        super(new PipeTransportFluids(), itemID);
        ((PipeTransportFluids)this.transport).flowRate = (short)160;
        ((PipeTransportFluids)this.transport).travelDelay = (short)2;
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().field_77993_c < Block.field_71973_m.length && Block.field_71973_m[entityplayer.func_71045_bC().field_77993_c] instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer)) {
            return true;
        }
        if (!this.container.field_70331_k.field_72995_K) {
            entityplayer.openGui((Object)ABO.instance, 100, this.container.field_70331_k, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        }
        return true;
    }

    public int getIconIndex(ForgeDirection direction) {
        switch (direction) {
            case UNKNOWN: {
                return 9;
            }
            case DOWN: {
                return 10;
            }
            case UP: {
                return 11;
            }
            case NORTH: {
                return 12;
            }
            case SOUTH: {
                return 13;
            }
            case WEST: {
                return 14;
            }
            case EAST: {
                return 15;
            }
        }
        throw new IllegalArgumentException("direction out of bounds");
    }

    public boolean outputOpen(ForgeDirection to) {
        if (!super.outputOpen(to)) {
            return false;
        }
        FluidTankInfo[] tanks = ((PipeTransportFluids)this.transport).getTankInfo(ForgeDirection.UNKNOWN);
        if (tanks == null || tanks[0] == null || tanks[0].fluid == null || tanks[0].fluid.amount == 0) {
            return true;
        }
        Fluid fluidInTank = tanks[0].fluid.getFluid();
        boolean[] validDirections = new boolean[ForgeDirection.values().length];
        boolean[] filteredDirections = new boolean[ForgeDirection.values().length];
        boolean filterForLiquid = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            validDirections[dir.ordinal()] = false;
            filteredDirections[dir.ordinal()] = false;
            if (!Utils.checkPipesConnections((TileEntity)this.container.getTile(dir), (TileEntity)this.container)) continue;
            for (int slot = 0; slot < 9; ++slot) {
                Fluid fluid = this.fluids[dir.ordinal() * 9 + slot];
                if (fluid == null) continue;
                filteredDirections[dir.ordinal()] = true;
                if (fluidInTank.getID() != fluid.getID()) continue;
                validDirections[dir.ordinal()] = true;
                filterForLiquid = true;
            }
        }
        if (filteredDirections[to.ordinal()] && validDirections[to.ordinal()]) {
            return true;
        }
        return !filterForLiquid && !filteredDirections[to.ordinal()];
    }

    public void writeData(DataOutputStream data) throws IOException {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.fluids.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (this.fluids[i] != null) {
                nbttagcompound.func_74778_a("FluidName", this.fluids[i].getName());
            }
            nbt.func_74782_a("fluidStack[" + i + "]", (NBTBase)nbttagcompound);
        }
        NBTBase.func_74731_a((NBTBase)nbt, (DataOutput)data);
    }

    public void readData(DataInputStream data) throws IOException {
        NBTBase nbt = NBTBase.func_74739_b((DataInput)data);
        if (nbt instanceof NBTTagCompound) {
            for (int i = 0; i < this.fluids.length; ++i) {
                NBTTagCompound nbttagcompound = ((NBTTagCompound)nbt).func_74775_l("fluidStack[" + i + "]");
                if (nbttagcompound == null) continue;
                this.fluids[i] = FluidRegistry.getFluid((String)nbttagcompound.func_74779_i("FluidName"));
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        for (int i = 0; i < this.fluids.length; ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.fluids[i] != null) {
                nbt.func_74778_a("FluidName", this.fluids[i].getName());
            }
            data.func_74782_a("fluidStack[" + i + "]", (NBTBase)nbt);
        }
        super.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        for (int i = 0; i < this.fluids.length; ++i) {
            NBTTagCompound nbttagcompound = data.func_74775_l("fluidStack[" + i + "]");
            if (nbttagcompound == null) continue;
            this.fluids[i] = FluidRegistry.getFluid((String)nbttagcompound.func_74779_i("FluidName"));
        }
    }

    @Override
    public void update(int slot, Fluid fluid) {
        if (fluid != this.fluids[slot]) {
            this.fluids[slot] = fluid;
        }
    }
}

