/*
 * Decompiled with CFR 0.152.
 */
package abo.pipes.fluids;

import abo.pipes.ABOPipe;
import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.IAction;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.triggers.ActionPipeDirection;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsGoldenIron
extends ABOPipe<PipeTransportFluids> {
    private final int standardIconIndex = 16;
    private final int solidIconIndex = 17;
    private final PipeLogicIron logic = new PipeLogicIron(this){

        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof TileGenericPipe) {
                Pipe otherPipe = ((TileGenericPipe)tile).pipe;
                if (otherPipe instanceof PipeFluidsWood || otherPipe instanceof PipeStructureCobblestone) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportFluids;
            }
            return tile instanceof IFluidHandler;
        }
    };

    public PipeFluidsGoldenIron(int itemID) {
        super(new PipeTransportFluids(), itemID);
        ((PipeTransportFluids)this.transport).flowRate = (short)80;
        ((PipeTransportFluids)this.transport).travelDelay = (short)2;
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    public void onNeighborBlockChange(int blockId) {
        this.logic.switchOnRedstone();
        super.onNeighborBlockChange(blockId);
    }

    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    public boolean outputOpen(ForgeDirection to) {
        return super.outputOpen(to) && this.logic.outputOpen(to);
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 16;
        }
        int metadata = this.container.func_70322_n();
        if (metadata != direction.ordinal()) {
            return 17;
        }
        return 16;
    }

    protected void actionsActivated(Map<IAction, Boolean> actions) {
        super.actionsActivated(actions);
        for (Map.Entry<IAction, Boolean> action : actions.entrySet()) {
            if (!(action.getKey() instanceof ActionPipeDirection) || action.getValue() == null || !action.getValue().booleanValue()) continue;
            this.logic.setFacing(((ActionPipeDirection)action.getKey()).direction);
            break;
        }
    }

    public LinkedList<IAction> getActions() {
        LinkedList action = super.getActions();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    public boolean canConnectRedstone() {
        return true;
    }
}

